<!-- Copyright (c) 2009, 2011-2013 by Cisco Systems, Inc. -->
// smartports.js - Will create the ports panel for Stout devices
// <include a list of SKUs here>
/*	Murphys
	*******
	WS-C2960S-48FPD-L	: 48 10/100/1000 ports & 2 SFP+ ports
	WS-C2960S-48LPD-L	: 48 10/100/1000 ports & 2 SFP+ ports
	WS-C2960S-48TD-L	: 48 10/100/1000 ports & 2 SFP+ ports
	WS-C2960S-24PD-L	: 24 10/100/1000 ports & 2 SFP+ ports
	WS-C2960S-24TD-L	: 24 10/100/1000 ports & 2 SFP+ ports
	Guinness
	********
	WS-C2960S-48FPS-L	: 48 10/100/1000 ports & 4 SFP ports
	WS-C2960S-48LPS-L	: 48 10/100/1000 ports & 4 SFP ports
	WS-C2960S-48TS-L	: 48 10/100/1000 ports & 4 SFP ports
	WS-C2960S-24PS-L	: 24 10/100/1000 ports & 4 SFP ports
	WS-C2960S-24TS-L	: 24 10/100/1000 ports & 4 SFP ports
	Beamish	
	*******
	WS-C2960S-48TS-S	: 48 10/100/1000 ports & 2 SFP ports
	WS-C2960S-24TS-S	: 24 10/100/1000 ports & 2 SFP ports	
	
	StoutFE PIDS:-
	Guinness
	********
	WS-C2960S-F48FPS-L	: 48 10/100 ports & 4 SFP ports
	WS-C2960S-F48LPS-L	: 48 10/100 ports & 4 SFP ports
	WS-C2960S-F48TS-L	: 48 10/100 ports & 4 SFP ports
	WS-C2960S-F24PS-L	: 24 10/100 ports & 2 SFP ports
	WS-C2960S-F24TS-L	: 24 10/100 ports & 2 SFP ports
	Beamish	
	*******
	WS-C2960S-F48TS-S	: 48 10/100 ports & 2 SFP ports
	WS-C2960S-F24TS-S	: 24 10/100 ports & 2 SFP ports	
	
	
	Porter PIDS:-
	Sierra
	******
	WS-C2960X-48TS-L    : 48 10/100/1000 ports & 4 SFP ports
	WS-C2960X-48FPS-L   : 48 10/100/1000 ports & 4 SFP ports
    WS-C2960X-48LPS-L   : 48 10/100/1000 ports & 4 SFP ports
    WS-C2960X-24PS-L    : 24 10/100/1000 ports & 4 SFP ports
    Fullers
	*******
	WS-C2960X-48FPD-L   : 48 10/100/1000 ports & 2 SFP+ ports
    WS-C2960X-48LPD-L   : 48 10/100/1000 ports & 2 SFP+ ports
    WS-C2960X-48TD-L    : 48 10/100/1000 ports & 2 SFP+ ports
    WS-C2960X-24PD-L    : 24 10/100/1000 ports & 2 SFP+ ports
    WS-C2960X-24TD-L    : 24 10/100/1000 ports & 2 SFP+ ports
    Alaskan
	*******
	WS-C2960X-48LPS-S   : 48 10/100/1000 ports & 2 SFP ports
    WS-C2960X-24PS-S    : 24 10/100/1000 ports & 2 SFP ports 
    WS-C2960X-48TS-LL    : 48 10/100/1000 ports & 2 SFP ports
    WS-C2960X-24TS-LL    : 24 10/100/1000 ports & 2 SFP ports
   	
	KingFisher PIDS.	
	Fullers : WS-C2960XR-48FPD-I,WS-C2960XR-48LPD-I,WS-C2960XR-48TD-I,WS-C2960XR-24PD-I,WS-C2960XR-24TD-I 
	(2 SFP+)  WS-C2960XR-48FPD-L,WS-C2960XR-48LPD-L,WS-C2960XR-48TD-L,WS-C2960XR-24PD-L,WS-C2960XR-24TD-L
	Sierra  : WS-C2960XR-48LPS-I,WS-C2960XR-48FPS-I,WS-C2960XR-48TS-I,WS-C2960XR-24PS-I,WS-C2960XR-24TS-I
	(4 SFP)  WS-C2960XR-48LPS-L,WS-C2960XR-48FPS-L,WS-C2960XR-48TS-L,WS-C2960XR-24PS-L,WS-C2960XR-24TS-L
	
  */

function createDevice(deviceType, uiPortDataArr) {
	var device = null;
	if(deviceType == null)
		return device;
	if(deviceType == "WS-C2960S-48TS-S") {
		device = new WSC2960X48TSS(uiPortDataArr);
	} else if(deviceType == "WS-C2960S-24TS-S") {
		device = new WSC2960X24TSS(uiPortDataArr);
	} else if(deviceType == "WS-C2960S-24PS-L" || deviceType == "WS-C2960S-24TS-L") {
		device = new WSC2960XS24(uiPortDataArr);
	} else if(deviceType == "WS-C2960S-48FPS-L" || deviceType == "WS-C2960S-48TS-L" || deviceType == "WS-C2960S-48LPS-L") {
		device = new WSC2960XS48(uiPortDataArr);
	} else if(deviceType == "WS-C2960S-24TD-L" || deviceType == "WS-C2960S-24PD-L") {
		device = new WSC2960XS24_10G(uiPortDataArr);
	} else if(deviceType == "WS-C2960S-48TD-L" || deviceType == "WS-C2960S-48LPD-L" || deviceType == "WS-C2960S-48FPD-L") {
		device = new WSC2960XS48_10G(uiPortDataArr);
	}// StoutFE Support
	else if(deviceType == "WS-C2960S-F48TS-S" || deviceType == "WS-C2960S-F48TS-L" || deviceType == "WS-C2960S-F48FPS-L" ||  deviceType == "WS-C2960S-F48LPS-L"){ //Murphys48FullPWR & Murphys48PWR  
		device = new stoutFE_48ports(deviceType,uiPortDataArr); 
	}
	else if(deviceType == "WS-C2960S-F24TS-S" || deviceType == "WS-C2960S-F24TS-L" || deviceType == "WS-C2960S-F24PS-L"){ //Murphys48FullPWR & Murphys48PWR  
		device = new stoutFE_24ports(uiPortDataArr); 
	} // Porter Support
	else if(deviceType =="WS-C2960X-48FPD-L" || deviceType =="WS-C2960X-48LPD-L" || deviceType == "WS-C2960X-48TD-L" ) {
		device = new porter_48Ports(deviceType,uiPortDataArr);
	}
	else if( deviceType =="WS-C2960X-48TS-LL") //deviceType == "WS-C2960X-48LPS-S"
	{
		device = new porter_48Ports_2SFP_Vertical(deviceType,uiPortDataArr);
	}
	else if(deviceType == "WS-C2960X-48FPS-L" || deviceType == "WS-C2960X-48LPS-L" || deviceType == "WS-C2960X-48TS-L") {
		device = new porter_48Ports_4SFP_Vertical(deviceType,uiPortDataArr);
	}
	else if(deviceType == "WS-C2960X-24PD-L" || deviceType =="WS-C2960X-24TD-L") {
	    device = new porter_24Ports(deviceType,uiPortDataArr);
	}
	//else if(deviceType == "WS-C2960X-24PSK-L") {
	//    device = new porter_24Ports_4SFP(deviceType,uiPortDataArr);
	//}
	else if(deviceType == "WS-C2960X-24TS-LL" ) //|| deviceType =="WS-C2960X-24PS-S"
	{ 
	    device = new porter_24Ports_2SFP_Vertical(deviceType,uiPortDataArr);
	}
	else if(deviceType == "WS-C2960X-24PS-L" || deviceType =="WS-C2960X-24TS-L" ) { 
	    device = new porter_24Ports_4SFP_Vertical(deviceType,uiPortDataArr);
	}
	//Kingfisher code started
	else if(deviceType == "WS-C2960XR-48FPD-I" || deviceType == "WS-C2960XR-48LPD-I" || deviceType == "WS-C2960XR-48TD-I" || deviceType == "WS-C2960XR-48FPD-L" || deviceType == "WS-C2960XR-48LPD-L" || deviceType == "WS-C2960XR-48TD-L") {
		device = new kingfisher_48Ports(deviceType,uiPortDataArr);
	}
	else if(deviceType == "WS-C2960XR-48LPS-I" || deviceType == "WS-C2960XR-48FPS-I" || deviceType == "WS-C2960XR-48TS-I" || deviceType == "WS-C2960XR-48LPS-L" || deviceType == "WS-C2960XR-48FPS-L" || deviceType == "WS-C2960XR-48TS-L") {
	    device = new kingfisher_48Ports_4SFP_Vertical(deviceType,uiPortDataArr);
	}
	else if(deviceType == "WS-C2960XR-24PD-I" || deviceType == "WS-C2960XR-24TD-I" || deviceType == "WS-C2960XR-24PD-L" || deviceType == "WS-C2960XR-24TD-L" ) { 
	    device = new kingfisher_24Ports(deviceType,uiPortDataArr);
	}
	else if(deviceType == "WS-C2960XR-24PS-I" || deviceType == "WS-C2960XR-24TS-I" || deviceType == "WS-C2960XR-24PS-L" || deviceType == "WS-C2960XR-24TS-L" ) { 
	    device = new kingfisher_24Ports_4SFP_Vertical(deviceType,uiPortDataArr);
	}
	
}

function WSC2960X24TSS(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-2; portId++) {
  		// This is extra space between port groups
		if(portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "30" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-2; portId++) {
		// This is extra space between port groups
		if(portId == 12) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	for (var portId = portCount-2; portId<portCount; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "30" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function WSC2960X48TSS(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-2; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-2; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 24 || portId == 36) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	for (var portId = portCount-2; portId<portCount; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function WSC2960XS24(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "38" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId=0; portId<portCount-4; portId++) {
  		// This is extra space between port groups
		if( portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(1500); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	
	//Empty rows for padding
	document.writeln('<tr><td colspan= "38" height="5" bgcolor="#f4f4f4"></td></tr>');	
	document.writeln('<tr><td colspan= "38" height="3" bgcolor="#f4f4f4"></td></tr>');
	
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId=0; portId<portCount-4; portId++) {
		//Space between port groups
		if( portId == 12) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();	writeSpaceCell();

	for (var portId = portCount-4; portId < portCount ; portId++) {
		document.writeln('\
		<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
		face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
		</font><a href="javascript:void(0)"\
		onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
		onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
		onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
		onMouseUp="window.status=\'\'; return true"\
		onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
		src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
		border="0"\
		width="21" height="21" name="cell', '_', portId, '"></a></td>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
	
	//writeSpaceCell();	writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "38" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function WSC2960XS48(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "52" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId=0; portId<portCount-4; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(1500); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	
	//Empty rows for padding
	document.writeln('<tr><td colspan= "52" height="5" bgcolor="#f4f4f4"></td></tr>');	
	document.writeln('<tr><td colspan= "52" height="3" bgcolor="#f4f4f4"></td></tr>');
	
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId=0; portId<portCount-4; portId++) {
		//Space between port groups
		if(portId == 12 || portId == 24 || portId == 36) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();	writeSpaceCell();

	for (var portId = portCount-4; portId < portCount ; portId++) {
		document.writeln('\
		<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
		face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
		</font><a href="javascript:void(0)"\
		onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
		onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
		onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
		onMouseUp="window.status=\'\'; return true"\
		onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
		src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
		border="0"\
		width="21" height="21" name="cell', '_', portId, '"></a></td>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
	
	//writeSpaceCell();	writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "52" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function WSC2960XS24_10G(uiPortDataArr) { //WSC2960GS24PSL
	var MAX_PORTS = 26;
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "50" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<24; portId++) {
  		// This is extra space between port groups
		if(portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	for (var portId = 24; portId<portCount ; portId++) {
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "50" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "50" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<24; portId++) {
		// This is extra space between port groups
		if(portId == 12) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	for (var portId = portCount-2; portId<portCount ; portId++) {
		if(uiPortDataArr[portId].portName.indexOf("/25") > 0 ) { //Gi25 or Te1 
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}
		else if(uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/1") > 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}
	}
	for (var portId = portCount-2; portId<portCount ; portId++) { //Gi26 or Te2
		if(uiPortDataArr[portId].portName.indexOf("/26") > 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}else if(uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/2") > 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "50" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function WSC2960XS48_10G(uiPortDataArr) {
	var MAX_PORTS = 50;
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "50" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<48; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	for (var portId = 48; portId<portCount ; portId++) {
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "50" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "50" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<48; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 24 || portId == 36) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	for (var portId = portCount-2; portId<portCount ; portId++) {
		if(uiPortDataArr[portId].portName.indexOf("/49") > 0 ) { //Gi49 or Te1 
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}
		else if(uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/1") > 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}
	}
	for (var portId = portCount-2; portId<portCount ; portId++) { //Gi50 or Te2
		if(uiPortDataArr[portId].portName.indexOf("/50") > 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}else if(uiPortDataArr[portId].portName.indexOf("Te") == 0 && uiPortDataArr[portId].portName.indexOf("/2") > 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "50" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function stoutFE_24ports(uiPortDataArr) {
	portCount = 26;
	document.writeln('<tr><td colspan= "29" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId=0; portId<portCount-2; portId++) {
  		// This is extra space between port groups
		if( portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(1500); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	//document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();	writeSpaceCell(); writeSpaceCell();
	//document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	//document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	
	//Empty rows for padding
	document.writeln('<tr><td colspan= "29" height="5" bgcolor="#f4f4f4"></td></tr>');	
	document.writeln('<tr><td colspan= "29" height="3" bgcolor="#f4f4f4"></td></tr>');
	
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	
	for (var portId=0; portId<portCount-2; portId++) {
		//Space between port groups
		if( portId == 12) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();	writeSpaceCell();

	for (var portId = portCount-2; portId < portCount ; portId++) {
		document.writeln('\
		<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
		face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
		</font><a href="javascript:void(0)"\
		onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
		onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
		onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
		onMouseUp="window.status=\'\'; return true"\
		onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
		src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
		border="0"\
		width="21" height="21" name="cell', '_', portId, '"></a></td>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
	
	//writeSpaceCell();	writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "29" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function stoutFE_48ports(deviceType,uiPortDataArr) {
	
	var giga_portCount = 0;
	if(deviceType == "WS-C2960S-F48TS-S")
	{
		giga_portCount = 2;
	}
	else if(deviceType == "WS-C2960S-F48TS-L" || deviceType == "WS-C2960S-F48FPS-L" || deviceType == "WS-C2960S-F48LPS-L")
	{
		giga_portCount = 4;
	}
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "'+(giga_portCount == 2 ? 44 : 37)+'" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-giga_portCount; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	if(giga_portCount == 2)
	{
		//Cells to compensate for Gigabit ports in second row
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
			
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('</tr>');
		//Padding rows
		//document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4"></td></tr>');
		//document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4"></td></tr>');
	}
	else
	{
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
		//Padding rows
		//document.writeln('<tr><td colspan= "37" height="5" bgcolor="#f4f4f4"></td></tr>');
		//document.writeln('<tr><td colspan= "37" height="3" bgcolor="#f4f4f4"></td></tr>');
	}
	//Padding rows
	document.writeln('<tr><td colspan= "'+(giga_portCount == 2 ? 44 : 37)+'" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "'+(giga_portCount == 2 ? 44 : 37)+'" height="3" bgcolor="#f4f4f4"></td></tr>');
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-giga_portCount; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 24 || portId == 36) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	for (var portId = portCount-giga_portCount; portId<portCount; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				if(giga_portCount == 2)
				{
					writeSpaceCell();writeSpaceCell();writeSpaceCell();
				}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "'+(giga_portCount == 2 ? 44 : 37)+'" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function porter_24Ports(deviceType, uiPortDataArr) {
	
	portCount = 26;
	
	document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	for (var portId=0; portId<portCount-2; portId++) {
  		// This is extra space between port groups
		if(portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="3" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="3" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-2; portId++) {
		// This is extra space between port groups
		if(portId == 12) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	for (var portId = portCount-2; portId<portCount; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				document.writeln('<td nowrap width="3" bgcolor="#f4f4f4">&nbsp;</td>');
	}
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function porter_24Ports_4SFP(deviceType, uiPortDataArr) {
	
	portCount = 28;
	
	document.writeln('<tr><td colspan= "25" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	for (var portId=0; portId<portCount-4; portId++) {
  		// This is extra space between port groups
		if(portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="2" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="2" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="2" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="2" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "25" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "25" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-4; portId++) {
		// This is extra space between port groups
		if(portId == 12) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	for (var portId = portCount-4; portId<portCount; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				document.writeln('<td nowrap width="2" bgcolor="#f4f4f4">&nbsp;</td>');
	}
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "25" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}


function porter_24Ports_2SFP_Vertical(deviceType, uiPortDataArr) {
	portCount = 26; 
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount; portId++) {
  		// This is extra space between port groups
		if(portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		if(portId == 23) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row		
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	//document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();writeSpaceCell();writeSpaceCell();
	//document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();writeSpaceCell();writeSpaceCell();
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "30" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount; portId++) {
		// This is extra space between port groups
		if(portId == 12) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		if(portId == 24) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	/*for (var portId = portCount-2; portId<portCount; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}*/
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "30" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function porter_24Ports_4SFP_Vertical(deviceType, uiPortDataArr) {
	
	portCount = 28; 
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount; portId++) {
  		// This is extra space between port groups
		if(portId == 11 ||  portId == 25) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		if(portId == 23) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row		
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	//document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();writeSpaceCell();writeSpaceCell();
	//document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();writeSpaceCell();writeSpaceCell();
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "30" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 26) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		if(portId == 24) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	/*for (var portId = portCount-2; portId<portCount; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}*/
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "30" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function porter_48Ports(deviceType, uiPortDataArr) {
	
	
	portCount = 50;
	
	document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-2; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-2; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 24 || portId == 36) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	for (var portId = portCount-2; portId<portCount; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function porter_48Ports_4SFP_Vertical(deviceType, uiPortDataArr) {
	
	portCount = 52;
	
	document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	for (var portId=0; portId<portCount; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35 || portId == 49 ) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		else if(portId == 47)
		{
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	for (var portId=0; portId<portCount; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 24 || portId == 36 || portId == 50) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		else if(portId == 48)
		{
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function porter_48Ports_2SFP_Vertical(deviceType, uiPortDataArr) {
	
	portCount = 50;
	
	document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	for (var portId=0; portId<portCount; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35 ) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		else if(portId == 47)
		{
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	for (var portId=0; portId<portCount; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 24 || portId == 36 ) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		else if(portId == 48)
		{
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function kingfisher_24Ports(deviceType, uiPortDataArr) {
	
	portCount = 26;
	
	document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	for (var portId=0; portId<portCount-2; portId++) {
  		// This is extra space between port groups
		if(portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="3" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="3" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "21" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-2; portId++) {
		// This is extra space between port groups
		if(portId == 12) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	for (var portId = portCount-2; portId<portCount; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				document.writeln('<td nowrap width="3" bgcolor="#f4f4f4">&nbsp;</td>');
	}
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "21" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function kingfisher_24Ports_4SFP_Vertical(deviceType, uiPortDataArr) {
	
	portCount = 28; 
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount; portId++) {
  		// This is extra space between port groups
		if(portId == 11 ||  portId == 25) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		if(portId == 23) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row		
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	//document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();writeSpaceCell();writeSpaceCell();
	//document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	//writeSpaceCell();writeSpaceCell();writeSpaceCell();
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "30" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 26) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		if(portId == 24) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	/*for (var portId = portCount-2; portId<portCount; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}*/
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "30" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function kingfisher_48Ports(deviceType, uiPortDataArr) {
	
	
	portCount = 50;
	
	document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-2; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-2; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 24 || portId == 36) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	for (var portId = portCount-2; portId<portCount; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function kingfisher_48Ports_4SFP_Vertical(deviceType, uiPortDataArr) {
	
	portCount = 52;
	
	document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	for (var portId=0; portId<portCount; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35 || portId == 49 ) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		else if(portId == 47)
		{
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "44" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	for (var portId=0; portId<portCount; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 24 || portId == 36 || portId == 50) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		else if(portId == 48)
		{
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	document.writeln('<tr><td colspan= "44" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}


function getPortLabel(intName) {
	var tmpStr = intName.substring(intName.indexOf('/')+1);
	var intNumber = tmpStr.substring(tmpStr.indexOf('/')+1);
	return parseInt(intNumber)
}

function isExtVlanSupported() {
	return true;
}

function getMaxVlans() {
  	return 250;	
}


