/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.image.ImageObserver;

public abstract class c3500Switch
extends CommonSwitch {
    static final int SYSTEM_LED_Y_LOCATION = 37;
    static final int RPS_LED_Y_LOCATION = 44;
    static final int STAT_LED_Y_LOCATION = 51;
    static final int DUPLEX_LED_Y_LOCATION = 58;
    static final int SPEED_LED_Y_LOCATION = 65;

    public c3500Switch(String string) {
        super(string);
        this.Cli = new c2900CLIs(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.statusCode.equals("Down")) {
            return;
        }
        this.Mode = this.Mode == 2 ? 0 : ++this.Mode;
        ((Component)((Object)this)).repaint();
        int n = 0;
        while (n < this.slot0PortNumbers) {
            switch (this.Mode) {
                case 0: {
                    this.slot0Ports[n].portLED = this.slot0Ports[n].statusLED;
                    this.slot0Ports[n].repaint();
                    break;
                }
                case 1: {
                    this.slot0Ports[n].portLED = this.slot0Ports[n].duplexLED;
                    this.slot0Ports[n].repaint();
                    break;
                }
                case 2: {
                    this.slot0Ports[n].portLED = this.slot0Ports[n].speedLED;
                    this.slot0Ports[n].repaint();
                    break;
                }
            }
            ++n;
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.HostName = this.switchName;
        graphics.drawImage(this.ModelImage, 0, 10, (ImageObserver)((Object)this));
        graphics.setColor(new Color(112, 145, 170));
        graphics.fillPolygon(this.x1, this.y1, 4);
        graphics.setColor(new Color(52, 85, 110));
        graphics.fillPolygon(this.x2, this.y3, 4);
        graphics.setColor(Color.black);
        graphics.fillPolygon(this.x4, this.y4, 3);
        graphics.fillPolygon(this.x5, this.y6, 3);
        this.Height = this.ModelImage.getHeight((ImageObserver)((Object)this));
        graphics.setColor(Color.white);
        if (this.HostName.equals("NA") && this.statusCode.equals("Down")) {
            graphics.drawString("Unknown Device", 70, 21);
            graphics.drawString("Unknown Device", 575, 21);
        } else {
            graphics.drawString(this.HostName, 70, 21);
            graphics.drawString(this.switchBoxName, 575, 21);
        }
        if (this.memberType.equals("CC") || this.memberType.equals("AC")) {
            graphics.setColor(Color.orange);
            graphics.drawString(this.IPAddress, 290, 21);
        }
        if (this.statusCode.equals("Down")) {
            graphics.setColor(Color.red);
            graphics.drawString("Switch is down", 290, 21);
        }
        graphics.setColor(Color.white);
        graphics.setFont(new Font("TimesRoman", 0, 10));
        graphics.drawImage(SVGetImages.greenled, 42, 37, 6, 2, (ImageObserver)((Object)this));
        if (this.rpsLED.equals("GREEN")) {
            graphics.drawImage(SVGetImages.greenled, 41, 44, 6, 2, (ImageObserver)((Object)this));
        } else if (this.rpsLED.equals("AMBER")) {
            graphics.drawImage(SVGetImages.amberled, 41, 44, 6, 2, (ImageObserver)((Object)this));
        } else if (this.rpsLED.equals("blinkGREEN")) {
            graphics.drawImage(SVGetImages.rpsblink, 41, 44, 6, 2, (ImageObserver)((Object)this));
        } else {
            graphics.drawImage(SVGetImages.blackled, 41, 44, 6, 2, (ImageObserver)((Object)this));
        }
        switch (this.Mode) {
            case 0: {
                graphics.drawImage(SVGetImages.greenled, 41, 51, 6, 2, (ImageObserver)((Object)this));
                graphics.drawImage(SVGetImages.blackled, 40, 58, 6, 2, (ImageObserver)((Object)this));
                graphics.drawImage(SVGetImages.blackled, 39, 65, 6, 2, (ImageObserver)((Object)this));
                break;
            }
            case 1: {
                graphics.drawImage(SVGetImages.blackled, 41, 51, 6, 2, (ImageObserver)((Object)this));
                graphics.drawImage(SVGetImages.greenled, 40, 58, 6, 2, (ImageObserver)((Object)this));
                graphics.drawImage(SVGetImages.blackled, 39, 65, 6, 2, (ImageObserver)((Object)this));
                break;
            }
            case 2: {
                graphics.drawImage(SVGetImages.blackled, 41, 51, 6, 2, (ImageObserver)((Object)this));
                graphics.drawImage(SVGetImages.blackled, 40, 58, 6, 2, (ImageObserver)((Object)this));
                graphics.drawImage(SVGetImages.greenled, 39, 65, 6, 2, (ImageObserver)((Object)this));
                break;
            }
            default: {
                graphics.drawImage(SVGetImages.modestat, 2, 118, (ImageObserver)((Object)this));
            }
        }
    }

    public boolean support802Dot1p() {
        String string = this.Cli.getSwVersion(this.esn);
        return (string.indexOf("XP") != -1 || string.indexOf("XU") != -1 || string.toUpperCase().indexOf("WC") != -1 || string.indexOf("XW") != -1) && this.enterpriseEdition;
    }

    public boolean supportCGMP() {
        return true;
    }

    public boolean supportPortGroup() {
        return true;
    }

    public boolean supportSPAN() {
        return true;
    }

    public boolean supportTel() {
        return false;
    }

    public boolean supportVtpVlan() {
        return this.enterpriseEdition;
    }

    public void update(Graphics graphics) {
        ((Container)((Object)this)).paintComponents(graphics);
    }
}

