/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class STPRootConfig_JDialog
extends STPMultiSelect_JDialog {
    JPanel rootConfig_JPanel = new JPanel();
    JLabel protocol_JLabel = new JLabel();
    JLabel priority_JLabel = new JLabel();
    JLabel maxAge_JLabel = new JLabel();
    JLabel helloTime_JLabel = new JLabel();
    JLabel JLabel5 = new JLabel();
    JComboBox protocol_JComboBox = new JComboBox();
    JTextField priority_JTextField = new JTextField();
    JTextField maxAge_JTextField = new JTextField();
    JTextField helloTime_JTextField = new JTextField();
    JTextField forwardDelay_JTextField = new JTextField();
    JButton ok_JButton = new JButton();
    JButton cancel_JButton = new JButton();
    JButton help_JButton = new JButton("Help");

    public STPRootConfig_JDialog(JApplet jApplet, STP_JDialog sTP_JDialog, Vector vector, Vector vector2) {
        super(jApplet, sTP_JDialog, vector, vector2);
        this.setTitle("STP Root Configuration");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(332, 305);
        this.setVisible(false);
        this.rootConfig_JPanel.setLayout(null);
        this.getContentPane().add(this.rootConfig_JPanel);
        this.protocol_JLabel.setText("Protocol:");
        this.rootConfig_JPanel.add(this.protocol_JLabel);
        this.protocol_JLabel.setBounds(14, 12, 185, 28);
        this.priority_JLabel.setText("Priority (0-65535):");
        this.rootConfig_JPanel.add(this.priority_JLabel);
        this.priority_JLabel.setBounds(14, 49, 185, 28);
        this.maxAge_JLabel.setText("Max Age (6-200 Seconds):");
        this.rootConfig_JPanel.add(this.maxAge_JLabel);
        this.maxAge_JLabel.setBounds(14, 86, 185, 28);
        this.helloTime_JLabel.setText("Hello Time (1-10 Seconds):");
        this.rootConfig_JPanel.add(this.helloTime_JLabel);
        this.helloTime_JLabel.setBounds(14, 123, 185, 28);
        this.JLabel5.setText("Forward Delay (4-200 Seconds):");
        this.rootConfig_JPanel.add(this.JLabel5);
        this.JLabel5.setBounds(14, 160, 185, 28);
        this.rootConfig_JPanel.add(this.protocol_JComboBox);
        this.protocol_JComboBox.setBounds(197, 14, 82, 28);
        this.rootConfig_JPanel.add(this.priority_JTextField);
        this.priority_JTextField.setBounds(197, 50, 82, 28);
        this.rootConfig_JPanel.add(this.maxAge_JTextField);
        this.maxAge_JTextField.setBounds(197, 86, 82, 28);
        this.rootConfig_JPanel.add(this.helloTime_JTextField);
        this.helloTime_JTextField.setBounds(197, 122, 82, 28);
        this.rootConfig_JPanel.add(this.forwardDelay_JTextField);
        this.forwardDelay_JTextField.setBounds(197, 158, 82, 28);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.ok_JButton.setText("OK");
        jPanel.add(this.ok_JButton);
        this.cancel_JButton.setText("Cancel");
        jPanel.add(this.cancel_JButton);
        jPanel.add(this.help_JButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.rootConfig_JPanel.setBorder(BorderFactory.createTitledBorder("Root Switch Options"));
        this.protocol_JComboBox.addItem(" ");
        this.protocol_JComboBox.addItem("IEEE");
        this.protocol_JComboBox.addItem("IBM");
        this.priority_JTextField.setText("");
        this.maxAge_JTextField.setText("");
        this.helloTime_JTextField.setText("");
        this.forwardDelay_JTextField.setText("");
        if (vector.size() == 1 && sTP_JDialog != null) {
            int n = sTP_JDialog.rootParamsPane.getTable().getSelectedRow();
            String string = (String)sTP_JDialog.rootParamsPane.getTable().getValueAt(n, sTP_JDialog.rootParamsPane.getTable().getColumnModel().getColumnIndex("Protocol"));
            this.protocol_JComboBox.setSelectedItem(string);
            this.priority_JTextField.setText((String)sTP_JDialog.rootParamsPane.getTable().getValueAt(n, sTP_JDialog.rootParamsPane.getTable().getColumnModel().getColumnIndex("Priority")));
            this.maxAge_JTextField.setText((String)sTP_JDialog.rootParamsPane.getTable().getValueAt(n, sTP_JDialog.rootParamsPane.getTable().getColumnModel().getColumnIndex("Max Age")));
            this.helloTime_JTextField.setText((String)sTP_JDialog.rootParamsPane.getTable().getValueAt(n, sTP_JDialog.rootParamsPane.getTable().getColumnModel().getColumnIndex("Hello Time")));
            this.forwardDelay_JTextField.setText((String)sTP_JDialog.rootParamsPane.getTable().getValueAt(n, sTP_JDialog.rootParamsPane.getTable().getColumnModel().getColumnIndex("Forward Delay")));
        }
        this.ok_JButton.addActionListener(this);
        this.cancel_JButton.addActionListener(this);
        this.help_JButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.help_JButton) {
            HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"stpcfg");
        } else if (actionEvent.getSource() == this.ok_JButton) {
            ((Component)this).setCursor(new Cursor(3));
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n = this.protocol_JComboBox.getSelectedIndex();
            switch (n) {
                case -1: 
                case 0: {
                    string = null;
                    break;
                }
                case 1: {
                    string = "IEEE";
                    break;
                }
                case 2: {
                    string = "IBM";
                    break;
                }
                default: {
                    string = null;
                }
            }
            string2 = this.priority_JTextField.getText().trim();
            if (!this.priorityValid(string2)) {
                this.rangeError("Priority", "0", "65535");
                return;
            }
            string3 = this.maxAge_JTextField.getText().trim();
            if (!this.maxAgeValid(string3)) {
                this.rangeError("Max Age", "6", "200");
                return;
            }
            string4 = this.helloTime_JTextField.getText().trim();
            if (!this.helloTimeValid(string4)) {
                this.rangeError("Hello Time", "1", "10");
                return;
            }
            string5 = this.forwardDelay_JTextField.getText().trim();
            if (!this.forwardTimeValid(string5)) {
                this.rangeError("Forward Delay", "4", "200");
                return;
            }
            if (string != null || string2.compareTo("") != 0 || string3.compareTo("") != 0 || string4.compareTo("") != 0 || string5.compareTo("") != 0) {
                CommonIOSCLIs commonIOSCLIs = null;
                String string6 = null;
                String string7 = null;
                int n2 = 0;
                while (n2 < this.selectedItems.size()) {
                    commonIOSCLIs = ((CommonSwitch)this.selectedDevices.elementAt((int)n2)).Cli;
                    string6 = ((CommonSwitch)this.selectedDevices.elementAt((int)n2)).esn;
                    string7 = (String)this.selectedItems.elementAt(n2);
                    if (string != null) {
                        commonIOSCLIs.setVLANProtocol(string6, string7, string);
                    }
                    if (string2.compareTo("") != 0) {
                        commonIOSCLIs.setVLANPriority(string6, string7, string2);
                    }
                    if (string3.compareTo("") != 0) {
                        commonIOSCLIs.setVLANMaxAge(string6, string7, string3);
                    }
                    if (string4.compareTo("") != 0) {
                        commonIOSCLIs.setVLANHelloTime(string6, string7, string4);
                    }
                    if (string5.compareTo("") != 0) {
                        commonIOSCLIs.setVLANForwardDelay(string6, string7, string5);
                    }
                    ++n2;
                }
                if (this.stpParent != null) {
                    this.stpParent.updateTable(this.stpParent.getRootParamsPane().getTable());
                }
            }
            ((Component)this).setCursor(new Cursor(0));
            this.dispose();
        } else {
            this.dispose();
        }
    }

    protected boolean forwardTimeValid(String string) {
        if (string.equals("")) {
            return true;
        }
        return Validation.isValidInteger(string, 4, 200);
    }

    protected boolean helloTimeValid(String string) {
        if (string.equals("")) {
            return true;
        }
        return Validation.isValidInteger(string, 1, 10);
    }

    protected boolean maxAgeValid(String string) {
        if (string.equals("")) {
            return true;
        }
        return Validation.isValidInteger(string, 6, 200);
    }

    protected boolean priorityValid(String string) {
        if (string.equals("")) {
            return true;
        }
        return Validation.isValidInteger(string, 0, 65535);
    }
}

