/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class STPPortConfig_JDialog
extends STPMultiSelect_JDialog {
    JPanel rootConfig_JPanel = new JPanel();
    JLabel portFast_JLabel = new JLabel();
    JLabel pathCost_JLabel = new JLabel();
    JLabel priority_JLabel = new JLabel();
    JComboBox portFast_JComboBox = new JComboBox();
    JTextField pathCost_JTextField = new JTextField();
    JTextField priority_JTextField = new JTextField();
    JButton ok_JButton = new JButton();
    JButton cancel_JButton = new JButton();
    JButton help_JButton = new JButton("Help");
    String selectedVLAN = null;
    JLabel vlan_JLabel = new JLabel();
    JComboBox vlan_JComboBox = new JComboBox();

    public STPPortConfig_JDialog(JApplet jApplet, STP_JDialog sTP_JDialog, Vector vector, Vector vector2, String string) {
        super(jApplet, sTP_JDialog, vector, vector2);
        this.selectedVLAN = string;
        this.setTitle("STP Port Configuration");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(320, 239);
        this.setVisible(false);
        this.rootConfig_JPanel.setLayout(null);
        this.getContentPane().add(this.rootConfig_JPanel);
        this.portFast_JLabel.setText("Port Fast:");
        this.rootConfig_JPanel.add(this.portFast_JLabel);
        this.portFast_JLabel.setBounds(14, 12, 166, 28);
        this.pathCost_JLabel.setText("Path Cost (1-65535):");
        this.rootConfig_JPanel.add(this.pathCost_JLabel);
        this.pathCost_JLabel.setBounds(14, 49, 166, 28);
        this.priority_JLabel.setText("Priority (0-255):");
        this.rootConfig_JPanel.add(this.priority_JLabel);
        this.priority_JLabel.setBounds(14, 86, 166, 28);
        this.rootConfig_JPanel.add(this.portFast_JComboBox);
        this.portFast_JComboBox.setBounds(178, 14, 82, 28);
        this.rootConfig_JPanel.add(this.vlan_JComboBox);
        this.rootConfig_JPanel.add(this.pathCost_JTextField);
        this.pathCost_JTextField.setBounds(178, 50, 82, 28);
        this.rootConfig_JPanel.add(this.priority_JTextField);
        this.priority_JTextField.setBounds(178, 86, 82, 28);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.ok_JButton.setText("OK");
        this.ok_JButton.setActionCommand("OK");
        jPanel.add(this.ok_JButton);
        this.cancel_JButton.setText("Cancel");
        this.cancel_JButton.setActionCommand("Cancel");
        jPanel.add(this.cancel_JButton);
        jPanel.add(this.help_JButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.rootConfig_JPanel.setBorder(BorderFactory.createTitledBorder("Port Options"));
        this.portFast_JComboBox.addItem(" ");
        this.portFast_JComboBox.addItem("Enable");
        this.portFast_JComboBox.addItem("Disable");
        this.pathCost_JTextField.setText("");
        this.priority_JTextField.setText("");
        if (vector.size() == 1 && sTP_JDialog != null) {
            int n = sTP_JDialog.portParamsPane.getTable().getSelectedRow();
            String string2 = (String)sTP_JDialog.portParamsPane.getTable().getValueAt(n, sTP_JDialog.portParamsPane.getTable().getColumnModel().getColumnIndex("Port Fast"));
            this.portFast_JComboBox.setSelectedItem(string2.substring(0, string2.length() - 1));
            this.pathCost_JTextField.setText((String)sTP_JDialog.portParamsPane.getTable().getValueAt(n, sTP_JDialog.portParamsPane.getTable().getColumnModel().getColumnIndex("Path Cost")));
            this.priority_JTextField.setText((String)sTP_JDialog.portParamsPane.getTable().getValueAt(n, sTP_JDialog.portParamsPane.getTable().getColumnModel().getColumnIndex("Priority")));
        }
        this.ok_JButton.addActionListener(this);
        this.cancel_JButton.addActionListener(this);
        this.help_JButton.addActionListener(this);
    }

    public STPPortConfig_JDialog(JApplet jApplet, Vector vector, Vector vector2) {
        this(jApplet, null, vector, vector2, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.help_JButton) {
            HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"stpcfg");
        } else if (actionEvent.getSource() == this.ok_JButton) {
            ((Component)this).setCursor(new Cursor(3));
            Boolean bl = null;
            String string = null;
            String string2 = null;
            int n = this.portFast_JComboBox.getSelectedIndex();
            switch (n) {
                case -1: 
                case 0: {
                    bl = null;
                    break;
                }
                case 1: {
                    bl = new Boolean(true);
                    break;
                }
                case 2: {
                    bl = new Boolean(false);
                    break;
                }
                default: {
                    bl = null;
                }
            }
            string = this.pathCost_JTextField.getText().trim();
            if (!this.portPathCostValid(string)) {
                this.rangeError("Path Cost", "1", "65535");
                return;
            }
            string2 = this.priority_JTextField.getText().trim();
            if (!this.portPriorityValid(string2)) {
                this.rangeError("Priority", "0", "255");
                return;
            }
            if (bl != null || string2.compareTo("") != 0 || string.compareTo("") != 0) {
                CommonIOSCLIs commonIOSCLIs = null;
                String string3 = null;
                int n2 = 0;
                while (n2 < this.selectedDevices.size()) {
                    commonIOSCLIs = ((CommonSwitch)this.selectedDevices.elementAt((int)n2)).Cli;
                    string3 = ((CommonSwitch)this.selectedDevices.elementAt((int)n2)).esn;
                    if (bl != null) {
                        commonIOSCLIs.setPortFast(string3, (String)this.selectedItems.elementAt(n2), bl.booleanValue());
                    }
                    if (string.compareTo("") != 0) {
                        commonIOSCLIs.setPortPathCost(string3, (String)this.selectedItems.elementAt(n2), this.selectedVLAN, string);
                    }
                    if (string2.compareTo("") != 0) {
                        commonIOSCLIs.setPortPriority(string3, (String)this.selectedItems.elementAt(n2), this.selectedVLAN, string2);
                    }
                    ++n2;
                }
                if (this.stpParent != null) {
                    this.stpParent.updateTable(this.stpParent.getPortParamsPane().getTable());
                }
            }
            ((Component)this).setCursor(new Cursor(0));
            this.dispose();
        } else {
            this.dispose();
        }
    }

    protected boolean portPathCostValid(String string) {
        if (string.equals("")) {
            return true;
        }
        return Validation.isValidInteger(string, 1, 65535);
    }

    protected boolean portPriorityValid(String string) {
        if (string.equals("")) {
            return true;
        }
        return Validation.isValidInteger(string, 0, 255);
    }
}

