/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Node {
    private ClusterPanel parent;
    double x;
    double y;
    int vbn;
    boolean bFixed;
    boolean bStack;
    boolean bPlaced;
    String deviceLbl;
    String switchStr;
    String hostLbl;
    String vbnLbl;
    URL devUrl;
    URL consoleUrl;
    int nodeNum;
    boolean bNeighborsPlaced = false;
    double posWRTPrimaryNeighbor;
    String upStreamMacAddr;
    String statusCode;
    int primaryEdgeLen;
    boolean isVisible;
    boolean isHiddenCandidate = false;
    boolean isSelected = false;
    private boolean isFault = false;
    private boolean isOldDevice = false;
    Hashtable neighbors = new Hashtable();
    private Hashtable clusterNeighbors = new Hashtable(5);
    private Hashtable networkNeighbors = new Hashtable(5);
    Hashtable ports = new Hashtable(16);
    String clusterID = "";
    int hopCount;
    boolean isViewExpanded;
    boolean candidateNeighborsShown;
    String disqualificationCode = "";
    String macAddr = "";
    public static final String NO_IP_STRING = "0.0.0.0";
    int designation;
    public static final int COMMANDER = 0;
    public static final int MEMBER = 1;
    public static final int CANDIDATE = 2;
    public static final int DISQUALIFIED = 3;
    public static final int NEIGHBOR = 4;
    public static final int ALIEN_COMMANDER = 5;
    public static final int ALIEN_MEMBER = 6;
    public static final int MAX_DEVICE_DESIGNATION = 7;
    private Vector portGroups = null;

    public Node(ClusterPanel clusterPanel) {
        this.parent = clusterPanel;
        this.posWRTPrimaryNeighbor = -1.0;
    }

    public void addClusterNeighbor(Node node) {
        if (node != null) {
            this.clusterNeighbors.put(node, node);
        }
    }

    public Port addEdge(Edge edge, String string) {
        Port port = (Port)this.ports.get(string);
        if (port == null) {
            port = new Port(this, string);
            this.ports.put(string, port);
        }
        port.addEdge(edge);
        return port;
    }

    public void addNetworkNeighbor(Node node) {
        if (node != null) {
            this.networkNeighbors.put(node, node);
        }
    }

    public void addPortGroup(int n) {
        if (this.portGroups == null) {
            this.portGroups = new Vector();
        }
        this.portGroups.addElement(new Integer(n));
    }

    public void addPortGroup(String string) {
        if (this.portGroups == null) {
            this.portGroups = new Vector();
        }
        this.portGroups.addElement(new Integer(string));
    }

    public boolean canLaunchVisualSwitchManager() {
        if (this.isCandidate()) {
            return this.vbnLbl.indexOf(NO_IP_STRING) == -1 && this.consoleUrl != null;
        }
        return this.isUp() && !this.isRelay() && this.consoleUrl != null;
    }

    protected abstract Image currentImage(boolean var1);

    protected String currentLabel(boolean bl, boolean bl2) {
        String string = "N/A";
        String string2 = null;
        if (this.vbnLbl == null) {
            System.out.println("Node::currentLabel() - vbnLbl == null!");
        } else if (this.parent == null) {
            System.out.println("Node::currentLabel() - parent == null!");
        } else {
            string2 = bl && this.designation == 1 ? this.macAddr : (this.vbnLbl.indexOf(NO_IP_STRING) == -1 ? this.vbnLbl.substring(0, this.vbnLbl.indexOf("_")) : this.macAddr);
            switch (this.designation) {
                case 4: {
                    string = bl2 ? string2 : this.clusterID;
                    break;
                }
                case 0: 
                case 5: {
                    string = this.parent.clusterName;
                    if (!bl && string != null) break;
                    string = bl2 ? string2 : this.hostLbl;
                    break;
                }
                default: {
                    string = bl2 ? string2 : this.hostLbl;
                    break;
                }
            }
        }
        return string;
    }

    protected abstract Color currentLabelColor();

    public Vector duplicatePorts() {
        Vector<Port> vector = new Vector<Port>();
        Enumeration enumeration = this.ports.elements();
        while (enumeration.hasMoreElements()) {
            Port port = (Port)enumeration.nextElement();
            if (!port.hasMultipleEdges()) continue;
            vector.addElement(port);
        }
        return vector;
    }

    public Hashtable getClusterNeighbors() {
        return this.clusterNeighbors;
    }

    public Vector getEdges() {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.ports.elements();
        while (enumeration.hasMoreElements()) {
            Port port = (Port)enumeration.nextElement();
            Enumeration enumeration2 = port.getEdges().elements();
            while (enumeration2.hasMoreElements()) {
                Edge edge = (Edge)enumeration2.nextElement();
                vector.addElement(edge);
            }
        }
        return vector;
    }

    public Vector getEdgesToNode(Node node) {
        Vector<Edge> vector = new Vector<Edge>();
        Enumeration enumeration = this.ports.elements();
        while (enumeration.hasMoreElements()) {
            Port port = (Port)enumeration.nextElement();
            Enumeration enumeration2 = port.getEdges().elements();
            while (enumeration2.hasMoreElements()) {
                Edge edge = (Edge)enumeration2.nextElement();
                Node node2 = edge.fromPort.getDevice();
                Node node3 = edge.toPort.getDevice();
                if (node2 == this && node3 == node) {
                    vector.addElement(edge);
                    continue;
                }
                if (node2 != node || node3 != this) continue;
                vector.addElement(edge);
            }
        }
        return vector;
    }

    public Hashtable getNetworkNeighbors() {
        return this.networkNeighbors;
    }

    public int getNodeNum() {
        return this.nodeNum;
    }

    public Port getPortByName(String string) {
        Enumeration enumeration = this.ports.elements();
        while (enumeration.hasMoreElements()) {
            Port port = (Port)enumeration.nextElement();
            if (port.getName().compareTo(string) != 0) continue;
            return port;
        }
        return null;
    }

    public boolean hasCandidateNeighbors() {
        boolean bl = false;
        Enumeration enumeration = this.neighbors.elements();
        while (enumeration.hasMoreElements() && !bl) {
            Node node = (Node)enumeration.nextElement();
            if (node.designation != 2) continue;
            bl = true;
        }
        return bl;
    }

    public boolean hasDuplicatePorts() {
        Vector vector = new Vector();
        Enumeration enumeration = this.ports.elements();
        while (enumeration.hasMoreElements()) {
            Port port = (Port)enumeration.nextElement();
            if (!port.hasMultipleEdges()) continue;
            return true;
        }
        return false;
    }

    public boolean isCandidate() {
        return this.designation == 2;
    }

    public boolean isCommand() {
        return false;
    }

    public boolean isDisqualified() {
        return this.disqualificationCode.compareTo("0") != 0;
    }

    public boolean isFault() {
        return this.isFault;
    }

    public boolean isMember() {
        return this.designation == 1 || this.designation == 0;
    }

    public boolean isOldDevice() {
        return this.isOldDevice;
    }

    public boolean isRelay() {
        return false;
    }

    protected abstract boolean isSelectable();

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isUp() {
        if (!this.isMember()) {
            return true;
        }
        if (this.statusCode != null) {
            return this.statusCode.compareTo("Up") == 0;
        }
        return false;
    }

    public void paintNode(Graphics graphics, ClusterPanel clusterPanel, FontMetrics fontMetrics) {
        this.isVisible = true;
        if (!clusterPanel.bClusterBuilder && this.designation == 1) {
            this.isVisible = false;
        } else {
            if (clusterPanel.bClusterBuilder && this.isHiddenCandidate) {
                return;
            }
            int n = 0;
            int n2 = 0;
            String string = this.currentLabel(clusterPanel.bClusterBuilder, clusterPanel.bLabel);
            Color color = this.currentLabelColor();
            graphics.setColor(color);
            Image image = this.currentImage(clusterPanel.bClusterBuilder);
            if (image != null) {
                n2 = image.getWidth(clusterPanel);
                n = image.getHeight(clusterPanel);
                graphics.drawImage(image, (int)this.x - n2 / 2, (int)this.y - n / 2, n2, n, clusterPanel);
            }
            if (this.isSelected) {
                graphics.setColor(Color.red);
                graphics.drawRect((int)this.x - n2 / 2, (int)this.y - n / 2, n2, n);
            }
            graphics.setColor(color);
            int n3 = fontMetrics.stringWidth(string) + 10;
            int n4 = fontMetrics.getHeight() + 4;
            int n5 = (int)this.x - n3 / 2;
            int n6 = (int)this.y + n / 2 + 10;
            graphics.fillRect(n5, n6, n3, n4);
            graphics.setColor(Color.black);
            graphics.drawRect(n5, n6, n3 - 1, n4 - 1);
            graphics.drawString(string, n5 + 5, n6 + fontMetrics.getAscent() + 2);
        }
    }

    public boolean portGroupExists(int n) {
        boolean bl = false;
        if (this.portGroups != null) {
            Enumeration enumeration = this.portGroups.elements();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                if (n2 != n) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void release() {
        this.deviceLbl = null;
        this.switchStr = null;
        this.hostLbl = null;
        this.vbnLbl = null;
        this.devUrl = null;
        this.consoleUrl = null;
        this.upStreamMacAddr = null;
        this.statusCode = null;
        this.clusterID = null;
        this.disqualificationCode = null;
        this.macAddr = null;
        this.neighbors.clear();
        this.neighbors = null;
        this.clusterNeighbors.clear();
        this.clusterNeighbors = null;
        this.networkNeighbors.clear();
        this.networkNeighbors = null;
        this.ports.clear();
        this.ports = null;
    }

    public void removeEdge(Edge edge, String string) {
        Port port = (Port)this.ports.get(string);
        if (port != null && !port.removeEdge(edge)) {
            System.out.println("Node : " + this + "   edge : " + edge + "    port : " + string + " NOT REMOVED!");
        }
        if (port.edgeCount() == 0) {
            this.ports.remove(port);
        }
    }

    public void setFault(boolean bl) {
        if (this.isFault != bl) {
            this.isFault = bl;
            this.parent.repaint();
        }
    }

    public void setOldDevice(boolean bl) {
        if (this.isOldDevice != bl) {
            this.isOldDevice = bl;
        }
    }

    public void setSelected(boolean bl) {
        if (this.isSelected != bl) {
            this.isSelected = bl;
            this.parent.repaint();
        }
    }

    public void setStatusCode(String string) {
        this.statusCode = string;
    }

    public void showPorts() {
        System.out.println("showPorts() : " + this + " : " + this.ports);
    }

    public void toggleSelected() {
        if (this.isSelected) {
            this.setSelected(false);
        } else {
            this.setSelected(true);
        }
    }
}

