/*
 * Decompiled with CFR 0.152.
 */
import custom.CiscoChartPanel;
import java.util.StringTokenizer;

public class DataCollector
implements GraphConstants {
    private CiscoChartPanel chartPanel;
    private CommonSwitch theSwitch;
    private String port;
    private String linkPortStr;
    String[] dataSetName = new String[3];
    private int pollingInterval;
    private int dataType;
    private long interfaceSpeed;
    private long lastTime = 0L;
    private long lastInBytes = 0L;
    private long lastOutBytes = 0L;
    private long lastTotalBytes = 0L;
    private long lastInUcastPkts = 0L;
    private long lastInMcastPkts = 0L;
    private long lastInBcastPkts = 0L;
    private long lastOutUcastPkts = 0L;
    private long lastOutMcastPkts = 0L;
    private long lastOutBcastPkts = 0L;
    private long lastTotalPkts = 0L;

    public DataCollector(CommonSwitch commonSwitch, String string, CiscoChartPanel ciscoChartPanel, int n, String[] stringArray, int n2) {
        this.theSwitch = commonSwitch;
        this.chartPanel = ciscoChartPanel;
        this.dataSetName = stringArray;
        this.pollingInterval = n2;
        this.dataType = n;
        if (string != null) {
            this.setPort(string);
            this.interfaceSpeed = this.getInterfaceSpeed();
        }
    }

    public void addDeviceData() {
        double d;
        if (this.theSwitch.imageName.toUpperCase().indexOf("WC") != -1 || this.theSwitch.imageName.toUpperCase().indexOf("XW") != -1) {
            String string = this.theSwitch.Cli.getDeviceBandwidthUsage(this.theSwitch.esn);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            try {
                d = Double.parseDouble(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
            }
        } else {
            d = this.theSwitch.Cli.getBandwidthUtilization(this.theSwitch.esn);
        }
        long l = 0L;
        long l2 = l = System.currentTimeMillis();
        double d2 = d;
        String string = Double.toString(d2);
        int n = string.substring(string.indexOf(".") + 1).length();
        if (n > 7) {
            n = 7;
        }
        this.chartPanel.getChart().getYAxis().setLabelPrecision(n);
        this.chartPanel.newObservation(this.dataSetName[0], l2, d2);
        this.lastTime = l;
    }

    public void addLinkData() {
        if (this.port == null) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        long l13 = 0L;
        long l14 = 0L;
        long l15 = 0L;
        long l16 = 0L;
        long l17 = 0L;
        long l18 = 0L;
        long l19 = 0L;
        long l20 = 0L;
        long l21 = 0L;
        long l22 = 0L;
        long l23 = 0L;
        long l24 = 0L;
        long l25 = 0L;
        long l26 = 0L;
        long l27 = 0L;
        long l28 = 0L;
        long l29 = 0L;
        long l30 = 0L;
        String string = this.theSwitch.Cli.getLinkGraphStatistics(this.theSwitch.esn, this.linkPortStr);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("Receive") > -1 && !string2.endsWith("Receive")) {
                string2 = string2.substring(string2.lastIndexOf(101) + 1);
                ++n;
            }
            switch (n) {
                case 2: {
                    l5 = this.getLong(string2);
                    break;
                }
                case 4: {
                    l = this.getLong(string2);
                    break;
                }
                case 6: {
                    l6 = this.getLong(string2);
                    break;
                }
                case 9: {
                    l2 = this.getLong(string2);
                    break;
                }
                case 12: {
                    l7 = this.getLong(string2);
                    break;
                }
                case 15: {
                    l3 = this.getLong(string2);
                    break;
                }
                case 18: {
                    l8 = this.getLong(string2);
                    break;
                }
                case 21: {
                    l4 = this.getLong(string2);
                    break;
                }
                case 27: {
                    l9 = this.getLong(string2);
                    break;
                }
                case 35: {
                    l10 = this.getLong(string2);
                    break;
                }
                case 42: {
                    l11 = this.getLong(string2);
                    break;
                }
                case 50: {
                    l12 = this.getLong(string2);
                    break;
                }
                case 58: {
                    l13 = this.getLong(string2);
                    break;
                }
                case 66: {
                    l14 = this.getLong(string2);
                    break;
                }
                case 73: {
                    l15 = this.getLong(string2);
                    break;
                }
                case 91: {
                    l16 = this.getLong(string2);
                    break;
                }
                case 156: {
                    l17 = this.getLong(string2);
                    break;
                }
            }
            ++n;
        }
        l18 = System.currentTimeMillis();
        switch (this.dataType) {
            case 0: 
            case 1: {
                l19 = l;
                l20 = l5;
                l21 = l19 + l20;
                if (this.dataType == 1) break;
            }
            case 2: {
                l22 = l2;
                l25 = l6;
                l23 = l3;
                l26 = l7;
                l24 = l4;
                l27 = l8;
                l28 = l22 + l25 + l23 + l26 + l24 + l27;
                break;
            }
            case 3: {
                l29 = l15 + l14 + l16 + l17;
                l30 = l9 + l10 + l11 + l12 + l13;
                break;
            }
        }
        if (this.lastTime != 0L) {
            switch (this.dataType) {
                case 0: {
                    long l31 = (l28 - this.lastTotalPkts) * 160L + (l21 - this.lastTotalBytes);
                    double d = l31 / ((l18 - this.lastTime) / 1000L);
                    double d2 = d / (double)this.interfaceSpeed;
                    double d3 = 100.0 * d2;
                    if (d3 < 0.0) break;
                    String string3 = Double.toString(d3);
                    int n2 = string3.substring(string3.indexOf(".") + 1).length();
                    if (n2 > 7) {
                        n2 = 7;
                    }
                    this.chartPanel.getChart().getYAxis().setLabelPrecision(n2);
                    long l32 = l18;
                    this.chartPanel.newObservation(this.dataSetName[0], l32, d3);
                    break;
                }
                case 1: {
                    long l33 = (l21 - this.lastTotalBytes) / 1024L;
                    if (l33 < 0L) break;
                    long l34 = l18;
                    this.chartPanel.newObservation(this.dataSetName[0], l34, (double)l33);
                    l33 = (l19 - this.lastInBytes) / 1024L;
                    if (l33 < 0L) break;
                    this.chartPanel.newObservation(this.dataSetName[1], l34, (double)l33);
                    l33 = (l20 - this.lastOutBytes) / 1024L;
                    if (l33 < 0L) break;
                    this.chartPanel.newObservation(this.dataSetName[2], l34, (double)l33);
                    break;
                }
                case 2: {
                    long l35 = l18;
                    long l36 = (l28 - this.lastTotalPkts) / 1024L;
                    if (l36 < 0L) break;
                    this.chartPanel.newObservation(this.dataSetName[0], l35, (double)l36);
                    l36 = (l22 + l25 - (this.lastInUcastPkts + this.lastOutUcastPkts)) / 1024L;
                    if (l36 < 0L) break;
                    this.chartPanel.newObservation(this.dataSetName[1], l35, (double)l36);
                    l36 = (l23 + l26 + l24 + l27 - (this.lastInMcastPkts + this.lastOutMcastPkts + this.lastInBcastPkts + this.lastOutBcastPkts)) / 1024L;
                    if (l36 < 0L) break;
                    this.chartPanel.newObservation(this.dataSetName[2], l35, (double)l36);
                    break;
                }
                case 3: {
                    long l37 = l18;
                    long l38 = l29;
                    this.chartPanel.newObservation(this.dataSetName[0], l37, (double)l38);
                    l37 = l18;
                    l38 = l30;
                    this.chartPanel.newObservation(this.dataSetName[1], l37, (double)l38);
                    break;
                }
            }
        }
        this.lastTime = l18;
        switch (this.dataType) {
            case 2: {
                this.lastInUcastPkts = l22;
                this.lastOutUcastPkts = l25;
                this.lastInMcastPkts = l23;
                this.lastOutMcastPkts = l26;
                this.lastInBcastPkts = l24;
                this.lastOutBcastPkts = l27;
                this.lastTotalPkts = l28;
                break;
            }
            case 1: {
                this.lastInBytes = l19;
                this.lastOutBytes = l20;
            }
            case 0: {
                this.lastTotalBytes = l21;
                this.lastTotalPkts = l28;
                break;
            }
        }
    }

    private void clearData() {
        this.lastTime = 0L;
        this.lastInBytes = 0L;
        this.lastOutBytes = 0L;
        this.lastTotalBytes = 0L;
        this.lastInUcastPkts = 0L;
        this.lastInMcastPkts = 0L;
        this.lastInBcastPkts = 0L;
        this.lastOutUcastPkts = 0L;
        this.lastOutMcastPkts = 0L;
        this.lastOutBcastPkts = 0L;
        this.lastTotalPkts = 0L;
    }

    private long getInterfaceSpeed() {
        long l = 0L;
        String string = this.theSwitch.Cli.getPortSpeedActual(this.theSwitch.esn, this.port);
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l = this.port.startsWith("G") || this.port.startsWith("g") ? 1000L : 0L;
        }
        return l * 1024L * 1024L;
    }

    private long getLong(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public void setDataType(int n) {
        this.dataType = n;
        this.chartPanel.getChart().clearAllDatasets();
        this.clearData();
    }

    public void setDevice(CommonSwitch commonSwitch) {
        this.theSwitch = commonSwitch;
        this.chartPanel.getChart().clearAllDatasets();
        this.clearData();
    }

    public void setPollingInterval(int n) {
        this.pollingInterval = n;
    }

    public void setPort(String string) {
        this.port = string;
        this.chartPanel.getChart().clearAllDatasets();
        this.clearData();
        if (string != null) {
            int n = string.indexOf("/");
            this.linkPortStr = String.valueOf(string.substring(0, n)) + "%5c/" + string.substring(n + 1);
        }
    }
}

