/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SPAN_JDialog
extends JDialog
implements ActionListener,
ItemListener,
ListSelectionListener {
    boolean frameSizeAdjusted = false;
    JPanel deviceList_JPanel;
    JComboBox devices_JCombo;
    JPanel buttons_JPanel;
    JButton ok_JButton;
    JButton cancel_JButton;
    JButton modify_JButton;
    JButton help_JButton;
    JApplet theApplet;
    CommonSwitch[] switches;
    CommonSwitch theSwitch;
    int switchIndex;
    JTable span_JTable;
    SpanTableModel spanTableModel;
    JLabel hostName_JLabel = new JLabel("Host Name:");
    JLabel hostName;
    ListSelectionModel spanLSM;

    public SPAN_JDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(frame);
        int n;
        this.theApplet = jApplet;
        this.switches = commonSwitchArray;
        this.theSwitch = commonSwitch;
        this.setDefaultCloseOperation(2);
        if (commonSwitch == null) {
            commonSwitch = commonSwitchArray[0];
            n = 0;
            while (n < commonSwitchArray.length) {
                if (commonSwitchArray[n].memberType.equals("CC") || commonSwitchArray[n].memberType.equals("AC")) {
                    commonSwitch = commonSwitchArray[n];
                    break;
                }
                ++n;
            }
        }
        this.switchIndex = 0;
        n = 0;
        while (n < commonSwitchArray.length) {
            if (commonSwitchArray[n] == commonSwitch) {
                this.switchIndex = n;
                break;
            }
            ++n;
        }
        jApplet.setCursor(new Cursor(3));
        this.setTitle("Switch Port ANalyzer (SPAN)");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(405, 305);
        this.setVisible(false);
        this.deviceList_JPanel = new JPanel();
        this.deviceList_JPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add("North", this.deviceList_JPanel);
        this.deviceList_JPanel.setBounds(0, 0, 513, 62);
        this.deviceList_JPanel.add(this.hostName_JLabel);
        this.devices_JCombo = new JComboBox();
        this.deviceList_JPanel.add(this.devices_JCombo);
        this.devices_JCombo.setBounds(191, 25, 130, 27);
        if (jApplet.getClass().getName().equalsIgnoreCase("DeviceManager")) {
            this.hostName = new JLabel("");
            this.hostName.setText(commonSwitchArray[0].switchName);
            this.deviceList_JPanel.add(this.hostName);
            this.devices_JCombo.setVisible(false);
            this.deviceList_JPanel.setBorder(BorderFactory.createTitledBorder(""));
        } else {
            this.deviceList_JPanel.setBorder(BorderFactory.createTitledBorder("Device List"));
        }
        int n2 = 0;
        while (n2 < commonSwitchArray.length) {
            if (commonSwitchArray[n2].supportSPAN()) {
                this.devices_JCombo.addItem(commonSwitchArray[n2].switchName);
            }
            ++n2;
        }
        this.devices_JCombo.setSelectedItem(commonSwitchArray[this.switchIndex].switchName);
        this.spanTableModel = new SpanTableModel(commonSwitchArray, (String)this.devices_JCombo.getSelectedItem());
        this.span_JTable = new JTable(this.spanTableModel);
        this.span_JTable.setSelectionMode(0);
        this.spanLSM = this.span_JTable.getSelectionModel();
        this.spanLSM.addListSelectionListener(this);
        this.getContentPane().add((Component)new JScrollPane(this.span_JTable), "Center");
        this.buttons_JPanel = new JPanel();
        this.ok_JButton = new JButton("OK");
        this.cancel_JButton = new JButton("Cancel");
        this.modify_JButton = new JButton("Modify ...");
        this.help_JButton = new JButton("Help");
        this.buttons_JPanel.add(this.ok_JButton);
        this.buttons_JPanel.add(this.modify_JButton);
        this.buttons_JPanel.add(this.help_JButton);
        this.getContentPane().add((Component)this.buttons_JPanel, "South");
        this.devices_JCombo.addItemListener(this);
        this.modify_JButton.addActionListener(this);
        this.ok_JButton.addActionListener(this);
        this.cancel_JButton.addActionListener(this);
        this.help_JButton.addActionListener(this);
        this.modify_JButton.setEnabled(false);
        jApplet.setCursor(new Cursor(0));
    }

    public SPAN_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(null, jApplet, commonSwitchArray, null);
    }

    public SPAN_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        this(null, jApplet, commonSwitchArray, commonSwitch);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok_JButton) {
            this.clickOK();
        } else if (object == this.cancel_JButton) {
            this.clickCancel();
        } else if (object == this.help_JButton) {
            this.clickHelp();
        } else if (object == this.modify_JButton) {
            this.clickModify();
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    void clickCancel() {
        this.dispose();
    }

    void clickHelp() {
        HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"spanwin");
    }

    void clickModify() {
        String string = this.switches[this.switchIndex].esn;
        int[] nArray = this.span_JTable.getSelectedRows();
        String string2 = (String)this.spanTableModel.getValueAt(nArray[0], 0);
        String string3 = this.switches[this.switchIndex].Cli.getPortApplication(string, string2);
        String string4 = this.switches[this.switchIndex].Cli.getPortVlanMode(string, string2);
        if (string2.indexOf("ATM") != -1) {
            JOptionPane.showMessageDialog(this, "ATM port cannot be a monitor port.", "Error: SPAN", 0);
            return;
        }
        if (string3.equals("n")) {
            JOptionPane.showMessageDialog(this, "Network port cannot be a monitor port.", "Error: SPAN", 0);
            return;
        }
        if (string3.equals("g")) {
            JOptionPane.showMessageDialog(this, "Grouped port cannot be a monitor port.", "Error: SPAN", 0);
            return;
        }
        if (string3.equals("ng")) {
            JOptionPane.showMessageDialog(this, "Network and Grouped port cannot be a monitor port.", "Error: SPAN", 0);
            return;
        }
        if (string3.equals("s")) {
            JOptionPane.showMessageDialog(this, "Secured port cannot be a monitor port.", "Error: SPAN", 0);
            return;
        }
        if (!string4.equals("Static Access")) {
            JOptionPane.showMessageDialog(this, "Only Static Access port can be a monitor port", "Error: SPAN", 0);
            return;
        }
        SPANModify_JDialog sPANModify_JDialog = new SPANModify_JDialog(this.theApplet, this.switches, this, nArray[0]);
        ModalDialog.show((RootPaneContainer)this, (Dialog)sPANModify_JDialog, null);
    }

    void clickOK() {
        this.dispose();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.devices_JCombo) {
            JComboBox jComboBox = (JComboBox)object;
            String string = (String)jComboBox.getSelectedItem();
            int n = 0;
            while (n < this.switches.length) {
                if (this.switches[n].switchName.equals(string)) {
                    this.switchIndex = n;
                    break;
                }
                ++n;
            }
            ((Component)this).setCursor(new Cursor(3));
            this.spanTableModel.setSelection(string);
            this.span_JTable.sizeColumnsToFit(0);
            ((Component)this).setCursor(new Cursor(0));
            return;
        }
    }

    public static void main(String[] stringArray) {
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.span_JTable.getSelectedRowCount() > 0) {
            this.modify_JButton.setEnabled(true);
        } else {
            this.modify_JButton.setEnabled(false);
        }
    }
}

