/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

public class Preferences {
    private String host;
    private final String PREFERENCES_FILE = "flash:html%5c/prefs.text";
    private final String DEFAULT_PREFS_STRING = "60,6,yes,cluster,1,yes,240,5,1";
    private String actualResponse;
    private int polling_cb;
    private int graph_interval;
    private boolean suggested_candidate_window;
    private String default_view;
    private boolean splash_screen = true;
    private int polling_cm = 240;
    private int num_of_hops = 3;
    ClusterCLI clusterCLI;

    public Preferences(ClusterCLI clusterCLI) {
        this.clusterCLI = clusterCLI;
        this.host = Cluster.getCodeBaseHost();
        String string = this.getPrefsString();
        this.parsePreferences(string);
    }

    public String getActualResponse() {
        return this.actualResponse;
    }

    public String getDefault_view() {
        return this.default_view;
    }

    public int getGraph_interval() {
        return this.graph_interval;
    }

    public int getNum_of_hops() {
        return this.num_of_hops;
    }

    public int getPolling_cb() {
        return this.polling_cb;
    }

    public int getPolling_cm() {
        return this.polling_cm;
    }

    private String getPrefsString() {
        String string;
        String string2;
        int n = 0;
        this.actualResponse = string2 = this.clusterCLI.runCLICommand(this.host, "cluster preferences file flash:html%5c/prefs.text", "exec");
        boolean bl = true;
        if (string2 != null && !string2.equals("") && string2.indexOf("Error") == -1 && (n = string2.indexOf(string = "Command was")) != -1) {
            string2 = string2.substring(n);
            string = "<PRE><HR>";
            n = string2.indexOf(string);
            int n2 = string2.indexOf("</DL><HR><PRE>");
            if ((string2 = string2.substring(n + string.length(), n2)).compareTo("") != 0) {
                bl = false;
            }
        }
        if (bl) {
            string2 = "60,6,yes,cluster,1,yes,240,5,1";
        }
        return string2;
    }

    public boolean getSplash_screen() {
        return this.splash_screen;
    }

    public boolean getSuggested_candidate_window() {
        return this.suggested_candidate_window;
    }

    private void parsePreferences(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    this.setPolling_cb(Integer.parseInt(string2));
                    break;
                }
                case 1: {
                    this.setGraph_interval(Integer.parseInt(string2));
                    break;
                }
                case 2: {
                    this.setSuggested_candidate_window(string2.compareTo("yes") == 0);
                    break;
                }
                case 3: {
                    this.setDefault_view(string2);
                    break;
                }
                case 5: {
                    this.setSplash_screen(string2.compareTo("yes") == 0);
                    break;
                }
                case 6: {
                    this.setPolling_cm(Integer.parseInt(string2));
                    break;
                }
                case 7: {
                    this.setNum_of_hops(Integer.parseInt(string2));
                    break;
                }
            }
            ++n;
        }
    }

    public void savePreferences() {
        StringBuffer stringBuffer = new StringBuffer(132);
        stringBuffer.append(Integer.toString(this.polling_cb));
        stringBuffer.append(",");
        stringBuffer.append(Integer.toString(this.graph_interval));
        stringBuffer.append(",");
        if (this.suggested_candidate_window) {
            stringBuffer.append("yes");
        } else {
            stringBuffer.append("no");
        }
        stringBuffer.append(",");
        stringBuffer.append(this.default_view);
        stringBuffer.append(",1,");
        if (this.splash_screen) {
            stringBuffer.append("yes");
        } else {
            stringBuffer.append("no");
        }
        stringBuffer.append(",");
        stringBuffer.append(Integer.toString(this.polling_cm));
        stringBuffer.append(",");
        stringBuffer.append(Integer.toString(this.num_of_hops));
        stringBuffer.append(",1");
        System.out.println("Writing prefs string : " + stringBuffer.toString());
        String string = this.clusterCLI.runCLICommand(this.host, "cluster preferences file flash:html%5c/prefs.text " + stringBuffer.toString(), "exec");
    }

    public void setDefault_view(String string) {
        this.default_view = string;
    }

    public void setGraph_interval(int n) {
        this.graph_interval = n;
    }

    public void setNum_of_hops(int n) {
        this.num_of_hops = n;
    }

    public void setPolling_cb(int n) {
        this.polling_cb = n;
    }

    public void setPolling_cm(int n) {
        this.polling_cm = n;
    }

    public void setSplash_screen(boolean bl) {
        this.splash_screen = bl;
    }

    public void setSuggested_candidate_window(boolean bl) {
        this.suggested_candidate_window = bl;
    }
}

