/*
 * Decompiled with CFR 0.152.
 */
package Snmp;

import Snmp.ASNTypes;
import Snmp.SnmpException;
import Snmp.SnmpInt;
import Snmp.SnmpOID;
import Snmp.SnmpString;
import Snmp.SnmpVar;
import java.io.ByteArrayInputStream;

public class SnmpVarBind {
    public SnmpOID oid;
    public SnmpVar variable;

    public String toString() {
        String string = null;
        string = this.variable.Type == 2 ? ((SnmpInt)this.variable).toEnumString(this.oid) : this.variable.toString();
        if (this.variable.Type == 4) {
            if (string.indexOf(0) > -1 || this.oid.toString().startsWith(".1.3.6.1.2.1.3.1.1.2") || this.oid.toString().startsWith(".1.3.6.1.2.1.4.22.1.2") || this.oid.toString().startsWith(".1.3.6.1.2.1.2.2.1.6")) {
                string = ((SnmpString)this.variable).toByteString();
            } else {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append(" (");
                stringBuffer.append(((SnmpString)this.variable).toByteString());
                stringBuffer.append(")");
                string = stringBuffer.toString();
            }
        }
        if (this.oid == null || this.variable == null) {
            return null;
        }
        return new String(String.valueOf(this.oid.toString()) + ": " + string);
    }

    public String toTagString() {
        String string = null;
        string = this.variable.Type == 2 ? ((SnmpInt)this.variable).toEnumTagString(this.oid) : this.variable.toTagString();
        if (this.variable.Type == 4) {
            if (this.oid.toString().startsWith(".1.3.6.1.2.1.3.1.1.2") || this.oid.toString().startsWith(".1.3.6.1.2.1.4.22.1.2") || this.oid.toString().startsWith(".1.3.6.1.2.1.2.2.1.6")) {
                string = "PhysAddress: " + ((SnmpString)this.variable).toByteString();
            } else if (string.indexOf(0) != -1) {
                string = "STRING: " + ((SnmpString)this.variable).toByteString();
            }
        }
        if (this.oid == null || this.variable == null) {
            return null;
        }
        return new String(String.valueOf(this.oid.toTagString()) + "\n" + string);
    }

    byte[] encode() {
        byte[] byArray;
        if (this.oid == null || this.oid.toValue() == null || this.variable == null) {
            return null;
        }
        byte[] byArray2 = this.oid.encode();
        if (byArray2 == null || (byArray = this.variable.encode()) == null) {
            return null;
        }
        byte[] byArray3 = ASNTypes.build_header((byte)48, byArray2.length + byArray.length);
        if (byArray3 == null) {
            return null;
        }
        byte[] byArray4 = new byte[byArray2.length + byArray.length + byArray3.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length, byArray2.length);
        System.arraycopy(byArray, 0, byArray4, byArray2.length + byArray3.length, byArray.length);
        return byArray4;
    }

    void decode(ByteArrayInputStream byteArrayInputStream) throws SnmpException {
        SnmpVar snmpVar = null;
        int[] nArray = ASNTypes.parse_header(byteArrayInputStream);
        if (nArray == null) {
            throw new SnmpException("VarBind decode error");
        }
        if (nArray[0] != 48) {
            throw new SnmpException("VarBind Header decode error");
        }
        snmpVar = ASNTypes.decodeVar(byteArrayInputStream);
        if (snmpVar.Type != 6) {
            throw new SnmpException("VarBind OID decode error");
        }
        this.oid = (SnmpOID)snmpVar;
        this.variable = ASNTypes.decodeVar(byteArrayInputStream);
    }
}

