/*
 * Decompiled with CFR 0.152.
 */
package Snmp;

import Snmp.ASNTypes;
import Snmp.SnmpAPI;
import Snmp.SnmpException;
import Snmp.SnmpVar;
import java.io.ByteArrayInputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class SnmpOID
extends SnmpVar {
    protected long[] value;
    protected byte[] byteValue;

    public SnmpOID(String string) {
        this.Type = (byte)6;
        if (string == null) {
            return;
        }
        this.setOID(string);
    }

    public Object toValue() {
        return this.value;
    }

    public byte[] toBytes() {
        return this.byteValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.value != null) {
            int n = 0;
            while (n < this.value.length) {
                stringBuffer.append("." + Long.toString(this.value[n]));
                ++n;
            }
        } else {
            return null;
        }
        return stringBuffer.toString();
    }

    public String toTagString() {
        return new String("Object ID: " + this.toString());
    }

    byte[] encode() {
        if (this.value == null) {
            return null;
        }
        byte[] byArray = new byte[(this.value.length - 1) * 9];
        int n = 0;
        if (this.value == null) {
            return null;
        }
        if (this.value.length == 1) {
            return null;
        }
        this.value[1] = this.value[1] + 40L * this.value[0];
        long l = 0L;
        long l2 = 127L;
        int n2 = 1;
        while (n2 < this.value.length) {
            long l3 = this.value[n2];
            if (l3 < 0L) {
                System.err.println("Build Error: Sub-identifier negative/too large.");
                this.value[1] = this.value[1] - 40L * this.value[0];
                return null;
            }
            long l4 = 127L;
            long l5 = 0L;
            while (l4 > 0L) {
                if ((l3 & l4) != 0L) {
                    l2 = l4;
                    l = l5;
                }
                l4 <<= 7;
                l5 += 7L;
            }
            while (l2 != 127L) {
                byArray[n++] = (byte)((byte)((l3 & l2) >> (int)l) | 0xFFFFFF80);
                l2 >>= 7;
                l -= 7L;
            }
            byArray[n++] = (byte)(l3 & l2);
            ++n2;
        }
        this.value[1] = this.value[1] - 40L * this.value[0];
        byte[] byArray2 = ASNTypes.build_header((byte)6, n);
        if (byArray2 == null) {
            return null;
        }
        byte[] byArray3 = new byte[byArray2.length + n];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, n);
        return byArray3;
    }

    boolean decode(ByteArrayInputStream byteArrayInputStream, int n) throws SnmpException {
        long l;
        ASNTypes.checkStream(byteArrayInputStream, n);
        if (n <= 0) {
            System.err.println("Parse Error: Zero length OID." + n);
            return false;
        }
        this.value = new long[1];
        int n2 = 0;
        this.byteValue = new byte[n];
        while (n > 0) {
            byte by;
            l = 0L;
            long l2 = 0L;
            do {
                this.byteValue[n2] = by = (byte)byteArrayInputStream.read();
                ++n2;
                l = (l << 7) + (long)(by & 0x7F);
                --n;
                if (++l2 <= 9L) continue;
                System.err.println("Parse Error: Sub-identifier too large.");
                return false;
            } while (by < 0);
            long[] lArray = new long[1 + this.value.length];
            System.arraycopy(this.value, 0, lArray, 0, this.value.length);
            lArray[this.value.length] = l;
            this.value = lArray;
        }
        l = this.value[1];
        this.value[1] = l % 40L;
        this.value[0] = (l - this.value[1]) / 40L;
        return true;
    }

    private void setOID(String string) {
        long[] lArray = null;
        long[] lArray2 = null;
        if (string.charAt(0) != '.') {
            string = new String(String.valueOf(SnmpAPI.Standard_Prefix) + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            if (lArray == null) {
                lArray2 = new long[1];
            } else {
                lArray2 = new long[lArray.length + 1];
                System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
            }
            try {
                lArray2[lArray2.length - 1] = new Long(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Invalid OID format: " + string);
                this.value = null;
                return;
            }
            lArray = lArray2;
        }
        this.value = lArray;
    }

    Vector toVector(String string) {
        Vector<String> vector = new Vector<String>();
        if (string.charAt(0) != '.') {
            string = new String(String.valueOf(SnmpAPI.Standard_Prefix) + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }
}

