/*
 * Decompiled with CFR 0.152.
 */
package Snmp;

import Snmp.SnmpClient;
import Snmp.SnmpPDU;
import Snmp.SnmpSession;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public class SnmpAPI
extends Thread
implements SnmpClient {
    public final int version = 103;
    public Vector sessionList = new Vector();
    public Vector modules = new Vector();
    public boolean DEBUG = false;
    public SnmpClient client;
    int ReqID = 1010;
    int MONITOR_SLEEP = 500;
    Random rand = new Random();
    public int SNMP_PORT = 161;
    public int SNMP_TRAP_PORT = 162;
    static int SNMP_MAX_LEN = 484;
    static int SNMP_VERSION_1;
    public static final byte GET_REQ_MSG = -96;
    public static final byte GETNEXT_REQ_MSG = -95;
    public static final byte GET_RSP_MSG = -94;
    public static final byte SET_REQ_MSG = -93;
    public static final byte TRP_REQ_MSG = -92;
    public static final byte SNMP_ERR_NOERROR = 0;
    public static final byte SNMP_ERR_TOOBIG = 1;
    public static final byte SNMP_ERR_NOSUCHNAME = 2;
    public static final byte SNMP_ERR_BADVALUE = 3;
    public static final byte SNMP_ERR_READONLY = 4;
    public static final byte SNMP_ERR_GENERR = 5;
    static final byte SNMP_TRAP_COLDSTART = 0;
    static final byte SNMP_TRAP_WARMSTART = 1;
    static final byte SNMP_TRAP_LINKDOWN = 2;
    static final byte SNMP_TRAP_LINKUP = 3;
    static final byte SNMP_TRAP_AUTHFAIL = 4;
    static final byte SNMP_TRAP_EGPNEIGHBORLOSS = 5;
    static final byte SNMP_TRAP_ENTERPRISESPECIFIC = 6;
    public static final byte INTEGER = 2;
    public static final byte STRING = 4;
    public static final byte OBJID = 6;
    public static final byte NULLOBJ = 5;
    public static final byte IPADDRESS = 64;
    public static final byte COUNTER = 65;
    public static final byte GAUGE = 66;
    public static final byte TIMETICKS = 67;
    public static final byte OPAQUE = 68;
    static int SNMP_DEFAULT_COMMUNITY_LEN;
    static int SNMP_DEFAULT_RETRIES;
    static int SNMP_DEFAULT_TIMEOUT;
    static int SNMP_DEFAULT_REMPORT;
    static int SNMP_DEFAULT_REQID;
    static int SNMP_DEFAULT_ERRSTAT;
    static int SNMP_DEFAULT_ERRINDEX;
    static int SNMP_DEFAULT_ADDRESS;
    static String SNMP_DEFAULT_PEERNAME;
    static int SNMP_DEFAULT_ENTERPRISE_LENGTH;
    static int SNMP_DEFAULT_TIME;
    static int SID_MAX_LEN;
    static int MAX_NAME_LEN;
    public static final int RONLY = 43690;
    public static final int WONLY = 43691;
    public static final int RWRITE = 43706;
    public static final int NOACCESS = 0;
    public static String Standard_Prefix;

    public void run() {
        if (this.client == null) {
            this.client = this;
        }
        this.genReqID();
        while (true) {
            Enumeration enumeration = this.sessionList.elements();
            while (enumeration.hasMoreElements()) {
                ((SnmpSession)enumeration.nextElement()).monitorRequests();
            }
            try {
                Thread.sleep(this.MONITOR_SLEEP);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public int genReqID() {
        this.ReqID = this.rand.nextInt();
        if (this.ReqID < 0) {
            this.ReqID = -this.ReqID;
        }
        if (this.ReqID > 0x3FFFFFFF) {
            this.ReqID -= 0x3FFFFFFF;
        }
        return this.ReqID;
    }

    public Vector checkResponses() {
        Vector<SnmpSession> vector = new Vector<SnmpSession>();
        Enumeration enumeration = this.sessionList.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSession snmpSession = (SnmpSession)enumeration.nextElement();
            if (snmpSession.checkResponses().length <= 0) continue;
            vector.addElement(snmpSession);
        }
        return vector;
    }

    public Vector checkTimeouts() {
        Vector<SnmpSession> vector = new Vector<SnmpSession>();
        Enumeration enumeration = this.sessionList.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSession snmpSession = (SnmpSession)enumeration.nextElement();
            if (snmpSession.timeouts.size() <= 0) continue;
            vector.addElement(snmpSession);
        }
        return vector;
    }

    public boolean authenticate(SnmpPDU snmpPDU, String string) {
        return string.equals(snmpPDU.community);
    }

    public boolean callback(SnmpSession snmpSession, SnmpPDU snmpPDU, int n) {
        return false;
    }

    public void debugPrint(String string) {
        System.out.println(string);
    }

    static {
        SNMP_DEFAULT_RETRIES = -1;
        SNMP_DEFAULT_TIMEOUT = -1;
        SNMP_DEFAULT_ERRSTAT = -1;
        SNMP_DEFAULT_ERRINDEX = -1;
        SNMP_DEFAULT_PEERNAME = null;
        SID_MAX_LEN = 64;
        MAX_NAME_LEN = 64;
        Standard_Prefix = ".1.3.6.1.2.1.";
    }
}

