/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal.xmllite;

public class CharString {
    private char[] value;
    private int start;
    private int length;

    public CharString(String str) {
        this.start = 0;
        this.length = str.length();
        this.value = new char[this.length];
        str.getChars(0, this.length, this.value, this.start);
    }

    public CharString(char[] value, int start, int length) {
        this.value = value;
        this.start = start;
        this.length = length;
    }

    public CharString(CharString str) {
        this.start = 0;
        this.length = str.length;
        this.value = new char[this.length];
        int[] chunkLength = new int[2];
        str.computeChunkLengths(chunkLength);
        System.arraycopy(str.value, str.start, this.value, this.start, chunkLength[0]);
        if (chunkLength[1] != 0) {
            System.arraycopy(str.value, 0, this.value, chunkLength[0], chunkLength[1]);
        }
    }

    public CharString trim() {
        while (this.length > 0) {
            if (!Character.isWhitespace(this.value[this.start])) break;
            ++this.start;
            if (this.start == this.value.length) {
                this.start = 0;
            }
            --this.length;
        }
        int end = this.start + this.length - 1;
        if (end >= this.value.length) {
            end -= this.value.length;
        }
        while (this.length > 0) {
            if (!Character.isWhitespace(this.value[end])) break;
            if (--end == -1) {
                end = this.value.length - 1;
            }
            --this.length;
        }
        return this;
    }

    public boolean equals(Object str) {
        CharString charStr;
        if (str == null) {
            return false;
        }
        try {
            charStr = (CharString)str;
        }
        catch (ClassCastException cce) {
            return false;
        }
        if (this.length != charStr.length) {
            return false;
        }
        int i = 0;
        int j = this.start;
        int k = charStr.start;
        while (i < this.length) {
            if (this.value[j] != charStr.value[k]) {
                return false;
            }
            ++i;
            if (++j == this.value.length) {
                j = 0;
            }
            if (++k != charStr.value.length) continue;
            k = 0;
        }
        return true;
    }

    public String toString() {
        int[] chunkLength = new int[2];
        this.computeChunkLengths(chunkLength);
        StringBuffer strBuf = new StringBuffer(this.length);
        strBuf.append(this.value, this.start, chunkLength[0]);
        if (chunkLength[1] != 0) {
            strBuf.append(this.value, 0, chunkLength[1]);
        }
        return strBuf.toString();
    }

    public int toInt() throws NumberFormatException {
        int result = 0;
        boolean negative = false;
        int i = 0;
        int cursor = this.start;
        int max = this.length;
        if (max > 0) {
            int digit;
            int limit;
            if (this.value[this.start] == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
                if (++cursor == this.value.length) {
                    cursor = 0;
                }
            } else {
                limit = -2147483647;
            }
            int multmin = limit / 10;
            if (i < max) {
                digit = Character.digit(this.value[cursor], 10);
                ++i;
                if (++cursor == this.value.length) {
                    cursor = 0;
                }
                if (digit < 0) {
                    throw new NumberFormatException(this.toString());
                }
                result = -digit;
            }
            while (i < max) {
                digit = Character.digit(this.value[cursor], 10);
                ++i;
                if (++cursor == this.value.length) {
                    cursor = 0;
                }
                if (digit < 0) {
                    throw new NumberFormatException(this.toString());
                }
                if (result < multmin) {
                    throw new NumberFormatException(this.toString());
                }
                if ((result *= 10) < limit + digit) {
                    throw new NumberFormatException(this.toString());
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException(this.toString());
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(this.toString());
        }
        return -result;
    }

    private void computeChunkLengths(int[] chunkLength) {
        chunkLength[0] = this.value.length - this.start;
        if (chunkLength[0] < this.length) {
            chunkLength[1] = this.length - chunkLength[0];
        } else {
            chunkLength[0] = this.length;
            chunkLength[1] = 0;
        }
    }
}

