/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.internal.Distribution;
import com.cisco.cpnm.boot.internal.VersionXml;
import com.cisco.cpnm.boot.internal.util.JreVersion;
import com.cisco.cpnm.boot.internal.xmllite.CharString;
import com.cisco.cpnm.boot.internal.xmllite.Handler;
import com.cisco.cpnm.boot.internal.xmllite.ParseException;
import com.cisco.cpnm.boot.internal.xmllite.Parser;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

class VersionFile
implements Handler,
VersionXml {
    private URL filesystem;
    private InputStream stream;
    private Exception parseException;
    private JreVersion jreVer;
    private int majVer;
    private List distributions;
    private int numLatest;
    private CharString currElem;

    VersionFile(URL filesystem, InputStream stream) {
        this.filesystem = filesystem;
        this.stream = stream;
        this.distributions = new LinkedList();
    }

    URL getFilesystem() {
        return this.filesystem;
    }

    InputStream getStream() {
        return this.stream;
    }

    int getMajorVersion() {
        return this.majVer;
    }

    JreVersion getJreVersion() {
        return this.jreVer;
    }

    List getDistributions() {
        return this.distributions;
    }

    boolean isContributing() {
        return this.numLatest > 0;
    }

    void updateNumLatest(boolean isLatest) {
        this.numLatest = isLatest ? ++this.numLatest : --this.numLatest;
    }

    void setParseException(Exception e) {
        this.parseException = e;
    }

    Exception getParseException() {
        return this.parseException;
    }

    public String toString() {
        return "version file from filesystem " + this.filesystem;
    }

    public void startDocument(Parser parser) throws ParseException {
    }

    public CharString startElement(Parser parser, CharString element) throws ParseException {
        this.currElem = null;
        if (element.equals(VersionXml.VERSION_FILE)) {
            this.currElem = VersionXml.VERSION_FILE;
        } else if (element.equals(VersionXml.MINIMUM_JRE)) {
            this.currElem = VersionXml.MINIMUM_JRE;
        } else if (element.equals(VersionXml.MAJOR_VERSION)) {
            this.currElem = VersionXml.MAJOR_VERSION;
        } else if (element.equals(VersionXml.DISTRIBUTION)) {
            this.currElem = VersionXml.DISTRIBUTION;
            Distribution dist = new Distribution(this);
            this.distributions.add(dist);
            parser.pushHandler(dist);
        }
        return this.currElem;
    }

    public void elementData(Parser parser, CharString data) throws ParseException {
        if (this.currElem == VersionXml.MINIMUM_JRE) {
            this.jreVer = new JreVersion(data.toString());
        } else if (this.currElem == VersionXml.MAJOR_VERSION) {
            this.majVer = data.toInt();
        }
    }

    public void endElement(Parser parser, CharString element) throws ParseException {
    }

    public void endDocument(Parser parser) throws ParseException {
    }
}

