/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Signature;

public class Verifier {
    private static int _Src;
    private static byte[] _DigestBuf;
    private static PublicKey _Key;
    private static MessageDigest _Md;
    static final String SIG_FILENAME = "SIG";
    private static final int DIGEST_LENGTH = 20;
    private static final byte[] PUBLIC_KEY;

    static boolean init(InputStream sigStream) {
        try {
            if (_Key == null) {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(PUBLIC_KEY));
                _Key = (PublicKey)ois.readObject();
                ois.close();
                _Md = MessageDigest.getInstance("SHA1");
            }
            DataInputStream dis = new DataInputStream(sigStream);
            int nofDigests = dis.readInt();
            int diglen = dis.readInt();
            if (diglen != 20) {
                throw new Exception("unexpected digest length " + diglen);
            }
            _DigestBuf = new byte[20 * nofDigests];
            dis.readFully(_DigestBuf, 0, _DigestBuf.length);
            int siglen = dis.readInt();
            byte[] sig = new byte[siglen];
            dis.readFully(sig, 0, siglen);
            dis.close();
            Signature signer = Signature.getInstance(_Key.getAlgorithm());
            signer.initVerify(_Key);
            signer.update(_DigestBuf, 0, _DigestBuf.length);
            if (!signer.verify(sig)) {
                throw new Exception("corrupted digests");
            }
            _Src = 0;
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    static boolean verify(byte[] data) {
        try {
            byte[] digest = _Md.digest(data);
            int i = 0;
            int n = digest.length;
            while (i < n) {
                if (digest[i] != _DigestBuf[_Src++]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    static {
        PUBLIC_KEY = new byte[]{-84, -19, 0, 5, 115, 114, 0, 34, 115, 117, 110, 46, 115, 101, 99, 117, 114, 105, 116, 121, 46, 112, 114, 111, 118, 105, 100, 101, 114, 46, 68, 83, 65, 80, 117, 98, 108, 105, 99, 75, 101, 121, -42, 114, 125, 13, 4, 25, -21, 123, 2, 0, 1, 76, 0, 1, 121, 116, 0, 22, 76, 106, 97, 118, 97, 47, 109, 97, 116, 104, 47, 66, 105, 103, 73, 110, 116, 101, 103, 101, 114, 59, 120, 114, 0, 25, 115, 117, 110, 46, 115, 101, 99, 117, 114, 105, 116, 121, 46, 120, 53, 48, 57, 46, 88, 53, 48, 57, 75, 101, 121, -75, -96, 29, -66, 100, -102, 114, -90, 3, 0, 3, 76, 0, 5, 97, 108, 103, 105, 100, 116, 0, 31, 76, 115, 117, 110, 47, 115, 101, 99, 117, 114, 105, 116, 121, 47, 120, 53, 48, 57, 47, 65, 108, 103, 111, 114, 105, 116, 104, 109, 73, 100, 59, 91, 0, 10, 101, 110, 99, 111, 100, 101, 100, 75, 101, 121, 116, 0, 2, 91, 66, 91, 0, 3, 107, 101, 121, 113, 0, 126, 0, 4, 120, 112, 122, 0, 0, 1, -69, 48, -126, 1, -73, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 3, -127, -124, 0, 2, -127, -128, 32, -95, 116, 18, -111, 110, 93, -12, 28, 114, 123, 81, -120, -67, 43, -29, -121, 56, 23, 84, -15, -96, -122, -64, 83, 92, 80, 34, 2, 66, 3, -128, -65, 36, 29, -119, 84, 3, 12, -53, 36, 103, -114, -55, -19, -61, 78, -118, -54, -88, -71, 118, 54, 48, -28, 13, 16, 64, 96, -27, 56, 114, -88, -14, -113, -102, 34, 79, -89, -56, 65, 65, -64, -49, -15, 73, 84, -85, 116, 104, -120, -53, 110, -62, -12, -112, -82, 36, 62, -91, 43, -63, -4, 63, 65, 22, 82, -94, -120, 28, 108, -50, -21, 114, 83, -32, 95, -82, -40, 18, -9, -107, -39, 17, 20, 67, -3, -50, 84, -64, -95, 62, 101, 63, 78, 35, 126, 9, 120, 115, 114, 0, 20, 106, 97, 118, 97, 46, 109, 97, 116, 104, 46, 66, 105, 103, 73, 110, 116, 101, 103, 101, 114, -116, -4, -97, 31, -87, 59, -5, 29, 2, 0, 6, 73, 0, 8, 98, 105, 116, 67, 111, 117, 110, 116, 73, 0, 9, 98, 105, 116, 76, 101, 110, 103, 116, 104, 73, 0, 19, 102, 105, 114, 115, 116, 78, 111, 110, 122, 101, 114, 111, 66, 121, 116, 101, 78, 117, 109, 73, 0, 12, 108, 111, 119, 101, 115, 116, 83, 101, 116, 66, 105, 116, 73, 0, 6, 115, 105, 103, 110, 117, 109, 91, 0, 9, 109, 97, 103, 110, 105, 116, 117, 100, 101, 113, 0, 126, 0, 4, 120, 114, 0, 16, 106, 97, 118, 97, 46, 108, 97, 110, 103, 46, 78, 117, 109, 98, 101, 114, -122, -84, -107, 29, 11, -108, -32, -117, 2, 0, 0, 120, 112, -1, -1, -1, -1, 0, 0, 3, -2, -1, -1, -1, -2, -1, -1, -1, -2, 0, 0, 0, 1, 117, 114, 0, 2, 91, 66, -84, -13, 23, -8, 6, 8, 84, -32, 2, 0, 0, 120, 112, 0, 0, 0, -128, 32, -95, 116, 18, -111, 110, 93, -12, 28, 114, 123, 81, -120, -67, 43, -29, -121, 56, 23, 84, -15, -96, -122, -64, 83, 92, 80, 34, 2, 66, 3, -128, -65, 36, 29, -119, 84, 3, 12, -53, 36, 103, -114, -55, -19, -61, 78, -118, -54, -88, -71, 118, 54, 48, -28, 13, 16, 64, 96, -27, 56, 114, -88, -14, -113, -102, 34, 79, -89, -56, 65, 65, -64, -49, -15, 73, 84, -85, 116, 104, -120, -53, 110, -62, -12, -112, -82, 36, 62, -91, 43, -63, -4, 63, 65, 22, 82, -94, -120, 28, 108, -50, -21, 114, 83, -32, 95, -82, -40, 18, -9, -107, -39, 17, 20, 67, -3, -50, 84, -64, -95, 62, 101, 63, 78, 35, 126, 9};
    }
}

