/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.internal.Package;
import com.cisco.cpnm.boot.internal.VersionFile;
import com.cisco.cpnm.boot.internal.VersionXml;
import com.cisco.cpnm.boot.internal.util.JreVersion;
import com.cisco.cpnm.boot.internal.xmllite.CharString;
import com.cisco.cpnm.boot.internal.xmllite.Handler;
import com.cisco.cpnm.boot.internal.xmllite.ParseException;
import com.cisco.cpnm.boot.internal.xmllite.Parser;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

class Distribution
implements Handler,
VersionXml {
    private static final boolean DEBUG = true;
    private VersionFile container;
    private String name;
    private JreVersion jreVer;
    private int majVer;
    private List packages;
    private int numLatest;
    private CharString currElem;

    Distribution(VersionFile container) {
        this.container = container;
        this.packages = new ArrayList();
    }

    URL getFilesystem() {
        return this.container.getFilesystem();
    }

    String getName() {
        return this.name;
    }

    List getPackages() {
        return this.packages;
    }

    boolean isContributing() {
        return this.numLatest > 0;
    }

    void updateNumLatest(boolean isLatest) {
        this.numLatest = isLatest ? ++this.numLatest : --this.numLatest;
        this.container.updateNumLatest(isLatest);
    }

    public void startDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected start-of-document");
    }

    public CharString startElement(Parser parser, CharString element) throws ParseException {
        this.currElem = null;
        if (element.equals(VersionXml.NAME)) {
            this.currElem = VersionXml.NAME;
        } else if (element.equals(VersionXml.MINIMUM_JRE)) {
            this.currElem = VersionXml.MINIMUM_JRE;
        } else if (element.equals(VersionXml.MAJOR_VERSION)) {
            this.currElem = VersionXml.MAJOR_VERSION;
        } else if (element.equals(VersionXml.PACKAGE)) {
            this.currElem = VersionXml.PACKAGE;
            Package pkg = new Package(this);
            this.packages.add(pkg);
            parser.pushHandler(pkg);
        }
        return this.currElem;
    }

    public void elementData(Parser parser, CharString data) throws ParseException {
        if (this.currElem == VersionXml.NAME) {
            this.name = data.toString();
        } else if (this.currElem == VersionXml.MINIMUM_JRE) {
            this.jreVer = new JreVersion(data.toString());
        } else if (this.currElem == VersionXml.MAJOR_VERSION) {
            this.majVer = data.toInt();
        }
    }

    public void endElement(Parser parser, CharString element) throws ParseException {
        if (element.equals(VersionXml.DISTRIBUTION)) {
            parser.popHandler();
        }
    }

    public void endDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected end-of-document");
    }
}

