/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal.jobq;

import com.cisco.cpnm.boot.internal.jobq.Job;
import com.cisco.cpnm.boot.internal.jobq.JobHandler;
import com.cisco.cpnm.boot.internal.jobq.JobQueue;

final class JobThread
extends Thread {
    private JobQueue queue;
    private JobHandler handler;

    JobThread(JobQueue queue, JobHandler handler) {
        this.queue = queue;
        this.handler = handler;
    }

    public final void run() {
        Job job = null;
        while (true) {
            JobQueue jobQueue = this.queue;
            synchronized (jobQueue) {
                if (job != null) {
                    job.setCompleted();
                    this.queue.notifyAll();
                }
                if ((job = this.queue.fetch()) == null) {
                    break;
                }
            }
            try {
                this.handler.process(job.getData(), job.isWaitForCompletion());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.queue.handlerEnding(this);
    }
}

