/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal.ccl;

import com.cisco.cpnm.boot.internal.ccl.BypassUrlStreamHandler;
import com.cisco.cpnm.boot.internal.ccl.ClassData;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public abstract class BypassClassLoader
extends SecureClassLoader {
    private Map mParentClasses;
    private ProtectionDomain mSignedPD;
    private ProtectionDomain mUnsignedPD;
    private URLStreamHandler urlStreamHandler;

    public BypassClassLoader(Class[] parentClasses) {
        this.mParentClasses = new HashMap(parentClasses.length);
        int i = 0;
        while (i < parentClasses.length) {
            this.mParentClasses.put(parentClasses[i].getName(), parentClasses[i]);
            ++i;
        }
        this.initProtectionDomains();
    }

    private void initProtectionDomains() {
        this.mSignedPD = this.getClass().getProtectionDomain();
        Permissions permissions = new Permissions();
        Enumeration<Permission> e = this.mSignedPD.getPermissions().elements();
        while (e.hasMoreElements()) {
            Permission p = e.nextElement();
            if (p instanceof AllPermission) continue;
            permissions.add(p);
        }
        this.mUnsignedPD = new ProtectionDomain(this.mSignedPD.getCodeSource(), permissions);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        try {
            c = this.findSystemClass(name);
            if (c != null) {
                return c;
            }
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        Object o = this.mParentClasses.get(name);
        if (o != null) {
            return (Class)o;
        }
        c = this.findClass(name);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected synchronized Class findClass(String name) throws ClassNotFoundException {
        ClassData classData = this.getClassData(name);
        if (classData == null) {
            throw new ClassNotFoundException(name);
        }
        byte[] bytecode = classData.getContents();
        Class<?> c = this.defineClass(name, bytecode, 0, bytecode.length, classData.isSigned() ? this.mSignedPD : this.mUnsignedPD);
        return c;
    }

    public URL getResource(String name) {
        if (this.urlStreamHandler == null) {
            this.urlStreamHandler = new BypassUrlStreamHandler(this);
        }
        if (this.getStream(name) == null) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(this.getUrlProtocol(), null, -1, name, this.urlStreamHandler);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public InputStream getResourceAsStream(String name) {
        return this.getStream(name);
    }

    protected abstract ClassData getClassData(String var1);

    protected abstract InputStream getStream(String var1);

    protected abstract String getUrlProtocol();
}

