/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.external.MemberFilesysDiscoverer;
import com.cisco.cpnm.boot.internal.ClassFile;
import com.cisco.cpnm.boot.internal.ComponentDb;
import com.cisco.cpnm.boot.internal.DiscoveryClassLoader;
import com.cisco.cpnm.boot.internal.DiscoveryPackage;
import com.cisco.cpnm.boot.internal.FilesysDiscoverer;
import com.cisco.cpnm.boot.internal.SgzReader;
import com.cisco.cpnm.boot.internal.jobq.JobHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class FilesysHandler
implements JobHandler,
DiscoveryPackage {
    private static final boolean DEBUG = true;
    private FilesysDiscoverer filesysDiscoverer;
    private ComponentDb componentDb;
    private DiscoveryClassLoader discoveryClassLoader;

    FilesysHandler(FilesysDiscoverer filesysDiscoverer, ComponentDb componentDb, DiscoveryClassLoader discoveryClassLoader) {
        this.filesysDiscoverer = filesysDiscoverer;
        this.componentDb = componentDb;
        this.discoveryClassLoader = discoveryClassLoader;
    }

    /*
     * Loose catch block
     */
    private void processFilesystem(URL filesystem) {
        ArrayList<String> classes;
        block26: {
            String filename;
            InputStream discoveryStream;
            System.out.println("Processing filesystem: " + filesystem);
            classes = new ArrayList<String>();
            try {
                URL discoveryFile = new URL(filesystem, "mono_disc.sgz");
                discoveryStream = discoveryFile.openStream();
            }
            catch (IOException ioe) {
                return;
            }
            SgzReader sgz = null;
            sgz = new SgzReader(discoveryStream);
            while ((filename = sgz.getNextElement()) != null) {
                int status;
                if (filename.endsWith("version.xml")) {
                    byte[] data = sgz.getElementData();
                    ByteArrayInputStream versionFile = new ByteArrayInputStream(data);
                    this.componentDb.integrateFile(filesystem, versionFile);
                    continue;
                }
                if (!ClassFile.isClassFile(filename) || (status = sgz.getElementStatus()) == 2) continue;
                String className = ClassFile.getClassName(filename);
                byte[] classData = sgz.getElementData();
                this.discoveryClassLoader.addClass(className, classData, status == 1);
                classes.add(className);
            }
            Object var10_13 = null;
            try {
                if (sgz != null) {
                    sgz.close();
                } else if (discoveryStream != null) {
                    discoveryStream.close();
                }
                break block26;
            }
            catch (IOException ioe2) {
                ioe2.printStackTrace();
            }
            break block26;
            {
                catch (MalformedURLException mue) {
                    mue.printStackTrace();
                    Object var10_14 = null;
                    try {
                        if (sgz != null) {
                            sgz.close();
                        } else if (discoveryStream != null) {
                            discoveryStream.close();
                        }
                    }
                    catch (IOException ioe2) {
                        ioe2.printStackTrace();
                    }
                    return;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    Object var10_15 = null;
                    try {
                        if (sgz != null) {
                            sgz.close();
                        } else if (discoveryStream != null) {
                            discoveryStream.close();
                        }
                    }
                    catch (IOException ioe2) {
                        ioe2.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                try {
                    if (sgz != null) {
                        sgz.close();
                    } else if (discoveryStream != null) {
                        discoveryStream.close();
                    }
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace();
                }
                throw throwable;
            }
        }
        this.discoverMemberFilesys(filesystem, classes);
    }

    private void discoverMemberFilesys(URL filesystem, List classes) {
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            MemberFilesysDiscoverer discoverer;
            String className = (String)iter.next();
            try {
                discoverer = (MemberFilesysDiscoverer)this.discoveryClassLoader.loadClass(className).newInstance();
            }
            catch (ClassCastException cce) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            discoverer.init(this.filesysDiscoverer.getMainFilesys(), filesystem);
            URL[] memberFilesys = discoverer.discover();
            if (memberFilesys == null) continue;
            int i = 0;
            while (i < memberFilesys.length) {
                this.filesysDiscoverer.submit(memberFilesys[i]);
                ++i;
            }
        }
    }

    public void process(Object data, boolean waitForCompletion) {
        URL filesystem = (URL)data;
        this.processFilesystem(filesystem);
    }
}

