<!-- Copyright (c) 2005-2006 by Cisco Systems, Inc. -->
// discover.js - Will discover CIGESM devices.
//Supported OS-CIGESM-18, OS-CIGESM18-SFP-E

function OSCIGESM18copperenterprise(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 20;
	dev.x=0;
	dev.y=0;
	dev.image = "images/CIGESM18.gif";	
        dev.scrollYCord = 51;

	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 611;
	tempLed.y = 35;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	//Create FAULT LED
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 622;
	tempLed.y = 35;
	tempLed.id = "fault";
	tempLed.device = dev;
	dev.sysleds["FAULT"] = tempLed;

	var portImages = top.internalportImages();
        // Add the first 14 Internal ports.
	var port;
	var xPortCoord = 181;
        var yPortCoord = 122;
	var portWidth  = 18;
	var xPortGap   = 4;
        
        for(i=0; i<14; i++) {  
                port = new top.internalport(portImages);     
                port.width = 18;
                port.height = 12;
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}

        // Add the first 15th and 16th Internal ports.
	xPortCoord = 526;


	for(i=14; i<16; i++) {       
              	port = new top.internalport(portImages);
           	port.width = 18;
            	port.height = 12;		
                port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}

        portImages = top.rj45portSideImages();
	// Add the 4 Fixed RJ45 ports
        var portheight = 19;
	var yPortGap = 1;
	xPortStartPos = 611;
	xPortCoord = xPortStartPos;
	yPortCoord = 61;

	for(i=16; i<20; i++) {
	        port = new top.rj45portSide(portImages);
        	port.width = 15;
              	port.height = 19;
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;	   	   
		yPortCoord += (portheight + yPortGap);
		dev.addPort(port);
	}

// Adding the label for displaying the slot info.
	var lbl = new top.label(52, 73, 136, 11);
	lbl.id = "lbl0";
	lbl.color = "#ffffff";
	dev.addLabel(lbl);
	return dev;
}

function OSCIGESM18coppertelco(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 20;
	dev.x=0;
	dev.y=0;
	dev.image = "images/CIGESM18_coppertelco.gif";	
        dev.scrollYCord = 51;

	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 611;
	tempLed.y = 35;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	//Create FAULT LED
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 622;
	tempLed.y = 35;
	tempLed.id = "fault";
	tempLed.device = dev;
	dev.sysleds["FAULT"] = tempLed;

	var portImages = top.internalportImages();
        // Add the first 14 Internal ports.
	var port;
	var xPortCoord = 181;
        var yPortCoord = 122;
	var portWidth  = 18;
	var xPortGap   = 4;
        
        for(i=0; i<8; i++) {  
                port = new top.internalport(portImages);     
                port.width = 18;
                port.height = 12;
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}

        // Add the first 15th and 16th Internal ports.
	xPortCoord = 526;


	for(i=8; i<10; i++) {       
              	port = new top.internalport(portImages);
           	port.width = 18;
            	port.height = 12;		
                port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}

        portImages = top.rj45portSideImages();
	// Add the 4 Fixed RJ45 ports
        var portheight = 19;
	var yPortGap = 1;
	xPortStartPos = 611;
	xPortCoord = xPortStartPos;
	yPortCoord = 61;

	for(i=10; i<14; i++) {
	        port = new top.rj45portSide(portImages);
        	port.width = 15;
              	port.height = 19;
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;	   	   
		yPortCoord += (portheight + yPortGap);
		dev.addPort(port);
	}

// Adding the label for displaying the slot info.
	var lbl = new top.label(52, 73, 136, 11);
	lbl.id = "lbl0";
	lbl.color = "#ffffff";
	dev.addLabel(lbl);
	return dev;
}


function OSCIGESM18enterprise(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 16;
	dev.x=0;
	dev.y=0;
	dev.image = "images/stiletto2_enterprise.gif";	
        dev.scrollYCord = 51;

	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 611;
	tempLed.y = 33;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	//Create FAULT LED
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 622;
	tempLed.y = 33;
	tempLed.id = "fault";
	tempLed.device = dev;
	dev.sysleds["FAULT"] = tempLed;

	var portImages = top.internalportImages();
        // Add the first 14 Internal ports.
	var port;
	var xPortCoord = 180;
        var yPortCoord = 127;
	var portWidth  = 18;
	var xPortGap   = 4;
        
        for(i=0; i<14; i++) {  
                port = new top.internalport(portImages);     
                port.width = 18;
                port.height = 12;
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}

        // Add the first 15th and 16th Internal ports.
	xPortCoord = 525;

	for(i=14; i<16; i++) {       
              	port = new top.internalport(portImages);
           	port.width = 18;
            	port.height = 12;		
                port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}

        // Add the 4 SFP ports.
        xPortStartPos = 611;
	xPortCoord = xPortStartPos;
        yPortCoord = 58;
	yPortGap = 1;
        portheight = 21;
	for(i=16; i<20; i++) {       
		port = new top.SFPsideport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		yPortCoord += (portheight + yPortGap);
		dev.addPort(port);
	}	

// Adding the label for displaying the slot info.
	var lbl = new top.label(52, 73, 136, 11);
	lbl.id = "lbl0";
	lbl.color = "#ffffff";
	dev.addLabel(lbl);
	return dev;
}

function OSCIGESM18telco(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 16;
	dev.x=0;
	dev.y=0;
	dev.image = "images/stiletto2_telco.gif";	
        dev.scrollYCord = 51;

	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 611;
	tempLed.y = 33;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	//Create FAULT LED
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 622;
	tempLed.y = 33;
	tempLed.id = "fault";
	tempLed.device = dev;
	dev.sysleds["FAULT"] = tempLed;

	var portImages = top.internalportImages();
        // Add the first 8 Internal ports.
	var port;
	var xPortCoord = 180;
        var yPortCoord = 127;
	var portWidth  = 18;
	var xPortGap   = 4;
        
        for(i=0; i<8; i++) {  
                port = new top.internalport(portImages);     
                port.width = 18;
                port.height = 12;
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}

        // Add the first 15th and 16th Internal ports.
	xPortCoord = 525;

	for(i=8; i<10; i++) {       
              	port = new top.internalport(portImages);
           	port.width = 18;
            	port.height = 12;		
                port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}

        // Add the 4 SFP ports.
        xPortStartPos = 611;
	xPortCoord = xPortStartPos;
        yPortCoord = 58;
	yPortGap = 1;
        portheight = 21;
	for(i=10; i<14; i++) {       
		port = new top.SFPsideport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		yPortCoord += (portheight + yPortGap);
		dev.addPort(port);
	}	

// Adding the label for displaying the slot info.
	var lbl = new top.label(52, 73, 136, 11);
	lbl.id = "lbl0";
	lbl.color = "#ffffff";
	dev.addLabel(lbl);
	return dev;
}



function createDevice(int_status, media_type, deviceType) {
	var device = null;
	if(deviceType == "OS-CIGESM-18TT-EBU-ENT") {
		device = new OSCIGESM18copperenterprise(int_status, media_type);		
	}else
	if(deviceType == "OS-CIGESM-18TT-EBU-TEL") {
		device = new OSCIGESM18coppertelco(int_status, media_type);		
	}else
	if(deviceType == "OS-CIGESM-18SFP-I-ENT") {
		device = new OSCIGESM18enterprise(int_status, media_type);		
	}else
	if(deviceType == "OS-CIGESM-18SFP-I-TEL") {
		device = new OSCIGESM18telco(int_status, media_type);		
	}
	if(device != null) {
		device.type = deviceType;
		device.family = "CIGESM";
	}
	return device;
}

