<!-- Copyright (c) 2004-2005 by Cisco Systems, Inc. -->
// discover.js for c2970 devices.

// CHGESM models.
// OS-CHGESM-24T-E

function OSCHGESM24TE (int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/chgesm24.gif";

	drawLeds(dev);

	// Create the ports
	var port;
	var portWidth = 11;
	var portImages = top.hbportImages();
	var portInvImages = top.hbportImages();
	var xPortGap = 4;
	var xPortStartPos = 550;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	for(i=0; i<24; i++) {
		if(i%2 == 0) {
			yPortCoord = 35;
		} else {
			yPortCoord = 48;
		}
		if(i >= 18 && i <= 21) {
			port = new top.hbport(portImages, int_status[i][6]);
		} else {
			port = new top.hbport(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		
		if(i%2 != 0) {
			xPortCoord -= (portWidth + xPortGap);
		}

		dev.addPort(port);
    }
	
	var rj45Ports = top.rj45portImages();
	xPortStartPos = 325;
	xPortCoord = xPortStartPos;
	portWidth = 19;
	xPortGap = 7;
	yPortCoord = 39;
	for(i=22; i<24; i++) {
		port = new top.rj45port(rj45Ports);
		port.index = i + 2;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + (i + 2);
		xPortCoord -= (portWidth + xPortGap);
		dev.addPort(port);
	}
	
	// Adding the label for displaying the slot info.
	var lbl = new top.label(265, 0, 136, 11);
	lbl.id = "lbl0";
	dev.addLabel(lbl);
	
    dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
	return dev;
}


function OSCHGESM16_8 (int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/chgesm_16_8.gif";

	drawLeds_16_8(dev);

	// Create the ports
	var port;
	var xPortStartPos = 143;
	var xPortCoord = xPortStartPos;
	var yPortCoord = 34;

        // Add the first 16 Internal ports.
	var portWidth  = 18;
	var portHeight = 12;
	var xPortGap   = 2;
	var portImages = top.internalportImages();
        for(i=0; i<16; i++) {  
		if (i%2 == 0)
		{
			yPortCoord = 34;
		}
		else
		{
			yPortCoord = 48;
		} 
                port = new top.internalport(portImages);     
                port.width = 18;
                port.height = 12;
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		if (i%2 == 1 )	xPortCoord += (portWidth + xPortGap);
	}


	// Add the 8 rj45ports ports
	xPortCoord = 515;
	xPortGap = 1;
	portWidth = 19;
	portImages = top.rj45portImages();
	var portInvImages =  top.rj45portInvImages();
	for(i=16; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 28;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 44;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		if( i==17 || i==19 || i == 21 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		
	}


	// Add the 4 sfp ports for Composite ports.
	xPortCoord = 356;
	yPortCoord = 43;
	xPortGap = 2;
	portWidth  = 21;
	portImages = top.rj45portImages();
	for(i=24; i<28; i++) 
	{       
		port = new top.SFPport(int_status[i-8][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;	
		dev.addPort(port);
		xPortCoord += (portWidth+xPortGap);

	}

	// Add the 2 rj45 ports for Composite(internal-external) ports.
	xPortCoord = 303;
	yPortCoord = 34;
	portImages = top.internalportImages();
	for(i=28; i<30; i++) 
	{
		port = new top.internalport(portImages);
		port.index = i;
                port.width = 18;
                port.height = 12;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;	
		dev.addPort(port);
		yPortCoord += 14; 
	       
	}
	// Adding the label for displaying the slot info.
	var lbl = new top.label(265, 0, 136, 9);
	lbl.id = "lbl0";
	dev.addLabel(lbl);
	
   	dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
	return dev;
}


function drawLeds(dev) {

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/hb_mode.gif");
	modeBtn.x = 576;
	modeBtn.y = 44;
	modeBtn.height = 18;
	modeBtn.width = 18;
	modeBtn.id = "CHGESM_mode";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 604;
	tempLed.y = 27;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	//tempLed = new top.led(ledImages);
	//tempLed.x = 604;
	//tempLed.y = 60;
	//tempLed.id = "rps_led";
	//tempLed.device = dev;
	//dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 604;
	tempLed.y = 35;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 604;
	tempLed.y = 43;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 604;
	tempLed.y = 52;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
}

function drawLeds_16_8(dev) {

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/hb_mode.gif");
	modeBtn.x = 42;
	modeBtn.y = 41;
	modeBtn.height = 18;
	modeBtn.width = 18;
	modeBtn.id = "CHGESM_mode";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 36;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 44;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 52;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 26;
	tempLed.y = 60;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	ledImages = top.hbportImages();
	tempLed = new top.led(ledImages);
	tempLed.x = 117;
	tempLed.y = 35;
	tempLed.width = 9;
	tempLed.height = 9;
	tempLed.id = "uid_led";
	tempLed.device = dev;
	dev.sysleds["UID"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 117;
	tempLed.y = 49;
	tempLed.width = 9;
	tempLed.height = 9;
	tempLed.id = "health_led";
	tempLed.device = dev;
	dev.sysleds["HEALTH"] = tempLed;

}



function createDevice(int_status, media_type, deviceType) {
	var device = null;
	if(deviceType == null)
		return device;
	if(deviceType.indexOf("OS-371098HP00-24T-E") != -1 || deviceType.indexOf("371098-001") != -1) { // OS-CHGESM-24T-E
		device = new OSCHGESM24TE(int_status, media_type);
		device.type = deviceType;
		device.family = "CGESM";
	}else if(deviceType.indexOf("WS-CBS3020-HPQ") != -1 ) { 
		device = new OSCHGESM16_8(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3020";
	}
	return device;
}
