<!-- Copyright (c) 2004-2006 by Cisco Systems, Inc. -->
// discover.js for Dell-Machete devices.

// models.
// Machete, halberd2

function OSCHGESM16_8 (int_status, media_type) {
        var dev = new top.device();
        dev.noofports = 25;
        dev.x=0;
        dev.y=0;
        dev.image = "images/chgesm_16_8.gif";

        drawLeds_16_8(dev);

        // Create the ports
        var port;
        var xPortStartPos = 162;
        var xPortCoord = xPortStartPos;
        var yPortCoord = 34;

        // Add the first 16 Internal ports.
        var portWidth  = 18;
        var portHeight = 12;
        var xPortGap   = 2;
        var portImages = top.internalportImages();
        for(i=0; i<16; i++) {
                if (i%2 == 0)
                {
                        yPortCoord = 34;
                }
                else
                {
                        yPortCoord = 48;
                }
                port = new top.internalport(portImages);
                port.width = 18;
                port.height = 12;
                port.index = i;
                port.x = xPortCoord;
                port.y = yPortCoord;
                port.id = "port_" + i;
                dev.addPort(port);
                if (i%2 == 1 )  xPortCoord += (portWidth + xPortGap);
        }


        // Add the 8 rj45ports ports
        xPortCoord = 515;
        xPortGap = 1;
        portWidth = 19;
        portImages = top.rj45portImages();
        var portInvImages =  top.rj45portInvImages();
        for(i=16; i<24; i++)
        {
                if(i%2 == 0)
		{
                        yPortCoord = 28;
                        port = new top.rj45portInv(portInvImages);
                }
                else
                {
                        yPortCoord = 44;
                        port = new top.rj45port(portImages);
                }
                port.index = i;
                port.x = xPortCoord;
                port.y = yPortCoord;
                port.id = "port_" + i;
                dev.addPort(port);
                if( i==17 || i==19 || i == 21 )
                {
                        xPortCoord += portWidth + xPortGap;
                }

        }


        // Add the 4 sfp ports for Composite ports.
        xPortCoord = 386;
        yPortCoord = 43;
        xPortGap = 2;
        portWidth  = 21;
        portImages = top.rj45portImages();
        for(i=24; i<28; i++)
        {
		var intType = int_status[i-8][6].indexOf("SFP") != -1 ? int_status[i-8][6] : "Not Present";
                port = new top.SFPport(intType, portImages);
                port.index = i;
                port.x = xPortCoord;
                port.y = yPortCoord;
                port.id = "port_" + i;
                dev.addPort(port);
                xPortCoord += (portWidth+xPortGap);

        }

        // Add the 2 rj45 ports for Composite(internal-external) ports.
        xPortCoord = 322;
        yPortCoord = 34;
        portImages = top.internalportImages();
        for(i=28; i<30; i++)
        {
                port = new top.internalport(portImages);
                port.index = i;
                port.width = 18;
                port.height = 12;
                port.x = xPortCoord;
                port.y = yPortCoord;
                port.id = "port_" + i;
                dev.addPort(port);
                yPortCoord += 14;

        }
         portImages = top.internalportImages();
         port = new top.internalport(portImages);
         port.index = 30;
         port.width = 18;
         port.height = 12;
         port.x = 142;
         port.y = 34;
         port.id = "port_" + 30;
         dev.addPort(port);
        // Adding the label for displaying the slot info.
        var lbl = new top.label(265, 0, 136, 9);
        lbl.id = "lbl0";
        dev.addLabel(lbl);

        dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
        return dev;
}


function Machete(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 16;
	dev.x=20;
	dev.y=0;
	dev.image = "";
	dev.image = "images/machete.gif";

	drawLeds(dev);

	// Create the ports
	var port;
	var portWidth = 18;
	var portImages = top.internalportImages();
	var xPortGap = 2;
	var xPortStartPos = 86;
	var xPortCoord = xPortStartPos;
	var yPortCoord=24;
       // Add the 10 internal ports.
       for(i=0; i<10; i++) {
               port = new top.internalport(portImages);
               port.index = i;
               port.x = xPortCoord;
               port.y = yPortCoord;
               port.width = 18;
               port.height = 12;
               port.id = "port_" + i;
               xPortCoord += xPortGap+portWidth;
               dev.addPort(port);
   	}
	// Add the 2 rj45 ports.
	xPortGap = 1;
	xPortCoord = 303;
	yPortCoord=21;
	portWidth = 19;
	portImages = top.rj45portImages();
       for(i=10; i<12; i++) {
               port = new top.rj45port(portImages);
               port.index = i;
               port.x = xPortCoord;
               port.y = yPortCoord;
               port.id = "port_" + i;
               xPortCoord += xPortGap+portWidth;
               dev.addPort(port);
   	}
	// Add the 4 SFP ports.
	xPortGap = 2;
	xPortCoord = 359;
	yPortCoord=20;
	portWidth = 21;
	for(i=12; i<16; i++) {       
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}
	port = new top.rj45port(portImages);
	
	// Adding the label for displaying the slot info.
	var lbl = new top.label(110, 0, 146, 11);
	lbl.id = "lbl0";
	dev.addLabel(lbl);
	
    	dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function Falchion(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 16;
	dev.x=20;
	dev.y=0;
	dev.image = "";
	dev.image = "images/falchion.gif";

	drawLeds(dev);

	// Create the ports
	var port;
	var portWidth = 18;
	var portImages = top.internalportImages();
	var xPortGap = 2;
	var xPortStartPos = 86;
	var xPortCoord = xPortStartPos;
	var yPortCoord=24;
       // Add the 10 internal ports.
       for(i=0; i<10; i++) {
               port = new top.internalport(portImages);
               port.index = i;
               port.x = xPortCoord;
               port.y = yPortCoord;
               port.width = 18;
               port.height = 12;
               port.id = "port_" + i;
               xPortCoord += xPortGap+portWidth;
               dev.addPort(port);
   	}
	// Add the 2 rj45 ports.
	xPortGap = 1;
	xPortCoord = 303;
	yPortCoord=21;
	portWidth = 19;
	portImages = top.rj45portImages();
       for(i=10; i<12; i++) {
               port = new top.rj45port(portImages);
               port.index = i;
               port.x = xPortCoord;
               port.y = yPortCoord;
               port.id = "port_" + i;
               xPortCoord += xPortGap+portWidth;
               dev.addPort(port);
   	}
	// Add the 4 SFP ports.
	xPortGap = 2;
	xPortCoord = 359;
	yPortCoord=20;
	portWidth = 21;
	for(i=12; i<16; i++) {       
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += (portWidth + xPortGap);
		dev.addPort(port);
	}
	port = new top.rj45port(portImages);
	
	// Adding the label for displaying the slot info.
	var lbl = new top.label(110, 0, 146, 11);
	lbl.id = "lbl0";
	dev.addLabel(lbl);
	
    	dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function drawLeds_16_8(dev) {

	   // Create the Mode Btn
        var modeBtn = new top.modebtn("images/hb_mode.gif");
        modeBtn.x = 42;
        modeBtn.y = 41;
        modeBtn.height = 18;
        modeBtn.width = 18;
        modeBtn.id = "CHGESM_mode";
        modeBtn.device = dev;
        dev.modebtn = modeBtn;

        // Create System LEDs
        var ledImages = top.ledImages();
        var tempLed = new top.led(ledImages);
        tempLed.x = 26;
        tempLed.y = 36;
        tempLed.id = "system_led";
        tempLed.device = dev;
	    dev.sysleds["SYSTEM"] = tempLed;

        tempLed = new top.led(ledImages);
        tempLed.x = 26;
        tempLed.y = 44;
        tempLed.id = "status_led";
        tempLed.device = dev;
        dev.sysleds["STATUS"] = tempLed;

        tempLed = new top.led(ledImages);
        tempLed.x = 26;
        tempLed.y = 52;
        tempLed.id = "duplex_led";
        tempLed.device = dev;
        dev.sysleds["DUPLEX"] = tempLed;

        tempLed = new top.led(ledImages);
        tempLed.x = 26;
        tempLed.y = 60;
        tempLed.id = "speed_led";
        tempLed.device = dev;
        dev.sysleds["SPEED"] = tempLed;

        ledImages = top.hbportImages();
        tempLed = new top.led(ledImages);
        tempLed.x = 117;
        tempLed.y = 35;
        tempLed.width = 9;
        tempLed.height = 9;
        tempLed.id = "uid_led";
        tempLed.device = dev;
        dev.sysleds["UID"] = tempLed;

        tempLed = new top.led(ledImages);
        tempLed.x = 117;
        tempLed.y = 49;
        tempLed.width = 9;
        tempLed.height = 9;
        tempLed.id = "health_led";
        tempLed.device = dev;
        dev.sysleds["HEALTH"] = tempLed;

}

function drawLeds(dev) {

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 45;
	tempLed.y = 40;
	tempLed.id = "id_led";
	tempLed.device = dev;
	//dev.sysleds["SYSTEM"] = tempLed;
	//Show "ID" led value for Machete and Falchion devices.
	dev.sysleds["ID"] = tempLed;

	var consoleImages = top.rj45portImages();
	var consolePort = new top.led(consoleImages);
	consolePort.x = 19;
	consolePort.y = 21;
	consolePort.width = 19;
	consolePort.height = 15;
	consolePort.id = "console_port";
	consolePort.device = dev;
	dev.sysleds["CONSOLE"] = consolePort;
}


function createDevice(int_status, media_type, deviceType) {
	var device = null;
	if(deviceType == null)
		return device;
	if(deviceType == "WS-CBS3030-DEL") {
		device = new Machete(int_status, media_type);
                device.type = deviceType;
				device.family = "Catalyst Blade Switch 3030";
	}else if(deviceType == "WS-CBS3020-HPQ") {
                device = new OSCHGESM16_8(int_status, media_type);
                device.type = deviceType;
                device.family = "Catalyst Blade Switch 3020";
    }else if(deviceType == "WS-CBS3040-FSC") {
                device = new Falchion(int_status, media_type);
                device.type = deviceType;
                device.family = "Catalyst Blade Switch 3040";
    }
 
	return device;
}
