'''
Created on Mar. 3, 2018

@author: Feng (Edward) Liu (feliu@cisco.com)

Copyright (c) 2018 by Cisco Systems, Inc.
All rights reserved.

Classes used for Static Routes.
'''
from devpkg.base.dmobject import DMObject
from fmc.parsers import device_object_executor
from ipv4_static_route import IPv4StaticRoutes


class StaticRoute(DMObject):
    GENERAL_STATIC_ROUTE = """
    {
      "type": "StaticRoute",
      "name": "StaticRoute"
    }
    """

    METRIC_DEFAULT_VALUE = '1'

    'Static Route object.'
    def __init__(self, probe):
        DMObject.__init__(self, StaticRoute.__name__)
        self.dm_key_command='createStaticRoute'
        self.dm_key = "StaticRoute"
        self.command_executor=device_object_executor
        self.register_child(IPv4StaticRoutes(probe=probe))
        self.probe = probe

    def ifc2dm(self, no_dm_cfg_stack, dm_cfg_list):
        self.recursive_state = self.get_state_recursive()
                
        if not self.has_ifc_delta_cfg():
            return
        self.get_child('IPv4StaticRoute').ifc2dm(no_dm_cfg_stack,  dm_cfg_list)
