'''
Created on Apr 12, 2015

@author: Puneet Garg

Copyright (c) 2015 by Cisco Systems, Inc.
All rights reserved.

Classes used for Inline Sets.
'''
from devpkg.base.command_interaction import CommandInteraction
from devpkg.base.dmboolean import DMBoolean
from devpkg.base.dmlist import DMList
from devpkg.base.dmobject import DMObject
from devpkg.base.simpletype import SimpleType
from devpkg.base.validators import Validator
from devpkg.utils.state_type import State
from fmc.parsers import device_object_executor, delete_device_object_executor


class InlineSet(DMObject, Validator):
    GENERAL_INLINE_SET = """
    {
                "name": "Test2",
                "type": "InlineSet",
                "failOpenSnortDown" : "true",
                "failOpenSnortBusy" : "false",
                "mtu": 1518
    }    
    """

    MTU_DEFAULT_VALUE = '1518'

    'Inline Set object.'
    def __init__(self, instance, probe):
        super(InlineSet, self).__init__(instance, dm_key='InlineSet')
        self.dm_key_command='createInlineSet'
        self.command_executor=device_object_executor
        self.register_child(SimpleType('mtu', 'mtu', defaults=InlineSet.MTU_DEFAULT_VALUE))
        self.register_child(DMBoolean('failOpenSnortDown', 'failOpenSnortDown', 'enable', defaults = True))
        self.register_child(DMBoolean('failOpenSnortBusy', 'failOpenSnortBusy', 'enable', defaults = False))
        self.probe = probe

    def ifc2dm(self, no_dm_cfg_stack, dm_cfg_list):
        
        'Populate current instance recursive state based on children and dependent objects.'
        self.recursive_state = self.get_state_recursive()
        k, t, n = self.delta_ifc_key
        if k != 13:
            self.ifc_key += self.get_unique_graph_string_append() #add Tenant + Ldev to the name
        local_dm_cfg_list = []
        # Process for commands if state modified.
        if not self.has_ifc_delta_cfg():
            return
                    
        super(InlineSet, self).ifc2dm(no_dm_cfg_stack, local_dm_cfg_list)
        if len(local_dm_cfg_list) != 1:
            local_dm_cfg_list.append(CommandInteraction(self.dm_key, model_key=self.get_config_path()))
        
        
        if self.get_state() == State.CREATE or self.get_state() == State.MODIFY:
        
            local_dm_cfg_list[0].add_basic_interaction("fmc_config/v1/domain/<domainUUID>/devices/devicerecords/<deviceUUID>/inlinesets", self.ifc_key, self.command_executor, InlineSet.GENERAL_INLINE_SET)
            local_dm_cfg_list[0].add_data_param(self.ifc_key, "name")
            if self.delta_ifc_cfg_value['value'].has_key((5, 'mtu', 'mtu')):
                local_dm_cfg_list[0].add_data_param(self.delta_ifc_cfg_value['value'][(5, 'mtu', 'mtu')]['value'], "mtu")
            if self.delta_ifc_cfg_value['value'].has_key((5, 'failOpenSnortBusy', 'failOpenSnortBusy')):
                local_dm_cfg_list[0].add_data_param(self.delta_ifc_cfg_value['value'][(5, 'failOpenSnortBusy', 'failOpenSnortBusy')]['value'], "failOpenSnortBusy")
            if self.delta_ifc_cfg_value['value'].has_key((5, 'failOpenSnortDown', 'failOpenSnortDown')):
                local_dm_cfg_list[0].add_data_param(self.delta_ifc_cfg_value['value'][(5, 'failOpenSnortDown', 'failOpenSnortDown')]['value'], "failOpenSnortDown")
            

        if self.get_state() == State.DESTROY:
            local_dm_cfg_list[0].add_basic_interaction("fmc_config/v1/domain/<domainUUID>/devices/devicerecords/<deviceUUID>/inlinesets", self.ifc_key, delete_device_object_executor, InlineSet.GENERAL_INLINE_SET)

        # Add command for later execution.
        if local_dm_cfg_list.__len__() > 0 and local_dm_cfg_list[0].params.__len__() > 0:
            self.add_cli_to_array(local_dm_cfg_list[0], dm_cfg_list)

class InterfaceInlineSet(CommandInteraction):
    """
    Inline Set Cli used by the Interface
    """
    def __init__(self):
        pass
    
    def Interface(self,model_key, name, local_dm_cfg_list, int_cli):
        self.int_cli = [int_cli]
        #we find the cli made by the other interface and assimilate it to this one. There can only be one
        for cli in local_dm_cfg_list:
            if isinstance(cli, InterfaceInlineSet):
                if len(cli.int_cli) < 2:
                    self.int_cli.append(cli.int_cli[0])
                    local_dm_cfg_list.remove(cli)
        CommandInteraction.__init__(self, "InlineSet", model_key = model_key)
        self.add_basic_interaction('fmc_config/v1/domain/<domainUUID>/devices/devicerecords/<deviceUUID>/inlinesets', name, device_object_executor, InlineSet.GENERAL_INLINE_SET)
        self.add_data_param(name, 'name')
        if len(self.int_cli) >= 2:
            self.int_cli.sort(key=lambda x: x.name, reverse=True)
            self.add_data_param([{
                                "first":{
                                         "name":self.int_cli[0].params['name'],
                                         "type":self.int_cli[0].params['type'],
                                         "id":self.int_cli[0].idParam}, 
                                "second":{
                                          "name":self.int_cli[1].params['name'],
                                          "type":self.int_cli[1].params['type'],
                                          "id":self.int_cli[1].idParam}}], 
                                'inlinepairs')
        self.set_get_to_end()
        self.state = State.CREATE
        local_dm_cfg_list.append(self)
        #we need to find the SecurityZoneInterfaceInline and move it to the front
        cli_list = []
        cli_list_remove = []
        for cli in local_dm_cfg_list:
            if cli.command == "SecurityZoneInterfaceInline":
                cli_list.append(cli)
                cli_list_remove.append(cli)
        for cli in cli_list_remove:
            local_dm_cfg_list.remove(cli)
        for cli in cli_list:
            local_dm_cfg_list.append(cli)
        
class InlineSetList(DMList):
    'A list of Inline Sets'

    def __init__(self, probe=None):
        super(InlineSetList, self).__init__('InlineSet', InlineSet, 'InlineSet', probe=probe)

    def ifc2dm(self, no_dm_cfg_stack,  dm_cfg_list):
        super(InlineSetList, self).ifc2dm(no_dm_cfg_stack,  dm_cfg_list)      
        