'''
Created on Dec 29, 2016

@author: Akshay Ahluwalia

Copyright (c) 2016 by Cisco Systems, Inc.
All rights reserved.

Classes used for SecurityZone.
'''
from devpkg.base.command_interaction import CommandInteraction
from fmc.parsers import network_object_executor, delete_device_object_executor
from devpkg.base.dmobject import DMObject
from devpkg.base.validators import Validator
from devpkg.utils.state_type import State
from devpkg.base.dmlist import DMList

class NetworkIpAddress(DMObject):
    """
    NetworkIpAddress Object
    """
    def __init__(self, instance):
        super(NetworkIpAddress, self).__init__(instance, dm_key="NetworkIpAddress")
        

class NetworkObjectGroup(DMObject, Validator):
    """
    Security Zone Object
    """
    GENERAL_NETWORK_OBJECT_GROUP = """
    {
      "name": "EPG",
      "type": "NetworkGroup"
    }"""
    def __init__(self, instance, probe):
        super(NetworkObjectGroup, self).__init__(instance, dm_key="NetworkObjectGroup", probe=probe)
        self.dm_key_command = "createNetworkObjectGroup"
        self.command_executor=network_object_executor
        self.register_child(DMList('network_ip_address', NetworkIpAddress, probe=probe))
        self.register_child(DMList('host_ip_address', NetworkIpAddress, probe=probe))
        self.probe
    
    def ifc2dm(self, no_dm_cfg_stack, dm_cfg_list):
        self.recursive_state = self.get_state_recursive()

        if not self.has_ifc_delta_cfg():
            return

        if self.get_state() == State.CREATE or self.get_state() == State.MODIFY:

            clii = CommandInteraction(self.dm_key, model_key=self.get_config_path())
            clii.add_basic_interaction("fmc_config/v1/domain/<domainUUID>/object/networkgroups", self.ifc_key, self.command_executor, NetworkObjectGroup.GENERAL_NETWORK_OBJECT_GROUP, getByNameInactive=True)
            clii.add_data_param(self.ifc_key, "name")
            clii.add_data_param("NetworkGroup", "type")
            lit = []
            try:
                for k,v in self.get_child("network_ip_address").children.iteritems():
                    if v.get_state() == State.DESTROY:
                        clii.add_removable('literals', k)
                    else:
                        lit.append({'type':'Network', 'value': k})
                for k,v in self.get_child('host_ip_address').children.iteritems():
                    if v.get_state() == State.DESTROY:
                        clii.add_removable('literals', k)
                    else:
                        lit.append({'type':'Host', 'value': k})
            except:
                pass
            if len(lit) > 0:
                clii.add_data_param(lit, 'literals')
            self.add_cli_to_array(clii, dm_cfg_list)
            
        elif self.get_state() == State.DESTROY:
            clii = CommandInteraction(self.dm_key, model_key=self.get_config_path())
            clii.add_basic_interaction("fmc_config/v1/domain/<domainUUID>/object/networkgroups", self.ifc_key, delete_device_object_executor, NetworkObjectGroup.GENERAL_NETWORK_OBJECT_GROUP, getByNameInactive=True)
            self.add_cli_to_array(clii, dm_cfg_list)
                

class NetworkObjectGroups(DMList):
    'A list of Interfaces'

    def __init__(self, name = NetworkObjectGroup.__name__, child_class = NetworkObjectGroup, probe=None):
        super(NetworkObjectGroups, self).__init__(name, child_class, probe=probe)

    def ifc2dm(self, no_dm_cfg_stack,  dm_cfg_list):
        super(NetworkObjectGroups, self).ifc2dm(no_dm_cfg_stack,  dm_cfg_list)

    'ToDo: CSCvd20931 - Comment out the code block for now to improve the code coverage. The code is not executed for current implementation.'        
#     def append(self, data):
#         pass#make the child and add it