/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;

public class EthernetId
extends HostId
implements FlexlmConstants {
    private String ethernetAddress;
    private byte[] ethernetBytes;

    public EthernetId() throws FlexlmException {
        this("000000000000");
    }

    public EthernetId(String string) throws FlexlmException {
        String string2;
        if (string != null) {
            string2 = string.trim();
            if (string2.length() != 12 || !this.isHex(string2)) {
                throw new FlexlmException(-503, 2011);
            }
        } else {
            throw new FlexlmException(-503, 2012);
        }
        this.ethernetAddress = string2;
        this.ethernetBytes = this.getEtherBytes(this.ethernetAddress);
    }

    public HostId createNew(String string) throws FlexlmException {
        return new EthernetId(string);
    }

    public boolean isCurrentHost() {
        return false;
    }

    public HostId[] getCurrentHostIds() {
        return null;
    }

    public String getKeyword() {
        return null;
    }

    public int getType() {
        return 2;
    }

    public int getCryptCode() {
        return 0;
    }

    public String toString() {
        return this.ethernetAddress;
    }

    public Object getValue() {
        return this.ethernetBytes;
    }

    private byte[] getEtherBytes(String string) {
        byte[] byArray = new byte[6];
        int n = 0;
        while (n < 6) {
            String string2 = string.substring(n * 2, n * 2 + 2);
            byArray[n] = (byte)Integer.parseInt(string2, 16);
            ++n;
        }
        return byArray;
    }

    protected int compareValueTo(Object object) {
        byte[] byArray = (byte[])this.getValue();
        byte[] byArray2 = (byte[])object;
        int n = 0;
        while (n < 6) {
            if (byArray[n] != byArray2[n]) {
                return (byArray[n] & 0xFF) - (byArray2[n] & 0xFF);
            }
            ++n;
        }
        return 0;
    }
}

