/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.comm;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.comm.CheckinMessage;
import com.macrovision.flexlm.comm.CheckoutMessage;
import com.macrovision.flexlm.comm.CommRev;
import com.macrovision.flexlm.comm.CommRev3;
import com.macrovision.flexlm.comm.FeatBundleMessage;
import com.macrovision.flexlm.comm.FeatureAvailableMessage;
import com.macrovision.flexlm.comm.ForceCheckinMessage;
import com.macrovision.flexlm.comm.GenericDaemonInfoMessage;
import com.macrovision.flexlm.comm.HandshakeMessage;
import com.macrovision.flexlm.comm.HeartbeatMessage;
import com.macrovision.flexlm.comm.HeartbeatResponseMessage;
import com.macrovision.flexlm.comm.HelloMessage;
import com.macrovision.flexlm.comm.HostIdMessage;
import com.macrovision.flexlm.comm.LicenseFileDataMessage;
import com.macrovision.flexlm.comm.MessageHeader;
import com.macrovision.flexlm.comm.NUsersMessage;
import com.macrovision.flexlm.comm.NeedHostIdMessage;
import com.macrovision.flexlm.comm.NewReportlogMessage;
import com.macrovision.flexlm.comm.NoSuchFeatureMessage;
import com.macrovision.flexlm.comm.NoUserMessage;
import com.macrovision.flexlm.comm.NotAdminMessage;
import com.macrovision.flexlm.comm.OKMessage;
import com.macrovision.flexlm.comm.QueuedMessage;
import com.macrovision.flexlm.comm.RereadMessage;
import com.macrovision.flexlm.comm.SendLicenseFileDataMessage;
import com.macrovision.flexlm.comm.ShutdownMessage;
import com.macrovision.flexlm.comm.SwitchDebuglogMessage;
import com.macrovision.flexlm.comm.SwitchReportlogMessage;
import com.macrovision.flexlm.comm.TooSoonMessage;
import com.macrovision.flexlm.comm.TryAnotherMessage;
import com.macrovision.flexlm.comm.UserlistMessage;
import com.macrovision.flexlm.comm.Username2Message;
import com.macrovision.flexlm.comm.UsernameMessage;
import com.macrovision.flexlm.comm.VDInfoMessage;
import com.macrovision.flexlm.comm.WhatMessage;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class CommRev4
extends CommRev
implements FlexlmConstants,
FlexlmInternalConstants {
    private static final int CHUNKSIZE = 1024;
    private static final int MSG_NEW_START = 256;
    private static final int MSG_CHECKIN = 256;
    private static final int MSG_CHECKOUT = 257;
    private static final int MSG_HELLO = 258;
    private static final int MSG_MASTER = 259;
    private static final int MSG_MASTER_READY = 260;
    private static final int MSG_ORDER = 261;
    private static final int MSG_REMOVE = 262;
    private static final int MSG_FORCE_CHECKIN = 262;
    private static final int MSG_REREAD = 263;
    private static final int MSG_SEND_LF = 264;
    private static final int MSG_SHELLO = 265;
    private static final int MSG_SHUTDOWN = 266;
    private static final int MSG_VHELLO = 267;
    private static final int MSG_REPLY_NO_MESSAGE = 268;
    private static final int MSG_REPLY_OK = 269;
    private static final int MSG_REPLY_OK_HELLO = 270;
    private static final int MSG_REPLY_OK_CHECKIN = 271;
    private static final int MSG_REPLY_OK_CHECKOUT = 272;
    private static final int MSG_REPLY_OK_HELLO_VD = 273;
    private static final int MSG_SERVER_SHUTDOWN = 274;
    private static final int MSG_REPLY_TRY_ANOTHER = 275;
    private static final int MSG_REPLY_USERNAME = 276;
    private static final int MSG_REPLY_USERNAME2 = 277;
    private static final int MSG_REPLY_VD_GEN_INFO = 278;
    private static final int MSG_HELLO_THIS_VD = 279;
    private static final int MSG_HOSTID = 280;
    private static final int COMM4_HEADER_SIZE = 20;
    private static final int HEADER_OLD_COMMAND = 0;
    private static final int HEADER_OLD_CHECKSUM = 1;
    private static final int HEADER_CHECKSUM = 2;
    private static final int HEADER_MSG_SIZE = 4;
    private static final int HEADER_NEW_COMMAND = 6;
    private static final int HEADER_MSG_ID = 8;
    private static final int HEADER_SESSION_ID = 12;
    private static final int HEADER_RESERVED = 16;
    private static final short CRC16_VALUE = 14941;
    private static short[] thing_table;
    private static int thing_table_computed;
    private static CommRev4 instance;

    private CommRev4() {
        thing_table = new short[256];
        thing_table_computed = 0;
    }

    public static CommRev getInstance() {
        if (instance == null) {
            instance = new CommRev4();
        }
        return instance;
    }

    public byte[] encodeCheckin(CheckinMessage checkinMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeString(byteArrayOutputStream, checkinMessage.getFeature());
        CommRev4.encodeString(byteArrayOutputStream, checkinMessage.getCode());
        CommRev4.encodeByte(byteArrayOutputStream, checkinMessage.getCheckoutData() == null ? (byte)0 : 49);
        CommRev4.encodeString(byteArrayOutputStream, checkinMessage.getCheckoutData());
        return CommRev4.addHeader(byteArrayOutputStream, 256);
    }

    public CheckinMessage decodeCheckin(byte[] byArray) {
        throw new RuntimeException("decodeCheckin unimplemented");
    }

    public byte[] encodeCheckout(CheckoutMessage checkoutMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        byte by = (byte)checkoutMessage.getQueueMode();
        byte by2 = 0;
        CommRev4.encodeInt(byteArrayOutputStream, checkoutMessage.getNumLic());
        CommRev4.encodeInt(byteArrayOutputStream, checkoutMessage.getDupGroup());
        CommRev4.encodeInt(byteArrayOutputStream, checkoutMessage.getLinger());
        CommRev4.encodeShort(byteArrayOutputStream, (short)0);
        CommRev4.encodeByte(byteArrayOutputStream, (byte)0);
        CommRev4.encodeByte(byteArrayOutputStream, (byte)0);
        CommRev4.encodeByte(byteArrayOutputStream, (byte)1);
        if (by == 0) {
            by2 = 48;
        } else if (by == 2 || by == 1) {
            by2 = 49;
        }
        by2 = (byte)(by2 | 0x40);
        CommRev4.encodeByte(byteArrayOutputStream, by2);
        CommRev4.encodeString(byteArrayOutputStream, null);
        CommRev4.encodeString(byteArrayOutputStream, checkoutMessage.getFeature());
        CommRev4.encodeString(byteArrayOutputStream, checkoutMessage.getVersion());
        String string = checkoutMessage.getCode();
        if (string == null) {
            string = "PORT_AT_HOST_PLUS   ";
        }
        CommRev4.encodeString(byteArrayOutputStream, string);
        CommRev4.encodeString(byteArrayOutputStream, checkoutMessage.getCheckoutData());
        return CommRev4.addHeader(byteArrayOutputStream, 257);
    }

    public CheckoutMessage decodeCheckout(byte[] byArray) {
        throw new RuntimeException("decodeCheckout unimplemented");
    }

    public byte[] encodeHello(HelloMessage helloMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeByte(byteArrayOutputStream, (byte)helloMessage.getVersion());
        CommRev4.encodeByte(byteArrayOutputStream, (byte)helloMessage.getRevision());
        CommRev4.encodeByte(byteArrayOutputStream, (byte)10);
        CommRev4.encodeByte(byteArrayOutputStream, (byte)1);
        CommRev4.encodeShort(byteArrayOutputStream, (short)84);
        CommRev4.encodeShort(byteArrayOutputStream, (short)helloMessage.getServerTimeout());
        CommRev4.encodeInt(byteArrayOutputStream, 0);
        CommRev4.encodeString(byteArrayOutputStream, helloMessage.getUsername());
        CommRev4.encodeString(byteArrayOutputStream, helloMessage.getHost());
        CommRev4.encodeString(byteArrayOutputStream, helloMessage.getDisplay());
        CommRev4.encodeString(byteArrayOutputStream, helloMessage.getVendor());
        CommRev4.encodeString(byteArrayOutputStream, "java_01");
        return CommRev4.addHeader(byteArrayOutputStream, 258);
    }

    public HelloMessage decodeHello(byte[] byArray) {
        throw new RuntimeException("decodeHello unimplmented");
    }

    public byte[] encodeHostId(HostIdMessage hostIdMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeShort(byteArrayOutputStream, (short)hostIdMessage.getHostIdType());
        CommRev4.encodeString(byteArrayOutputStream, hostIdMessage.getHostId());
        return CommRev4.addHeader(byteArrayOutputStream, 280);
    }

    public HostIdMessage decodeHostId(byte[] byArray) {
        throw new RuntimeException("decodeHostId unimplemented");
    }

    public byte[] encodeOK(OKMessage oKMessage) {
        throw new RuntimeException("encodeOK unimplemented");
    }

    public OKMessage decodeOK(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = CommRev4.setBuffer(byArray);
        OKMessage oKMessage = new OKMessage();
        byteArrayInputStream.skip(20L);
        oKMessage.setFlexVer(CommRev4.decodeByte(byteArrayInputStream));
        oKMessage.setFlexRev(CommRev4.decodeByte(byteArrayInputStream));
        oKMessage.setCommVer(CommRev4.decodeByte(byteArrayInputStream));
        oKMessage.setCommRev(CommRev4.decodeByte(byteArrayInputStream));
        oKMessage.setFlexPatch(CommRev4.decodeString(byteArrayInputStream));
        oKMessage.setHost(CommRev4.decodeString(byteArrayInputStream));
        oKMessage.setDaemon(CommRev4.decodeString(byteArrayInputStream));
        return oKMessage;
    }

    public byte[] encodeForceCheckin(ForceCheckinMessage forceCheckinMessage) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        int n = forceCheckinMessage.getHandle();
        if (n != 0) {
            CommRev3 commRev3 = (CommRev3)CommRev3.getInstance();
            byArray = commRev3.encodeForceCheckin(forceCheckinMessage);
        } else {
            CommRev4.encodeString(byteArrayOutputStream, forceCheckinMessage.getFeature());
            CommRev4.encodeString(byteArrayOutputStream, forceCheckinMessage.getUser());
            CommRev4.encodeString(byteArrayOutputStream, forceCheckinMessage.getHost());
            CommRev4.encodeString(byteArrayOutputStream, forceCheckinMessage.getDisplay());
            CommRev4.encodeByte(byteArrayOutputStream, (byte)0);
            CommRev4.encodeByte(byteArrayOutputStream, (byte)0);
            byArray = CommRev4.addHeader(byteArrayOutputStream, 262);
        }
        return byArray;
    }

    public ForceCheckinMessage decodeForceCheckin(byte[] byArray) {
        throw new RuntimeException("decodeForceCheckin unimplemented");
    }

    public byte[] encodeReread(RereadMessage rereadMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeString(byteArrayOutputStream, rereadMessage.getUser());
        CommRev4.encodeString(byteArrayOutputStream, rereadMessage.getHost());
        CommRev4.encodeString(byteArrayOutputStream, rereadMessage.getDaemon());
        int n = rereadMessage.getIpAddress().getAddress()[0] << 24 & 0xFF000000;
        n |= rereadMessage.getIpAddress().getAddress()[1] << 16 & 0xFF0000;
        n |= rereadMessage.getIpAddress().getAddress()[2] << 8 & 0xFF00;
        CommRev4.encodeInt(byteArrayOutputStream, n |= rereadMessage.getIpAddress().getAddress()[3] & 0xFF);
        return CommRev4.addHeader(byteArrayOutputStream, 263);
    }

    public byte[] encodeShutdown(ShutdownMessage shutdownMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeByte(byteArrayOutputStream, (byte)0);
        CommRev4.encodeString(byteArrayOutputStream, shutdownMessage.getUser());
        CommRev4.encodeString(byteArrayOutputStream, shutdownMessage.getHost());
        CommRev4.encodeString(byteArrayOutputStream, shutdownMessage.getDaemon());
        int n = shutdownMessage.getIpAddress().getAddress()[0] << 24 & 0xFF000000;
        n |= shutdownMessage.getIpAddress().getAddress()[1] << 16 & 0xFF0000;
        n |= shutdownMessage.getIpAddress().getAddress()[2] << 8 & 0xFF00;
        CommRev4.encodeInt(byteArrayOutputStream, n |= shutdownMessage.getIpAddress().getAddress()[3] & 0xFF);
        if (shutdownMessage.getForce()) {
            CommRev4.encodeByte(byteArrayOutputStream, (byte)2);
        }
        return CommRev4.addHeader(byteArrayOutputStream, 266);
    }

    public RereadMessage decodeReread(byte[] byArray) {
        throw new RuntimeException("decodeReread unimplemented");
    }

    public ShutdownMessage decodeShutdown(byte[] byArray) {
        throw new RuntimeException("decodeShutdown unimplemented");
    }

    public byte[] encodeSendLicenseFileData(SendLicenseFileDataMessage sendLicenseFileDataMessage) {
        ByteArrayOutputStream byteArrayOutputStream = CommRev4.getBuffer();
        CommRev4.encodeByte(byteArrayOutputStream, (byte)sendLicenseFileDataMessage.getVersion());
        CommRev4.encodeByte(byteArrayOutputStream, (byte)sendLicenseFileDataMessage.getRevision());
        CommRev4.encodeString(byteArrayOutputStream, sendLicenseFileDataMessage.getUsername());
        CommRev4.encodeString(byteArrayOutputStream, sendLicenseFileDataMessage.getHost());
        CommRev4.encodeString(byteArrayOutputStream, sendLicenseFileDataMessage.getVendor());
        CommRev4.encodeString(byteArrayOutputStream, sendLicenseFileDataMessage.getDisplay());
        CommRev4.encodeString(byteArrayOutputStream, sendLicenseFileDataMessage.getFinderType());
        return CommRev4.addHeader(byteArrayOutputStream, 264);
    }

    public SendLicenseFileDataMessage decodeSendLicenseFileData(byte[] byArray) {
        throw new RuntimeException("decodeSendLicenseFileData unimplmented");
    }

    public byte[] encodeTryAnother(TryAnotherMessage tryAnotherMessage) {
        throw new RuntimeException("encodeTryAnother unimplemented");
    }

    public TryAnotherMessage decodeTryAnother(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = CommRev4.setBuffer(byArray);
        TryAnotherMessage tryAnotherMessage = new TryAnotherMessage();
        byteArrayInputStream.skip(20L);
        tryAnotherMessage.setHost(CommRev4.decodeString(byteArrayInputStream));
        tryAnotherMessage.setPort(CommRev4.decodeInt(byteArrayInputStream));
        tryAnotherMessage.setHost2(CommRev4.decodeString(byteArrayInputStream));
        CommRev4.decodeInt(byteArrayInputStream);
        tryAnotherMessage.setProtocol(CommRev4.decodeByte(byteArrayInputStream));
        tryAnotherMessage.setReason(CommRev4.decodeByte(byteArrayInputStream));
        return tryAnotherMessage;
    }

    public byte[] encodeUsername(UsernameMessage usernameMessage) {
        throw new RuntimeException("encodeUsername unimplemented");
    }

    public UsernameMessage decodeUsername(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = CommRev4.setBuffer(byArray);
        UsernameMessage usernameMessage = new UsernameMessage();
        byteArrayInputStream.skip(20L);
        usernameMessage.setName(CommRev4.decodeString(byteArrayInputStream).getBytes());
        usernameMessage.setNode(CommRev4.decodeString(byteArrayInputStream).getBytes());
        usernameMessage.setDisplay(CommRev4.decodeString(byteArrayInputStream).getBytes());
        usernameMessage.setVersion(CommRev4.decodeString(byteArrayInputStream).getBytes());
        usernameMessage.setNumLic(CommRev4.decodeInt(byteArrayInputStream));
        usernameMessage.setFlags(CommRev4.decodeInt(byteArrayInputStream));
        usernameMessage.setTime(CommRev4.decodeInt(byteArrayInputStream));
        usernameMessage.setLinger(CommRev4.decodeInt(byteArrayInputStream));
        usernameMessage.setHandle(CommRev4.decodeInt(byteArrayInputStream));
        return usernameMessage;
    }

    public byte[] encodeUsername2(Username2Message username2Message) {
        throw new RuntimeException("encodeUsername2 unimplemented");
    }

    public Username2Message decodeUsername2(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = CommRev4.setBuffer(byArray);
        Username2Message username2Message = new Username2Message();
        byteArrayInputStream.skip(20L);
        username2Message.setCheckoutData(CommRev4.decodeString(byteArrayInputStream).getBytes());
        return username2Message;
    }

    public byte[] encodeFeatBundle(FeatBundleMessage featBundleMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeFeatBundle(featBundleMessage);
    }

    public FeatBundleMessage decodeFeatBundle(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeFeatBundle(byArray);
    }

    public byte[] encodeFeatureAvailable(FeatureAvailableMessage featureAvailableMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeFeatureAvailable(featureAvailableMessage);
    }

    public FeatureAvailableMessage decodeFeatureAvailable(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeFeatureAvailable(byArray);
    }

    public byte[] encodeGenericDaemonInfo(GenericDaemonInfoMessage genericDaemonInfoMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeGenericDaemonInfo(genericDaemonInfoMessage);
    }

    public GenericDaemonInfoMessage decodeGenericDaemonInfo(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeGenericDaemonInfo(byArray);
    }

    public byte[] encodeHandshake(HandshakeMessage handshakeMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeHandshake(handshakeMessage);
    }

    public HandshakeMessage decodeHandshake(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeHandshake(byArray);
    }

    public byte[] encodeHeartbeat(HeartbeatMessage heartbeatMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeHeartbeat(heartbeatMessage);
    }

    public HeartbeatMessage decodeHeartbeat(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeHeartbeat(byArray);
    }

    public byte[] encodeHeartbeatResponse(HeartbeatResponseMessage heartbeatResponseMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeHeartbeatResponse(heartbeatResponseMessage);
    }

    public HeartbeatResponseMessage decodeHeartbeatResponse(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeHeartbeatResponse(byArray);
    }

    public byte[] encodeLicenseFileData(LicenseFileDataMessage licenseFileDataMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeLicenseFileData(licenseFileDataMessage);
    }

    public LicenseFileDataMessage decodeLicenseFileData(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeLicenseFileData(byArray);
    }

    public byte[] encodeNeedHostId(NeedHostIdMessage needHostIdMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeNeedHostId(needHostIdMessage);
    }

    public NeedHostIdMessage decodeNeedHostId(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeNeedHostId(byArray);
    }

    public byte[] encodeNewReportlog(NewReportlogMessage newReportlogMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeNewReportlog(newReportlogMessage);
    }

    public NewReportlogMessage decodeNewReportlog(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeNewReportlog(byArray);
    }

    public byte[] encodeNUsers(NUsersMessage nUsersMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeNUsers(nUsersMessage);
    }

    public NUsersMessage decodeNUsers(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeNUsers(byArray);
    }

    public byte[] encodeQueued(QueuedMessage queuedMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeQueued(queuedMessage);
    }

    public QueuedMessage decodeQueued(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeQueued(byArray);
    }

    public byte[] encodeSwitchDebuglog(SwitchDebuglogMessage switchDebuglogMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeSwitchDebuglog(switchDebuglogMessage);
    }

    public SwitchDebuglogMessage decodeSwitchDebuglog(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeSwitchDebuglog(byArray);
    }

    public byte[] encodeSwitchReportlog(SwitchReportlogMessage switchReportlogMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeSwitchReportlog(switchReportlogMessage);
    }

    public SwitchReportlogMessage decodeSwitchReportlog(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeSwitchReportlog(byArray);
    }

    public byte[] encodeUserlist(UserlistMessage userlistMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeUserlist(userlistMessage);
    }

    public UserlistMessage decodeUserlist(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeUserlist(byArray);
    }

    public byte[] encodeVDInfo(VDInfoMessage vDInfoMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeVDInfo(vDInfoMessage);
    }

    public VDInfoMessage decodeVDInfo(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeVDInfo(byArray);
    }

    public byte[] encodeWhat(WhatMessage whatMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeWhat(whatMessage);
    }

    public WhatMessage decodeWhat(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeWhat(byArray);
    }

    public byte[] encodeNoSuchFeature(NoSuchFeatureMessage noSuchFeatureMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeNoSuchFeature(noSuchFeatureMessage);
    }

    public NoSuchFeatureMessage decodeNoSuchFeature(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeNoSuchFeature(byArray);
    }

    public byte[] encodeNotAdmin(NotAdminMessage notAdminMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeNotAdmin(notAdminMessage);
    }

    public NotAdminMessage decodeNotAdmin(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeNotAdmin(byArray);
    }

    public byte[] encodeTooSoon(TooSoonMessage tooSoonMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeTooSoon(tooSoonMessage);
    }

    public TooSoonMessage decodeTooSoon(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeTooSoon(byArray);
    }

    public byte[] encodeNoUser(NoUserMessage noUserMessage) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.encodeNoUser(noUserMessage);
    }

    public NoUserMessage decodeNoUser(byte[] byArray) {
        CommRev commRev = CommRev3.getInstance();
        return commRev.decodeNoUser(byArray);
    }

    private static void encodeByte(ByteArrayOutputStream byteArrayOutputStream, byte by) {
        byteArrayOutputStream.write(by);
    }

    private static byte decodeByte(ByteArrayInputStream byteArrayInputStream) {
        return (byte)byteArrayInputStream.read();
    }

    private static void encodeBuffer(ByteArrayOutputStream byteArrayOutputStream, byte[] byArray, int n) {
        byteArrayOutputStream.write(byArray, 0, n);
    }

    private static byte[] decodeBuffer(ByteArrayInputStream byteArrayInputStream, int n) {
        byte[] byArray = new byte[n];
        byteArrayInputStream.read(byArray, 0, n);
        return byArray;
    }

    private static void encodeShort(ByteArrayOutputStream byteArrayOutputStream, short s) {
        byteArrayOutputStream.write(s >> 8 & 0xFF);
        byteArrayOutputStream.write(s & 0xFF);
    }

    private static void encodeShort(byte[] byArray, int n, short s) {
        byArray[n++] = (byte)(s >> 8 & 0xFF);
        byArray[n] = (byte)(s & 0xFF);
    }

    private static short decodeShort(ByteArrayInputStream byteArrayInputStream) {
        int n = 0;
        n = byteArrayInputStream.read() << 8;
        return (short)(n += byteArrayInputStream.read());
    }

    private static short decodeShort(byte[] byArray, int n) {
        short s = 0;
        s = (short)(byArray[n++] << 8);
        s = (short)(s + ((short)byArray[n] & 0xFF));
        return s;
    }

    private static void encodeInt(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byteArrayOutputStream.write(n >> 24 & 0xFF);
        byteArrayOutputStream.write(n >> 16 & 0xFF);
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
    }

    private static void encodeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n] = (byte)(n2 & 0xFF);
    }

    private static int decodeInt(ByteArrayInputStream byteArrayInputStream) {
        int n = 0;
        n = byteArrayInputStream.read() << 24;
        n += byteArrayInputStream.read() << 16 & 0xFF0000;
        n += byteArrayInputStream.read() << 8 & 0xFF00;
        return n += byteArrayInputStream.read() & 0xFF;
    }

    private static int decodeInt(byte[] byArray, int n) {
        int n2 = 0;
        n2 = byArray[n++] << 24;
        n2 += byArray[n++] << 16 & 0xFF0000;
        n2 += byArray[n++] << 8 & 0xFF00;
        return n2 += byArray[n] & 0xFF;
    }

    private static void encodeString(ByteArrayOutputStream byteArrayOutputStream, String string) {
        byte[] byArray = null;
        if (string != null && (byArray = string.getBytes()) != null && byArray.length > 0) {
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        byteArrayOutputStream.write(0);
    }

    private static String decodeString(ByteArrayInputStream byteArrayInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = byteArrayInputStream.available();
        int n2 = 0;
        int n3 = 0;
        n2 = 0;
        while (n2 < n) {
            n3 = byteArrayInputStream.read();
            if ((byte)n3 == 0) break;
            byteArrayOutputStream.write((byte)n3);
            ++n2;
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    private static byte calcOldChecksum(byte[] byArray, int n) {
        int n2 = 0;
        byte by = byArray[0];
        n2 = 2;
        while (n2 < n) {
            by = (byte)(by + byArray[n2]);
            ++n2;
        }
        return by;
    }

    private static short calcNewChecksum(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        short s = 0;
        int n5 = 0;
        if (thing_table_computed == 0) {
            n4 = 0;
            n4 = 0;
            while (n4 < 256) {
                n3 = 0;
                n3 = n4;
                s = 0;
                n5 = 8;
                while (n5 != 0) {
                    s = ((n3 ^ s) & 1) != 0 ? (short)(s >> 1 ^ 0x3A5D) : (short)(s >> 1);
                    n3 = (short)(n3 >> 1);
                    --n5;
                }
                CommRev4.thing_table[n4] = s;
                n4 = (short)(n4 + 1);
            }
            thing_table_computed = 1;
        }
        s = 0;
        n5 = 0;
        while (n5 < n2) {
            n4 = s & 0xFF;
            n3 = byArray[n + n5];
            int n6 = (n4 ^ n3) & 0xFF;
            s = (short)(s >> 8 ^ thing_table[n6]);
            ++n5;
        }
        return s;
    }

    private static void copyBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray == null || byArray2 == null) {
            return;
        }
        int n4 = 0;
        while (n4 < n2 && n + n4 < byArray.length && n3 + n4 < byArray2.length) {
            byArray[n + n4] = byArray2[n3 + n4];
            ++n4;
        }
    }

    private static byte[] addHeader(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = new byte[20 + byArray.length];
        CommRev4.copyBytes(byArray2, 20, byArray.length, byArray, 0);
        byArray2[0] = 47;
        CommRev4.encodeShort(byArray2, 6, (short)n);
        CommRev4.encodeInt(byArray2, 8, 0);
        CommRev4.encodeInt(byArray2, 12, 0);
        CommRev4.encodeInt(byArray2, 16, 0);
        CommRev4.encodeShort(byArray2, 4, (short)byArray2.length);
        CommRev4.encodeShort(byArray2, 2, CommRev4.calcNewChecksum(byArray2, 4, byArray2.length - 4));
        byArray2[1] = CommRev4.calcOldChecksum(byArray2, 20);
        return byArray2;
    }

    private static ByteArrayOutputStream getBuffer() {
        return new ByteArrayOutputStream();
    }

    private static ByteArrayInputStream setBuffer(byte[] byArray) {
        return new ByteArrayInputStream(byArray);
    }

    protected int getMessageLength(byte[] byArray, int n) {
        return CommRev4.decodeShort(byArray, 4);
    }

    protected void setChecksum(byte[] byArray) {
        if (byArray[0] == 47) {
            CommRev4.encodeShort(byArray, 2, CommRev4.calcNewChecksum(byArray, 4, byArray.length - 4));
        } else {
            CommRev commRev = CommRev3.getInstance();
            commRev.setChecksum(byArray);
        }
    }

    protected boolean checkChecksum(byte[] byArray) {
        if (byArray[0] == 47) {
            short s;
            short s2 = CommRev4.decodeShort(byArray, 2);
            if (s2 == (s = CommRev4.calcNewChecksum(byArray, 4, byArray.length - 4))) {
                return this.checkHeaderChecksum(byArray);
            }
            return false;
        }
        CommRev commRev = CommRev3.getInstance();
        return commRev.checkChecksum(byArray);
    }

    protected boolean checkHeaderChecksum(byte[] byArray) {
        return byArray[1] == CommRev4.calcOldChecksum(byArray, 20);
    }

    public void encryptMessage(byte[] byArray, int n) {
        this.encryptBytes(byArray, n);
    }

    public void decryptMessage(byte[] byArray, MessageHeader messageHeader, int n) {
        this.decryptBytes(byArray, n);
    }

    public void encryptBytes(byte[] byArray, int n) {
        CommRev commRev = CommRev3.getInstance();
        CommRev3 cfr_ignored_0 = (CommRev3)commRev;
        CommRev3.encryptBytes(byArray, n);
    }

    public void decryptBytes(byte[] byArray, int n) {
        CommRev commRev = CommRev3.getInstance();
        CommRev3 cfr_ignored_0 = (CommRev3)commRev;
        CommRev3.decryptBytes(byArray, MessageHeader.getHeaderLength(), byArray.length - MessageHeader.getHeaderLength(), n);
    }

    protected int getMessageType(byte[] byArray) throws FlexlmException {
        int n = 65552;
        if (byArray == null || byArray.length == 0) {
            throw new FlexlmException(-506, 1021);
        }
        if (byArray[0] == 47) {
            n = CommRev4.decodeShort(byArray, 6);
            switch (n) {
                case 256: {
                    n = 65540;
                    break;
                }
                case 257: {
                    n = 65542;
                    break;
                }
                case 258: {
                    n = 65539;
                    break;
                }
                case 262: {
                    n = 65544;
                    break;
                }
                case 266: {
                    n = 65543;
                    break;
                }
                case 269: 
                case 270: 
                case 271: 
                case 272: 
                case 273: {
                    n = 65561;
                    break;
                }
                case 275: {
                    n = 65553;
                    break;
                }
                case 276: {
                    n = 65569;
                    break;
                }
                case 277: {
                    n = 65568;
                    break;
                }
                case 280: {
                    n = 65567;
                    break;
                }
                default: {
                    CommRev commRev = CommRev3.getInstance();
                    n = commRev.getMessageType(byArray);
                }
            }
        }
        return n;
    }
}

