/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm;

import com.macrovision.flexlm.ConnectionData;
import com.macrovision.flexlm.ConnectionDataAdapter;
import com.macrovision.flexlm.Feature;
import com.macrovision.flexlm.FeatureSpecifier;
import com.macrovision.flexlm.FeatureUsage;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;
import com.macrovision.flexlm.License;
import com.macrovision.flexlm.ServerInfo;
import com.macrovision.flexlm.Userlist;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.licsource.LicenseFile;
import com.macrovision.flexlm.licsource.LicenseServer;
import com.macrovision.flexlm.licsource.LicenseString;
import com.macrovision.flexlm.lictext.FeatureLine;
import com.macrovision.flexlm.lictext.FlexlmDate;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

public abstract class LicenseSource
implements FlexlmConstants,
FlexlmInternalConstants {
    protected Vector licensesCheckedOut;
    protected ConnectionData connectionData;

    protected LicenseSource() {
    }

    public static LicenseSource createLicenseSource(String string, VendorInfo vendorInfo, ConnectionData connectionData) throws FlexlmException {
        int n = string.indexOf("&");
        if (n != -1) {
            throw new FlexlmException(-526, 7025, string);
        }
        if (string.startsWith("{{{") && string.endsWith("}}}")) {
            return new LicenseString(string, vendorInfo, connectionData);
        }
        boolean bl = LicenseSource.hasWhite(string);
        boolean bl2 = LicenseSource.hasChar(string, "@");
        if (!bl && bl2 && string.length() > 1) {
            return new LicenseServer(string, vendorInfo, connectionData);
        }
        return new LicenseFile(string, vendorInfo, connectionData);
    }

    private static boolean hasWhite(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChar(String string, String string2) {
        return string.indexOf(string2) != -1;
    }

    protected void setConnData(ConnectionData connectionData) {
        this.connectionData = connectionData != null ? connectionData : new ConnectionDataAdapter();
    }

    public abstract String[] getFeatureList(String var1) throws FlexlmException;

    public abstract String[] getFeatureList() throws FlexlmException;

    public abstract Feature[] getFeatureDetails(String var1) throws FlexlmException;

    public abstract FeatureUsage getFeatureUsage(FeatureSpecifier var1, String var2) throws FlexlmException;

    public abstract FeatureUsage getFeatureUsage(FeatureSpecifier var1) throws FlexlmException;

    public abstract ServerInfo getServerInfo() throws FlexlmException;

    public abstract Userlist getUserlist(String var1, String var2) throws FlexlmException;

    protected abstract Feature checkout(FeatureSpecifier var1, int var2, int var3, int var4, byte[] var5, int var6, License var7) throws FlexlmException;

    public abstract void checkin(License var1) throws FlexlmException;

    public abstract boolean checkoutQueued(FeatureSpecifier var1) throws FlexlmException;

    public abstract void enableDateSetbackDetection(boolean var1);

    public abstract String getName();

    public abstract void forceCheckin(String var1, String var2, String var3, String var4) throws FlexlmException;

    public abstract void forceCheckin(String var1, int var2) throws FlexlmException;

    public abstract void shutdownServer() throws FlexlmException;

    protected synchronized void addCheckedOutLicense(License license) {
        if (this.licensesCheckedOut == null) {
            this.licensesCheckedOut = new Vector();
        }
        if (!this.licensesCheckedOut.contains(license)) {
            this.licensesCheckedOut.add(license);
        }
    }

    protected synchronized void removeCheckedOutLicense(License license) {
        if (this.licensesCheckedOut != null) {
            this.licensesCheckedOut.remove(license);
        }
    }

    protected int getCheckedOutLicenseCount() {
        if (this.licensesCheckedOut == null) {
            return 0;
        }
        return this.licensesCheckedOut.size();
    }

    protected Vector getCheckedOutLicenses() {
        return this.licensesCheckedOut;
    }

    public Feature[] getFeaturesCheckedOut() {
        return null;
    }

    protected static void pruneListByEnvironment(LinkedList linkedList, VendorInfo vendorInfo, ConnectionData connectionData) {
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            FeatureLine featureLine = (FeatureLine)listIterator.next();
            try {
                LicenseSource.checkFeatureEnvironmentals(featureLine, vendorInfo, connectionData);
            }
            catch (FlexlmException flexlmException) {
                listIterator.remove();
            }
        }
    }

    protected static void checkFeatureEnvironmentals(FeatureLine featureLine, VendorInfo vendorInfo, ConnectionData connectionData) throws FlexlmException {
        String[] stringArray;
        FlexlmDate flexlmDate = featureLine.getStartDateObject();
        if (flexlmDate != null && flexlmDate.isFuture()) {
            throw new FlexlmException(-31, 3040);
        }
        FlexlmDate flexlmDate2 = featureLine.getExpirationDateObject();
        if (flexlmDate2 != null && flexlmDate2.isPast()) {
            throw new FlexlmException(-10, 3041);
        }
        HostId hostId = featureLine.getHostId();
        if (hostId != null) {
            hostId.setConnectionData(connectionData);
            if (!hostId.isThisHost(vendorInfo)) {
                throw new FlexlmException(-9, 3035);
            }
        }
        if ((stringArray = featureLine.getPlatformsArray()) != null) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!"java_01".startsWith(stringArray[i].toLowerCase())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new FlexlmException(-89, 7014);
            }
        }
    }
}

