'''
Created on Apr 21, 2014

@author: jeffryp

Copyright (c) 2013 by Cisco Systems, Inc.
All rights reserved.
'''

from base.dmlist import DMList
from base.dmobject import DMObject
from firewall import Firewalls
from state_type import State, Type

class SharedConfigs(DMList):
    'Container for the group SharedConfig translator, one per graph'

    def __init__(self):
        DMList.__init__(self, SharedConfig.__name__, SharedConfig)

    def get_translator(self, cli):
        # No CLI is handled in a group
        return None

class SharedConfig(DMObject):
    '''
    This is the group configuration of the ASA, assuming the name of "MGrpCfg"
    element in the device_specifcation is "GroupConfig".

    Add group configuration objects by calling self.register_child(dmobj) in
    the constructor as it is done in DeviceModel.__init(self)__.
    '''

    def __init__(self, instance):
        DMObject.__init__(self, str(instance)) # Normalize instance to a string
        self.register_child(Firewalls())

    def create_missing_ifc_delta_cfg(self):
        'Override the default to take care of the way self.delta_ifc_key is created'

        if  not self.has_ifc_delta_cfg():
            '@todo isolate changes to key creation'
            self.delta_ifc_key = Type.GRP, SharedConfig.__name__, self.ifc_key,
            self.delta_ifc_cfg_value = {'state': State.NOCHANGE, 'value': {}}
            ancestor = self.get_ifc_delta_cfg_ancestor()
            if ancestor:
                ancestor.delta_ifc_cfg_value['value'][self.delta_ifc_key] =  self.delta_ifc_cfg_value

        for child in self.children.values():
            child.create_missing_ifc_delta_cfg()

    def iter_firewalls(self):
        for firewall in self.get_child('Firewall').children.itervalues():
            yield firewall
