'''
Created on Sep 16, 2013

Copyright (c) 2013 by Cisco Systems
@author: dli
'''
from translator.base.simpletype import SimpleType
from translator.state_type import State

class DMBoolean(SimpleType):
    ''' DMBoolean is translator for the type of CLI that turns on/off a particular flag, such as "logging enable'
    '''
    def __init__(self, ifc_key, asa_key,
                  on_value = 'enable',
                  off_value = 'disable',
                  response_parser=None, is_system_context=False):
        '''
        @param on_value: str
            The value in the dictionary to turn on the feature, e.g. 'enable'
        '''
        SimpleType.__init__(self, ifc_key, asa_key,
                             response_parser=response_parser,
                             is_system_context=is_system_context)
        self.on_value = on_value
        self.off_value = off_value

    def ifc2asa(self, no_asa_cfg_stack, asa_cfg_list):
        if not self.has_ifc_delta_cfg():
            return
        if self.get_state() in (State.CREATE, State.MODIFY):
            value = self.get_value()
            if value == self.off_value:
                self.set_state(State.DESTROY)
        return SimpleType.ifc2asa(self, no_asa_cfg_stack, asa_cfg_list)

    def get_cli(self):
        assert self.has_ifc_delta_cfg()
        return self.asa_key

    def parse_cli(self, cli):
        return self.on_value

