/*
 * Decompiled with CFR 0.152.
 */
package TAJava;

import TAJava.StreamCapture;
import java.applet.Applet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class NacAgentCheck
extends Applet {
    private Thread thread = null;
    private static final String WIN_OS = "win";
    private static final String MAC_OS = "mac";
    private static String os = null;
    private static final String AGENT_NAME_EXE = "NACAgentUI.exe";
    private static final String NACAGENT_GENERIC_NAME = "NACAgent";
    private static final String TMP_FILE = "isAppRunning";
    private static final String TMP_FILE_EXTN = ".vbs";
    private static final String CSCRIPT_CMD = "cscript //NoLogo {0}";
    private static final String NETSTART_CMD = "net start {0}";
    private static final String REGISTRY_HKCU = "HKCU";
    private static final String REGISTRY_HKLM = "HKLM";
    private static final String REGISTRY_CMD = "reg query \"{0}\" /v {1}";
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String SUB_KEY = "Software\\Cisco\\Cisco NAC Agent";
    private static final String LOCATION_KEY = "Location";
    private static final String AGENT_NAME = "CCAAgent";
    private static final String AGENT_FIXED_LOCATION = "/Applications/CCAAgent.app";
    private static final String MAC_CMD = "ps -ef | grep -i {0} | grep -v grep";
    private static final String SYSTEM_PROFILER_CMD = "system_profiler SPApplicationsDataType | grep -i {0}";
    private static final String MAC_LAUNCH_APP_CMD = "open {0}";
    public static volatile int agentStatus = AgentStatusEnum.UNKNOWN.agentState();
    private static int RETRY_TIMER = 3000;
    private static final int RETRIAL_COUNTER = 3;

    private static void log(String str) {
        System.out.println(new Date().toString() + " " + str);
    }

    private static void logAndSetStatus(AgentStatusEnum tmpAgentStatus, String str) {
        System.out.println(new Date().toString() + " " + str);
        agentStatus = tmpAgentStatus.agentState();
    }

    private static void setAgentStatus(AgentStatusEnum tmpAgentStatus) {
        agentStatus = tmpAgentStatus.agentState();
    }

    public static AgentStatusEnum getAgentStatus(String os) {
        AgentStatusEnum agentStatus = AgentStatusEnum.NOT_INSTALLED;
        if (null != os && os.contains(WIN_OS)) {
            agentStatus = NacAgentCheck.launchNacAgent(WIN_OS);
        } else if (null != os && os.contains(MAC_OS)) {
            agentStatus = NacAgentCheck.launchNacAgent(MAC_OS);
        }
        return agentStatus;
    }

    private static void startStreamReader(String threadName, InputStream stream, StringWriter writer) {
        StreamCapture inputReader = new StreamCapture(threadName, stream, new PrintWriter((Writer)writer, true));
        inputReader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static AgentServiceStatusEnum isAgentServiceRunning(String serviceName) {
        NacAgentCheck.log("Check if agent service is running");
        ArrayList<String> processBuilderParams = new ArrayList<String>();
        processBuilderParams.add("cmd.exe");
        processBuilderParams.add(" /c ");
        processBuilderParams.add(" sc query " + serviceName + " | " + " find /C \"RUNNING\"");
        BufferedReader buffReader = null;
        InputStream inStream = null;
        InputStream errorStream = null;
        try {
            Process process;
            Process process2 = process = Runtime.getRuntime().exec("cmd /c sc query " + serviceName + " | find /C \"RUNNING\"");
            // MONITORENTER : process2
            inStream = process.getInputStream();
            errorStream = process.getErrorStream();
            StringWriter inWriter = new StringWriter();
            StringWriter errorWriter = new StringWriter();
            NacAgentCheck.startStreamReader("agentServiceInputStream", inStream, inWriter);
            NacAgentCheck.startStreamReader("agentServiceErrorStream", errorStream, errorWriter);
            process.waitFor();
            String inputStr = inWriter.toString();
            String errorStr = errorWriter.toString();
            buffReader = new BufferedReader(new StringReader(inputStr));
            NacAgentCheck.log("Reading the input");
            String line = null;
            while ((line = buffReader.readLine()) != null) {
                NacAgentCheck.log("line: " + line);
                if (line.contains("1")) {
                    AgentServiceStatusEnum agentServiceStatusEnum = AgentServiceStatusEnum.RUNNING;
                    // MONITOREXIT : process2
                    return agentServiceStatusEnum;
                }
                if (!line.contains("0")) continue;
                AgentServiceStatusEnum agentServiceStatusEnum = AgentServiceStatusEnum.NOT_RUNNING;
                // MONITOREXIT : process2
                try {
                    if (null != buffReader) {
                        buffReader.close();
                    }
                    if (null != inStream) {
                        inStream.close();
                    }
                    if (null == errorStream) return agentServiceStatusEnum;
                    errorStream.close();
                    return agentServiceStatusEnum;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return agentServiceStatusEnum;
            }
            buffReader = new BufferedReader(new StringReader(errorStr));
            NacAgentCheck.log("Reading the error");
            line = null;
            while ((line = buffReader.readLine()) != null) {
                NacAgentCheck.log("line: " + line);
            }
            // MONITOREXIT : process2
            return AgentServiceStatusEnum.NOT_RUNNING;
        }
        catch (IOException e) {
            e.printStackTrace();
            return AgentServiceStatusEnum.NOT_RUNNING;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return AgentServiceStatusEnum.NOT_RUNNING;
        }
        finally {
            try {
                if (null != buffReader) {
                    buffReader.close();
                }
                if (null != inStream) {
                    inStream.close();
                }
                if (null != errorStream) {
                    errorStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String scriptToStartAgentServiceWithElevatedPerms(String serviceName) {
        try {
            File file = File.createTempFile(TMP_FILE, TMP_FILE_EXTN);
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            StringBuffer vbScript = new StringBuffer();
            vbScript.append("Set objShell = CreateObject(\"Shell.Application\")\n");
            vbScript.append("objShell.ShellExecute \"net\", \"start " + serviceName + " \", \"\", \"runas\", 0\n");
            vbScript.append("Set objShell = Nothing\n");
            fw.write(vbScript.toString());
            fw.close();
            String string = file.getPath();
            return string;
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static AgentServiceStatusEnum startAgentServiceWithElevatedPerms(String serviceName) throws IOException {
        block25: {
            NacAgentCheck.log("Attempting to start Agent service with elevated permissions...");
            buffReader = null;
            try {
                filePath = NacAgentCheck.scriptToStartAgentServiceWithElevatedPerms(serviceName);
                if (null == filePath) throw new IOException("Could not create vb script to start agent service");
                if (filePath.trim().length() == 0) {
                    throw new IOException("Could not create vb script to start agent service");
                }
                cscriptCMD = MessageFormat.format("cscript //NoLogo {0}", new Object[]{filePath});
                NacAgentCheck.log(">>> Cmd script : " + cscriptCMD);
                process = Runtime.getRuntime().exec(cscriptCMD);
                inStream = process.getInputStream();
                errorStream = process.getErrorStream();
                var7_10 = process;
                // MONITORENTER : var7_10
                inStream = process.getInputStream();
                errorStream = process.getErrorStream();
                inWriter = new StringWriter();
                errorWriter = new StringWriter();
                NacAgentCheck.startStreamReader("StartAgentServiceElevatedInStreamRdr", inStream, inWriter);
                NacAgentCheck.startStreamReader("StartAgentServiceElevatedErrStreamRdr", errorStream, errorWriter);
                process.waitFor();
                inputStr = inWriter.toString();
                errorStr = errorWriter.toString();
                buffReader = new BufferedReader(new StringReader(inputStr));
                line = null;
                while ((line = buffReader.readLine()) != null) {
                    line = line.toLowerCase();
                    NacAgentCheck.log("Service line: " + line);
                    if (line.contains("been started")) {
                        NacAgentCheck.log("Service : " + serviceName + " has been started");
                        var13_16 = AgentServiceStatusEnum.STARTED;
                        // MONITOREXIT : var7_10
                        return var13_16;
                    }
                    if (!line.contains("starting")) continue;
                    NacAgentCheck.log("Service : " + serviceName + " is still starting");
                    var13_17 = AgentServiceStatusEnum.STARTING;
                    // MONITOREXIT : var7_10
                    if (null == buffReader) return var13_17;
                    try {
                        buffReader.close();
                        return var13_17;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return var13_17;
                }
                ** if (null == buffReader) goto lbl-1000
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break block25;
            }
            finally {
                if (null != buffReader) {
                    try {
                        buffReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                try {
                    buffReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        NacAgentCheck.log("Service : " + serviceName + " not started");
        return AgentServiceStatusEnum.NOT_STARTED;
    }

    /*
     * Exception decompiling
     */
    private static AgentServiceStatusEnum startAgentService(String serviceName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean retryLaunchingNacAgentService(String serviceName) {
        AgentServiceStatusEnum tmpServiceStatus = AgentServiceStatusEnum.NOT_STARTED;
        tmpServiceStatus = NacAgentCheck.startAgentService(serviceName);
        switch (tmpServiceStatus) {
            case STARTED: {
                NacAgentCheck.log("Service : NACAgent is running");
                return true;
            }
            case ACCESS_DENIED: {
                NacAgentCheck.log("Trying to start service NACAgent with elevated permissions.");
                try {
                    tmpServiceStatus = NacAgentCheck.startAgentServiceWithElevatedPerms(serviceName);
                    break;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return false;
                }
            }
        }
        int counter = 3;
        while (counter > 0) {
            tmpServiceStatus = NacAgentCheck.isAgentServiceRunning(serviceName);
            NacAgentCheck.log("Checking service: NACAgent status : " + tmpServiceStatus.toString());
            switch (tmpServiceStatus) {
                case RUNNING: {
                    NacAgentCheck.log("Service : NACAgent is running");
                    return true;
                }
                case NOT_RUNNING: {
                    NacAgentCheck.log("Service : NACAgent not running.");
                }
            }
            --counter;
            try {
                Thread.sleep(RETRY_TIMER);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String scriptToCheckAgentProcess(String agentName) {
        try {
            File file = File.createTempFile(TMP_FILE, TMP_FILE_EXTN);
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            StringBuffer vbScript = new StringBuffer();
            vbScript.append("Set WshShell = WScript.CreateObject(\"WScript.Shell\")\n");
            vbScript.append("Set locator = CreateObject(\"WbemScripting.SWbemLocator\")\n");
            vbScript.append("Set service = locator.ConnectServer()\n");
            vbScript.append("Set processes = service.ExecQuery _\n");
            vbScript.append(" (\"select * from Win32_Process where name Like'" + agentName + "%'\")\n");
            vbScript.append("For Each process in processes\n");
            vbScript.append("wscript.echo process.Name \n");
            vbScript.append("Next\n");
            vbScript.append("Set WSHShell = Nothing\n");
            fw.write(vbScript.toString());
            fw.close();
            String string = file.getPath();
            return string;
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isAgentRunningForWindows(String agentName) throws IOException {
        boolean found = false;
        BufferedReader buffReader = null;
        try {
            String filePath = NacAgentCheck.scriptToCheckAgentProcess(agentName);
            if (null == filePath || filePath.trim().length() == 0) {
                throw new IOException("Could not create vb script to check agent process");
            }
            String cscriptCMD = MessageFormat.format(CSCRIPT_CMD, filePath);
            NacAgentCheck.log(">>> Cmd script : " + cscriptCMD);
            Process process = Runtime.getRuntime().exec(cscriptCMD);
            InputStream inStream = process.getInputStream();
            InputStream errorStream = process.getErrorStream();
            StringWriter inWriter = new StringWriter();
            StringWriter errorWriter = new StringWriter();
            NacAgentCheck.startStreamReader("AgentRunningForWindowsInStreamRdr", inStream, inWriter);
            NacAgentCheck.startStreamReader("AgentRunningForWindowsErrStreamRdr", errorStream, errorWriter);
            process.waitFor();
            String inputStr = inWriter.toString();
            String errorStr = errorWriter.toString();
            buffReader = new BufferedReader(new StringReader(inputStr));
            String line = null;
            while ((line = buffReader.readLine()) != null) {
                if (!line.contains(agentName)) continue;
                found = true;
                NacAgentCheck.log("Application " + agentName + " is running.");
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            throw exception;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (null != buffReader) {
                buffReader.close();
            }
        }
        if (!found) {
            NacAgentCheck.log("Application is not running.");
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isAgentRunningForMacOsX(String agentLocation) throws IOException {
        String command = MessageFormat.format(MAC_CMD, agentLocation);
        ArrayList<String> processBuilderParams = new ArrayList<String>();
        processBuilderParams.add("/bin/sh");
        processBuilderParams.add("-c");
        processBuilderParams.add(command);
        BufferedReader buffReader = null;
        try {
            Process process;
            ProcessBuilder processBuilder = new ProcessBuilder(processBuilderParams);
            Process process2 = process = processBuilder.start();
            synchronized (process2) {
                InputStream inStream = process.getInputStream();
                InputStream errorStream = process.getErrorStream();
                StringWriter inWriter = new StringWriter();
                StringWriter errorWriter = new StringWriter();
                NacAgentCheck.startStreamReader("AgentRunningForOsXInStreamRdr", inStream, inWriter);
                NacAgentCheck.startStreamReader("AgentRunningForOsXErrStreamRdr", errorStream, errorWriter);
                process.waitFor();
                String inputStr = inWriter.toString();
                String errorStr = errorWriter.toString();
                buffReader = new BufferedReader(new StringReader(inputStr));
                String line = null;
                while ((line = buffReader.readLine()) != null) {
                    if (!line.contains(agentLocation)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (null != buffReader) {
                buffReader.close();
            }
        }
        return false;
    }

    public static boolean isAgentRunning(String os, String agentLocation) throws IOException {
        boolean isAppRunning = false;
        if (null != os && os.trim().contains(WIN_OS)) {
            isAppRunning = NacAgentCheck.isAgentRunningForWindows(AGENT_NAME_EXE);
        } else if (null != os && os.trim().contains(MAC_OS)) {
            isAppRunning = NacAgentCheck.isAgentRunningForMacOsX(agentLocation);
        }
        return isAppRunning;
    }

    private static boolean retryLaunchingNacAgent(String os, String agentLocation) {
        boolean isAgentRunning = false;
        NacAgentCheck.launchAgent(os, agentLocation);
        int counter = 3;
        while (counter > 0) {
            try {
                isAgentRunning = NacAgentCheck.isAgentRunning(os, agentLocation);
                if (isAgentRunning) {
                    return true;
                }
                Thread.sleep(RETRY_TIMER);
                --counter;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return isAgentRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readRegistry(String location, String key) {
        String registryCmd = MessageFormat.format(REGISTRY_CMD, location, key);
        System.out.println("Registry cmd: " + registryCmd);
        ArrayList<String> processBuilderParams = new ArrayList<String>();
        processBuilderParams.add("cmd.exe");
        processBuilderParams.add("/c");
        processBuilderParams.add(registryCmd);
        ProcessBuilder processBuilder = new ProcessBuilder(processBuilderParams);
        try {
            Process process;
            Process process2 = process = processBuilder.start();
            synchronized (process2) {
                int index;
                InputStream inStream = process.getInputStream();
                InputStream errorStream = process.getErrorStream();
                StringWriter inWriter = new StringWriter();
                StringWriter errorWriter = new StringWriter();
                NacAgentCheck.startStreamReader("ReadRegistryInStreamRdr", inStream, inWriter);
                NacAgentCheck.startStreamReader("ReadRegistryErrStreamRdr", errorStream, errorWriter);
                process.waitFor();
                String inputStr = inWriter.toString();
                String errorStr = errorWriter.toString();
                if (null != inputStr && -1 != (index = inputStr.indexOf(REGSTR_TOKEN))) {
                    return inputStr.substring(index + REGSTR_TOKEN.length()).trim();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return "";
    }

    private static String findAgentLocationInWin(String subKey, String keyName) {
        String agentLocation = "";
        try {
            agentLocation = NacAgentCheck.readRegistry("HKCU\\" + subKey, keyName);
            if ("".equals(agentLocation)) {
                agentLocation = NacAgentCheck.readRegistry("HKLM\\" + subKey, keyName);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return agentLocation;
    }

    private static String findAgentLocationOnMac() {
        File tmpFile = new File(AGENT_FIXED_LOCATION);
        if (tmpFile.exists()) {
            return AGENT_FIXED_LOCATION;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findAgentLocationInMAC(String agentName) {
        String systemProfilerCmd = null;
        if (null != agentName) {
            systemProfilerCmd = MessageFormat.format(SYSTEM_PROFILER_CMD, agentName);
        }
        ArrayList<String> processBuilderParams = new ArrayList<String>();
        processBuilderParams.add("/bin/sh");
        processBuilderParams.add("-c");
        processBuilderParams.add(systemProfilerCmd);
        ProcessBuilder processBuilder = new ProcessBuilder(processBuilderParams);
        try {
            Process process = processBuilder.start();
            BufferedReader buffReader = null;
            Process process2 = process;
            synchronized (process2) {
                InputStream inStream = process.getInputStream();
                InputStream errorStream = process.getErrorStream();
                StringWriter inWriter = new StringWriter();
                StringWriter errorWriter = new StringWriter();
                NacAgentCheck.startStreamReader("AgentLocationInMacInStreamRdr", inStream, inWriter);
                NacAgentCheck.startStreamReader("AgentLocationInMacErrStreamRdr", errorStream, errorWriter);
                process.waitFor();
                String inputStr = inWriter.toString();
                String errorStr = errorWriter.toString();
                buffReader = new BufferedReader(new StringReader(inputStr));
                String line = null;
                try {
                    do {
                        if ((line = buffReader.readLine()) == null) return "";
                    } while (!line.contains(agentName) || !line.contains(LOCATION_KEY));
                    NacAgentCheck.log("line: " + line);
                    StringTokenizer stringTokenizer = new StringTokenizer(line);
                    String agentLocation = null;
                    while (stringTokenizer.hasMoreElements()) {
                        agentLocation = (String)stringTokenizer.nextElement();
                    }
                    String string = agentLocation;
                    return string;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (null != buffReader) {
                        buffReader.close();
                    }
                }
                return "";
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return "";
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String findAgentLocation(String os, String agentName) {
        if (null != os) {
            if (os.contains(WIN_OS)) {
                return NacAgentCheck.findAgentLocationInWin(SUB_KEY, LOCATION_KEY);
            }
            if (os.contains(MAC_OS)) {
                return NacAgentCheck.findAgentLocationOnMac();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchWinProgram(String agentLocation) {
        String command = agentLocation + AGENT_NAME_EXE;
        NacAgentCheck.log("Launching NACAgentUI.exe in Windows: " + command);
        ArrayList<String> processBuilderParams = new ArrayList<String>();
        processBuilderParams.add("cmd");
        processBuilderParams.add("/c ");
        processBuilderParams.add(command);
        ProcessBuilder processBuilder = new ProcessBuilder(processBuilderParams);
        Process process = null;
        InputStream inStream = null;
        InputStream errorStream = null;
        try {
            Process process2 = process = processBuilder.start();
            synchronized (process2) {
                inStream = process.getInputStream();
                errorStream = process.getErrorStream();
                StringWriter inWriter = new StringWriter();
                StringWriter errorWriter = new StringWriter();
                NacAgentCheck.startStreamReader("LaunchWinProgramInStreamRdr", inStream, inWriter);
                NacAgentCheck.startStreamReader("LaunchWinProgramErrStreamRdr", errorStream, errorWriter);
                String inputStr = inWriter.toString();
                String errorStr = errorWriter.toString();
                if (null != inputStr && inputStr.trim().length() != 0) {
                    System.out.println("InputStr : " + inputStr);
                }
                if (null != errorStr && errorStr.trim().length() != 0) {
                    System.out.println("ErrorStr : " + errorStr);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchMacOsXProgram(String agentLocation) {
        String command = MessageFormat.format(MAC_LAUNCH_APP_CMD, agentLocation);
        NacAgentCheck.log("Launching cca agent in Mac OsX" + command);
        ArrayList<String> processBuilderParams = new ArrayList<String>();
        processBuilderParams.add("/bin/sh");
        processBuilderParams.add("-c");
        processBuilderParams.add(command);
        ProcessBuilder processBuilder = new ProcessBuilder(processBuilderParams);
        Process process = null;
        InputStream inStream = null;
        InputStream errorStream = null;
        try {
            Process process2 = process = processBuilder.start();
            synchronized (process2) {
                inStream = process.getInputStream();
                errorStream = process.getErrorStream();
                StringWriter inWriter = new StringWriter();
                StringWriter errorWriter = new StringWriter();
                NacAgentCheck.startStreamReader("LaunchOsXProgramInStreamRdr", inStream, inWriter);
                NacAgentCheck.startStreamReader("LaunchOsXProgramErrStreamRdr", errorStream, errorWriter);
                process.waitFor();
                String inputStr = inWriter.toString();
                String errorStr = errorWriter.toString();
                if (null != inputStr && inputStr.trim().length() != 0) {
                    System.out.println("InputStr : " + inputStr);
                }
                if (null != errorStr && errorStr.trim().length() != 0) {
                    System.out.println("ErrorStr : " + errorStr);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void launchAgent(String os, String agentLocation) {
        if (null != os && os.trim().contains(WIN_OS)) {
            NacAgentCheck.launchWinProgram(agentLocation);
        } else if (null != os && os.trim().contains(MAC_OS)) {
            NacAgentCheck.launchMacOsXProgram(agentLocation);
        }
    }

    public static AgentStatusEnum launchNacAgent(String os) {
        String agentLocation = NacAgentCheck.findAgentLocation(os, AGENT_NAME);
        NacAgentCheck.log("Agent Location: " + agentLocation);
        if (null != agentLocation && agentLocation.trim().length() != 0) {
            NacAgentCheck.setAgentStatus(AgentStatusEnum.INSTALLED);
            boolean isAgentRunning = false;
            try {
                if (null != os && os.contains(WIN_OS)) {
                    boolean isAgentServiceRunning = false;
                    AgentServiceStatusEnum agentServiceStatus = NacAgentCheck.isAgentServiceRunning(NACAGENT_GENERIC_NAME);
                    NacAgentCheck.log("Agent service status : " + (Object)((Object)agentServiceStatus));
                    switch (agentServiceStatus) {
                        case RUNNING: {
                            NacAgentCheck.log("Service : NACAgent is running");
                            isAgentServiceRunning = true;
                            break;
                        }
                        case NOT_RUNNING: {
                            NacAgentCheck.log("Retry Launching Agent service : NACAgent");
                            isAgentServiceRunning = NacAgentCheck.retryLaunchingNacAgentService(NACAGENT_GENERIC_NAME);
                        }
                    }
                    if (!isAgentServiceRunning) {
                        NacAgentCheck.logAndSetStatus(AgentStatusEnum.COULD_NOT_START_SERVICE, "Service : NACAgent could not be started.");
                        return AgentStatusEnum.COULD_NOT_START_SERVICE;
                    }
                }
                if (isAgentRunning = NacAgentCheck.isAgentRunning(os, agentLocation)) {
                    NacAgentCheck.logAndSetStatus(AgentStatusEnum.RUNNING, "Is agent Running : " + isAgentRunning);
                    return AgentStatusEnum.RUNNING;
                }
                if (!isAgentRunning) {
                    NacAgentCheck.log("Agent is not running. Retry launching it...");
                    isAgentRunning = NacAgentCheck.retryLaunchingNacAgent(os, agentLocation);
                    if (isAgentRunning) {
                        NacAgentCheck.logAndSetStatus(AgentStatusEnum.LAUNCHED, "Agent is was launched successfully.");
                        return AgentStatusEnum.LAUNCHED;
                    }
                    NacAgentCheck.logAndSetStatus(AgentStatusEnum.LAUNCH_FAILED_RETRY_TIMEOUT, "Agent could not be launched successfully.");
                    return AgentStatusEnum.LAUNCH_FAILED_RETRY_TIMEOUT;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            NacAgentCheck.logAndSetStatus(AgentStatusEnum.NOT_INSTALLED, "Agent not installed.");
            return AgentStatusEnum.NOT_INSTALLED;
        }
        return AgentStatusEnum.UNKNOWN;
    }

    public void init() {
        NacAgentCheck.log("Initializing NACAgent Checker...");
    }

    public void destroy() {
        super.destroy();
        NacAgentCheck.log("Unload NACAgent Checker...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void start() {
        block11: {
            block8: {
                NacAgentCheck.log("Starting NACAgent check>>>> <<<");
                this.thread = new Thread(new Runnable(){

                    public void run() {
                        NacAgentCheck.this.start2();
                    }
                });
                this.thread.setName("NacAgentCheckThread");
                this.thread.start();
                JSObject window = null;
                try {
                    long startTime = System.currentTimeMillis();
                    window = JSObject.getWindow((Applet)this);
                    NacAgentCheck.log("Going to wait on NacAgentCheckThread thread to run to completion...");
                    this.thread.join();
                    NacAgentCheck.log("Finished waiting on NacAgentCheckThread.");
                    long endTime = System.currentTimeMillis();
                    NacAgentCheck.log("NacAgentCheckThread ran to completion. Time taken to check (in millisecs): " + (endTime - startTime));
                    if (null == window) break block8;
                }
                catch (InterruptedException ie) {
                    block9: {
                        ie.printStackTrace();
                        if (null == window) break block9;
                        window.call("updateNacAgentCheckerStatus", agentStatus);
                        NacAgentCheck.log("Setting Agent Check Status to " + agentStatus);
                    }
                    NacAgentCheck.log("Could not refer to the window object...");
                }
                catch (JSException jse) {
                    block10: {
                        jse.printStackTrace();
                        if (null == window) break block10;
                        {
                            catch (Throwable throwable) {
                                if (null != window) {
                                    window.call("updateNacAgentCheckerStatus", agentStatus);
                                    NacAgentCheck.log("Setting Agent Check Status to " + agentStatus);
                                } else {
                                    NacAgentCheck.log("Could not refer to the window object...");
                                }
                                throw throwable;
                            }
                        }
                        window.call("updateNacAgentCheckerStatus", agentStatus);
                        NacAgentCheck.log("Setting Agent Check Status to " + agentStatus);
                    }
                    NacAgentCheck.log("Could not refer to the window object...");
                }
                window.call("updateNacAgentCheckerStatus", agentStatus);
                NacAgentCheck.log("Setting Agent Check Status to " + agentStatus);
                break block11;
            }
            NacAgentCheck.log("Could not refer to the window object...");
        }
    }

    public void start2() {
        os = System.getProperty("os.name").toLowerCase();
        AgentStatusEnum agentStatus = AgentStatusEnum.NOT_INSTALLED;
        agentStatus = NacAgentCheck.getAgentStatus(os);
        NacAgentCheck.log("Agent status : " + NacAgentCheck.agentStatus);
    }

    public static void main(String[] args) {
        if (args != null) {
            NacAgentCheck.log(args.length + " : " + args[0]);
            String os = args[0];
            NacAgentCheck check = new NacAgentCheck();
            check.start();
            NacAgentCheck.log("Agent status : " + agentStatus);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AgentStatusEnum {
        UNKNOWN(0),
        NOT_INSTALLED(1),
        INSTALLED(2),
        RUNNING(3),
        COULD_NOT_START_SERVICE(4),
        LAUNCH_FAILED_RETRY_TIMEOUT(5),
        LAUNCHED(6);

        private final int agentState;

        private AgentStatusEnum(int tmpAgentState) {
            this.agentState = tmpAgentState;
        }

        public int agentState() {
            return this.agentState;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AgentServiceStatusEnum {
        NOT_STARTED,
        STARTING,
        STARTED,
        RUNNING,
        NOT_RUNNING,
        STOPPING,
        STOPPED,
        ACCESS_DENIED;

    }
}

