/*
 * Decompiled with CFR 0.152.
 */
package VPNJava;

import VPNJava.LogInterface;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class TLV {
    private LogInterface mLogger = null;
    private List mTlvList = new LinkedList();
    private static final int TLV_BASIC_SIZE = 2;

    public void setLogger(LogInterface logInterface) {
        this.mLogger = logInterface;
    }

    public void setLogger() {
    }

    public void log(String string) {
        if (this.mLogger != null) {
            this.mLogger.log(string);
        }
    }

    public void debuglog(String string) {
        if (this.mLogger != null) {
            this.mLogger.debuglog(string);
        }
    }

    public String toString() {
        String string = "TLV [\n";
        for (int i = 0; i < this.mTlvList.size(); ++i) {
            SingleTLV singleTLV = (SingleTLV)this.mTlvList.get(i);
            string = string + "\t" + singleTLV;
        }
        string = string + "]";
        return string;
    }

    public boolean IsBasicValue(TlvHandle tlvHandle) throws IndexOutOfBoundsException {
        SingleTLV singleTLV = null;
        singleTLV = (SingleTLV)this.mTlvList.get(tlvHandle.mTlvHandle);
        return singleTLV.IsBasicValue();
    }

    public void GetAttribute(TlvHandle tlvHandle, BasicTLV basicTLV) throws IndexOutOfBoundsException, IllegalArgumentException {
        SingleTLV singleTLV = null;
        singleTLV = (SingleTLV)this.mTlvList.get(tlvHandle.mTlvHandle);
        singleTLV.GetAttribute(basicTLV);
    }

    public void GetAttribute(TlvHandle tlvHandle, NonBasicTLV nonBasicTLV) throws IndexOutOfBoundsException, IllegalArgumentException {
        SingleTLV singleTLV = null;
        singleTLV = (SingleTLV)this.mTlvList.get(tlvHandle.mTlvHandle);
        singleTLV.GetAttribute(nonBasicTLV);
    }

    public void AddAttribute(BasicTLV basicTLV) throws IllegalArgumentException {
        if (null == basicTLV) {
            throw new IllegalArgumentException("BasicTLV must not be null");
        }
        SingleTLV singleTLV = new SingleTLV();
        singleTLV.SetAttribute(basicTLV);
        this.mTlvList.add(singleTLV);
    }

    public void AddAttribute(NonBasicTLV nonBasicTLV) throws IllegalArgumentException {
        if (null == nonBasicTLV) {
            throw new IllegalArgumentException("NonBasicTLV must not be null");
        }
        SingleTLV singleTLV = new SingleTLV();
        singleTLV.SetAttribute(nonBasicTLV);
        this.mTlvList.add(singleTLV);
    }

    public void NextTlv(TlvHandle tlvHandle) throws IndexOutOfBoundsException {
        int n = this.mTlvList.size();
        if (n > tlvHandle.mTlvHandle + 1) {
            ++tlvHandle.mTlvHandle;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    public boolean HasNextTlv(TlvHandle tlvHandle) {
        return this.mTlvList.size() > tlvHandle.mTlvHandle + 1;
    }

    public byte[] GetTlv() {
        int n = this.GetSize();
        if (0 == n) {
            return null;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (SingleTLV singleTLV : this.mTlvList) {
            byte[] byArray2 = singleTLV.GetBuffer();
            if (null != byArray2) {
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                n2 += byArray2.length;
                continue;
            }
            this.log("GetTlv singleTlv.GetBuffer return null");
        }
        return byArray;
    }

    public void SetTlv(byte[] byArray) throws IllegalArgumentException {
        this.SetTlv(byArray, 0L);
    }

    public void SetTlv(byte[] byArray, long l) throws IllegalArgumentException {
        if (null == byArray) {
            throw new IllegalArgumentException("Must not pass byte[] equal to null");
        }
        this.mTlvList.clear();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        while (l < (long)byArray.length) {
            SingleTLV singleTLV = new SingleTLV();
            byte[] byArray2 = new byte[(int)((long)byArray.length - l)];
            byteBuffer.position((int)l);
            byteBuffer.get(byArray2, 0, byArray2.length);
            singleTLV.SetBuffer(byArray2);
            this.mTlvList.add(singleTLV);
            l += (long)singleTLV.GetSize();
        }
    }

    public byte[] GetInfoByType(short s) {
        for (SingleTLV singleTLV : this.mTlvList) {
            if (singleTLV.GetType() != s) continue;
            if (singleTLV.IsBasicValue()) {
                BasicTLV basicTLV = new BasicTLV();
                singleTLV.GetAttribute(basicTLV);
                byte[] byArray = new byte[2];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                byteBuffer.putShort(basicTLV.mValue);
                return byArray;
            }
            NonBasicTLV nonBasicTLV = new NonBasicTLV();
            singleTLV.GetAttribute(nonBasicTLV);
            return nonBasicTLV.mValueBytes;
        }
        return null;
    }

    private int GetSize() {
        int n = 0;
        for (SingleTLV singleTLV : this.mTlvList) {
            n += singleTLV.GetSize();
        }
        return n;
    }

    private class SingleTLV {
        private boolean mIsBasicTlv = true;
        private short mType = 0;
        private short mBasicValue = 0;
        private byte[] mValueBytes = null;
        private static final short TLV_ATTRIBUTE_FORMAT_BIT = Short.MIN_VALUE;

        private SingleTLV() {
        }

        public String toString() {
            String string = null;
            string = this.mIsBasicTlv ? "Type[" + this.mType + "] Value[" + this.mBasicValue + "]" : "Type[" + this.mType + "] Length[" + this.mValueBytes.length + "Value[" + new String(this.mValueBytes) + "]";
            return string;
        }

        public boolean IsBasicValue() {
            return this.mIsBasicTlv;
        }

        public void SetAttribute(BasicTLV basicTLV) throws IllegalArgumentException {
            if (null == basicTLV) {
                throw new IllegalArgumentException("BasicTLV must not be null");
            }
            if (Short.MIN_VALUE == (basicTLV.mType & Short.MIN_VALUE)) {
                throw new IllegalArgumentException("TLV format bit set");
            }
            this.Clear();
            this.mIsBasicTlv = true;
            this.mType = basicTLV.mType;
            this.mBasicValue = basicTLV.mValue;
        }

        public void SetAttribute(NonBasicTLV nonBasicTLV) throws IllegalArgumentException {
            if (null == nonBasicTLV) {
                throw new IllegalArgumentException("NonBasicTLV must not be null");
            }
            if (Short.MIN_VALUE == (nonBasicTLV.mType & Short.MIN_VALUE)) {
                throw new IllegalArgumentException("TLV format bit set");
            }
            this.Clear();
            this.mIsBasicTlv = false;
            this.mType = nonBasicTLV.mType;
            this.mValueBytes = new byte[nonBasicTLV.mValueBytes.length];
            System.arraycopy(nonBasicTLV.mValueBytes, 0, this.mValueBytes, 0, nonBasicTLV.mValueBytes.length);
        }

        public void GetAttribute(BasicTLV basicTLV) throws IllegalArgumentException {
            if (null == basicTLV) {
                throw new IllegalArgumentException("BasicTLV can not be null");
            }
            if (!this.mIsBasicTlv) {
                throw new IllegalArgumentException("Not a basic TLV field");
            }
            basicTLV.mType = this.mType;
            basicTLV.mValue = this.mBasicValue;
        }

        public void GetAttribute(NonBasicTLV nonBasicTLV) throws IllegalArgumentException {
            if (null == nonBasicTLV) {
                throw new IllegalArgumentException("NonBasicTLV can not be null");
            }
            if (this.mIsBasicTlv) {
                throw new IllegalArgumentException("A basic TLV field");
            }
            nonBasicTLV.mType = this.mType;
            nonBasicTLV.mValueBytes = new byte[this.mValueBytes.length];
            System.arraycopy(this.mValueBytes, 0, nonBasicTLV.mValueBytes, 0, this.mValueBytes.length);
        }

        public byte[] GetBuffer() {
            byte[] byArray = new byte[this.GetSize()];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            if (this.mIsBasicTlv) {
                byteBuffer.putShort((short)(this.mType | Short.MIN_VALUE));
                byteBuffer.putShort(this.mBasicValue);
            } else {
                byteBuffer.putShort(this.mType);
                byteBuffer.putShort((short)this.mValueBytes.length);
                byteBuffer.put(this.mValueBytes);
            }
            return byArray;
        }

        public void SetBuffer(byte[] byArray) throws IllegalArgumentException {
            if (null == byArray) {
                throw new IllegalArgumentException("byte[] must not be null");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            try {
                short s = byteBuffer.getShort();
                boolean bl = this.mIsBasicTlv = Short.MIN_VALUE == (s & Short.MIN_VALUE);
                if (this.mIsBasicTlv) {
                    this.mType = (short)(s & Short.MAX_VALUE);
                    this.mBasicValue = byteBuffer.getShort();
                } else {
                    this.mType = s;
                    short s2 = byteBuffer.getShort();
                    if (s2 < 0) {
                        throw new IllegalArgumentException("byte[] does not contains a valid TLV stream");
                    }
                    this.mValueBytes = new byte[s2];
                    byteBuffer.get(this.mValueBytes);
                }
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                throw new IllegalArgumentException("byte[] does not contains a valid TLV stream");
            }
        }

        public short GetType() {
            return this.mType;
        }

        private void Clear() {
            this.mIsBasicTlv = true;
            this.mType = 0;
            this.mBasicValue = 0;
            this.mValueBytes = null;
        }

        private int GetSize() {
            if (this.mIsBasicTlv) {
                return 4;
            }
            return 4 + this.mValueBytes.length;
        }
    }

    public static class TlvHandle {
        public int mTlvHandle = 0;
    }

    public static class NonBasicTLV {
        public short mType;
        public byte[] mValueBytes;

        public NonBasicTLV(short s, byte[] byArray) {
            this.mType = s;
            this.mValueBytes = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.mValueBytes, 0, byArray.length);
        }

        public NonBasicTLV() {
            this.mType = 0;
            this.mValueBytes = null;
        }
    }

    public static class BasicTLV {
        public short mType;
        public short mValue;

        public BasicTLV(short s, short s2) {
            this.mType = s;
            this.mValue = s2;
        }

        public BasicTLV() {
            this.mType = 0;
            this.mValue = 0;
        }
    }
}

