/*
 * Decompiled with CFR 0.152.
 */
package VPNJava;

import VPNJava.CodeSignException;
import VPNJava.LogInterface;
import VPNJava.TLV;
import java.io.File;

public class CodeSignTlv {
    private static final short TYPE_INVALID = 0;
    private static final short TYPE_COOKIE = 1;
    private static final short TYPE_CERTIFICATE = 2;
    private static final short TYPE_IM_CERTIFICATE = 3;
    private static final short TYPE_DATE = 4;
    private static final short TYPE_SIGNATURE = 5;
    private static final short TYPE_SIGNATURE_VPNDOWNLOADER_BIN = 100;
    private static final short TYPE_SIGNATURE_VPNDOWNLOADER_SH = 101;
    private static final short TYPE_VPNAGENT = 102;
    private static final short TYPE_SIGNATURE_VPN = 103;
    private static final short TYPE_SIGNATURE_VPNUI = 104;
    private static final short TYPE_SIGNATURE_VPNDOWNLOADER_BIN_NOGUI = 105;
    private static final short TYPE_SIGNATURE_UNINSTALL = 106;
    private static final short TYPE_SIGNATURE_IPSEC_LIB = 107;
    private static final short TYPE_SIGNATURE_VPNSETUP = 108;
    private static final short TYPE_SIGNATURE_DARTSETUP = 109;
    private static final short TYPE_SIGNATURE_POSTURESETUP = 110;
    private static final short TYPE_SIGNATURE_INSTALLDMG = 111;
    private static final short TYPE_SIGNATURE_NATIVE_ARCHIVE = 112;
    private static final String COOKIE = "S!cV!j!dqeayIVDMPT!A!kfkjvddSBJJJ!V!eznRGBF";
    private static final String STR_VPNDOWNLOADER_SH = "vpndownloader.sh";
    private static final String STR_VPNDOWNLOADER_BIN = "vpndownloader";
    private static final String STR_NATIVE_ARCHIVE = "anyconnect_native_component.zip";
    private static final String STR_SIGNATURE_VPN = "vpn";
    private static final String STR_SIGNATURE_VPNUI1 = "vpnui";
    private static final String STR_SIGNATURE_VPNUI2 = "Cisco AnyConnect VPN Client";
    private static final String STR_SIGNATURE_UNINSTALL = "Uninstall AnyConnect";
    private static final String STR_SIGNATURE_IPSEC_LIB = "libvpnipsec.so";
    private static final String STR_SIGNATURE_VPNSETUP = "vpnsetup.sh";
    private static final String STR_SIGNATURE_DARTSETUP = "dartsetup.sh";
    private static final String STR_SIGNATURE_POSTURESETUP = "posturesetup.sh";
    private static final String STR_SIGNATURE_INSTALLDMG = "install-dmg.sh";
    private static final String STR_SIGNATURE_NATIVE_ARCHIVE = "anyconnect_native_component.zip";
    private TLV m_Tlv = new TLV();

    public CodeSignTlv(LogInterface logInterface) {
        this.m_Tlv.setLogger(logInterface);
    }

    public byte[] GetCodeSignTlv() {
        return this.m_Tlv.GetTlv();
    }

    public void SetCodeSignTlv(byte[] byArray) {
        this.m_Tlv.SetTlv(byArray);
    }

    public void SetCodeSignTlv(byte[] byArray, long l) {
        this.m_Tlv.SetTlv(byArray, l);
    }

    public boolean IsValid() {
        byte[] byArray = this.m_Tlv.GetInfoByType((short)1);
        if (null == byArray) {
            return false;
        }
        String string = new String(byArray);
        return 0 == string.compareTo(COOKIE);
    }

    public byte[] GetCert() {
        return this.m_Tlv.GetInfoByType((short)2);
    }

    public void SetCert(byte[] byArray) throws IllegalArgumentException {
        if (null == byArray) {
            throw new IllegalArgumentException("CodeSignTlv.SetCert - certBytes must not be null");
        }
        TLV.NonBasicTLV nonBasicTLV = new TLV.NonBasicTLV();
        nonBasicTLV.mType = (short)2;
        nonBasicTLV.mValueBytes = byArray;
        this.m_Tlv.AddAttribute(nonBasicTLV);
    }

    public byte[] GetImCert() {
        return this.m_Tlv.GetInfoByType((short)3);
    }

    public void AddImCert(byte[] byArray) throws IllegalArgumentException {
        if (null == byArray) {
            throw new IllegalArgumentException("CodeSignTlv.AddImCert - certBytes must not be null");
        }
        TLV.NonBasicTLV nonBasicTLV = new TLV.NonBasicTLV();
        nonBasicTLV.mType = (short)3;
        nonBasicTLV.mValueBytes = byArray;
        this.m_Tlv.AddAttribute(nonBasicTLV);
    }

    public byte[] GetSignature(String string) {
        this.m_Tlv.log("Getting signature in file " + string);
        byte[] byArray = this.GetSignature();
        if (byArray == null) {
            short s = this.GetTlvFileTypeFromFile(string);
            this.m_Tlv.log("File type is " + s);
            byArray = this.m_Tlv.GetInfoByType(s);
            if (byArray == null) {
                this.m_Tlv.log("Legacy signature not found!");
            }
        }
        return byArray;
    }

    public byte[] GetSignature() {
        byte[] byArray = null;
        byArray = this.m_Tlv.GetInfoByType((short)5);
        if (byArray == null) {
            this.m_Tlv.log("Signature not found");
        }
        return byArray;
    }

    public byte[] GetSignatureForFileType(short s) {
        byte[] byArray = null;
        if (s == 0) {
            return null;
        }
        byArray = this.m_Tlv.GetInfoByType(s);
        return byArray;
    }

    public void SetSignature(String string, byte[] byArray) throws IllegalArgumentException, CodeSignException {
        if (null == string) {
            throw new IllegalArgumentException("filePath must not be null");
        }
        if (null == byArray) {
            throw new IllegalArgumentException("Signature buffer must not be null");
        }
        TLV.NonBasicTLV nonBasicTLV = new TLV.NonBasicTLV();
        nonBasicTLV.mType = (short)5;
        nonBasicTLV.mValueBytes = byArray;
        this.m_Tlv.AddAttribute(nonBasicTLV);
        short s = this.GetTlvFileTypeFromFile(string);
        if (0 != s) {
            nonBasicTLV.mType = s;
            this.m_Tlv.AddAttribute(nonBasicTLV);
        }
    }

    public void AddCookie() {
        TLV.NonBasicTLV nonBasicTLV = new TLV.NonBasicTLV();
        nonBasicTLV.mType = 1;
        nonBasicTLV.mValueBytes = COOKIE.getBytes();
        this.m_Tlv.AddAttribute(nonBasicTLV);
    }

    public short GetTlvFileTypeFromFile(String string) throws IllegalArgumentException {
        if (null == string) {
            throw new IllegalArgumentException("File parameter can not be null");
        }
        String string2 = string;
        int n = 0;
        if (string2.lastIndexOf(File.separatorChar) >= 0) {
            string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1);
        }
        this.m_Tlv.log("Finding legacy signature for file " + string2);
        if (0 == string2.compareTo(STR_VPNDOWNLOADER_SH)) {
            n = 101;
        } else if (0 == string2.compareTo(STR_VPNDOWNLOADER_BIN)) {
            n = 100;
        } else if (0 == string2.compareTo("anyconnect_native_component.zip")) {
            n = 112;
        } else if (0 == string2.compareTo(STR_SIGNATURE_VPN)) {
            n = 112;
        } else if (0 == string2.compareTo(STR_SIGNATURE_VPNUI1)) {
            n = 104;
        } else if (0 == string2.compareTo(STR_SIGNATURE_VPNUI2)) {
            n = 104;
        } else if (0 == string2.compareTo(STR_SIGNATURE_UNINSTALL)) {
            n = 106;
        } else if (0 == string2.compareTo(STR_SIGNATURE_IPSEC_LIB)) {
            n = 107;
        } else if (0 == string2.compareTo(STR_SIGNATURE_VPNSETUP)) {
            n = 108;
        } else if (0 == string2.compareTo(STR_SIGNATURE_DARTSETUP)) {
            n = 109;
        } else if (0 == string2.compareTo(STR_SIGNATURE_POSTURESETUP)) {
            n = 112;
        } else if (0 == string2.compareTo(STR_SIGNATURE_INSTALLDMG)) {
            n = 111;
        } else if (0 == string2.compareTo("anyconnect_native_component.zip")) {
            n = 112;
        } else {
            this.m_Tlv.log("GetTlvFileTypeFromFile could not find legacy file type");
            n = 0;
        }
        return (short)n;
    }
}

