/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import com.cisco.secinspv2tov4migration.Data;
import com.cisco.secinspv2tov4migration.OESISSupportV2toV4;

public class V4ConfigurationData {
    private Data amData = null;
    private Data v4pfData = null;
    private int v4_prd_type;

    private V4ConfigurationData() {
    }

    public V4ConfigurationData(String string, String string2, int n) {
        this.amData = new Data(string2);
        this.v4pfData = new Data(string2);
        this.v4_prd_type = n;
        this.load(string, string2);
    }

    public String toString() {
        String string = "";
        if (OESISSupportV2toV4.V4_AM_TYPE == this.v4_prd_type) {
            string = this.amData.toString();
        } else if (OESISSupportV2toV4.V4_FW_TYPE == this.v4_prd_type) {
            string = this.v4pfData.toString();
        }
        return string;
    }

    public String get(String string) {
        String string2 = null;
        if (OESISSupportV2toV4.V4_AM_TYPE == this.v4_prd_type) {
            string2 = this.amData.get(string);
        } else if (OESISSupportV2toV4.V4_FW_TYPE == this.v4_prd_type) {
            string2 = this.v4pfData.get(string);
        }
        return string2;
    }

    public boolean check(String string) {
        boolean bl = false;
        if (OESISSupportV2toV4.V4_AM_TYPE == this.v4_prd_type) {
            bl = this.amData.check(string);
        } else if (OESISSupportV2toV4.V4_FW_TYPE == this.v4_prd_type) {
            bl = this.v4pfData.check(string);
        }
        return bl;
    }

    public boolean merge(Data data) {
        boolean bl = true;
        if (OESISSupportV2toV4.V4_AM_TYPE == this.v4_prd_type) {
            this.mergeAMData(data);
        } else if (OESISSupportV2toV4.V4_FW_TYPE == this.v4_prd_type) {
            this.mergeV4FirewallData(data);
        } else {
            System.out.println("Error!!! V4ConfigurationData.merge operation for productType(" + this.v4_prd_type + ") " + "is not allowed or supported");
            bl = false;
        }
        return bl;
    }

    private void load(String string, String string2) {
        Data data = new Data(string, string2);
        if (OESISSupportV2toV4.V4_AM_TYPE == this.v4_prd_type) {
            this.loadAMData(data);
        } else if (OESISSupportV2toV4.V4_FW_TYPE == this.v4_prd_type) {
            this.loadV4FirewallData(data);
        } else {
            System.out.println("Error!!! V4ConfigurationData.load operation for productType(" + this.v4_prd_type + ") " + "is not allowed or supported");
        }
    }

    private void loadAMData(Data data) {
        int n = V4ConfigurationData.loadDataIntoTarget(data, this.v4_prd_type, this.amData);
        if (n > 0) {
            this.amData.set("am_fsprotect", data.check("am_fsprotect"));
            this.amData.set("am_defupdate", data.check("am_defupdate"));
            if (null != data.get("am_defupdate_days")) {
                this.amData.put("am_defupdate_days", data.get("am_defupdate_days"));
            }
        }
    }

    private void loadV4FirewallData(Data data) {
        int n = V4ConfigurationData.loadDataIntoTarget(data, this.v4_prd_type, this.v4pfData);
        if (n > 0 && null != data.get("pfw_action")) {
            this.v4pfData.put("pfw_action", data.get("pfw_action"));
        }
    }

    private static int loadDataIntoTarget(Data data, int n, Data data2) {
        int n2 = data.getProductCount(n);
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            String string = data.get(Data.makeAttributeName(n, "vendor", i));
            String string2 = data.get(Data.makeAttributeName(n, "product", i));
            if (null == string || null == string2 || string.length() <= 0 || string2.length() <= 0) continue;
            if (0 == n3) {
                data2.set(Data.makeEnforceAttributeName(n), n2 > 0);
                data2.put(Data.makeCountAttributeName(n), "" + n2);
            }
            data2.put(Data.makeAttributeName(n, "vendor", i), string);
            data2.put(Data.makeAttributeName(n, "product", i), string2);
            ++n3;
        }
        if (n3 > 0) {
            data2.set(Data.makeEnforceAttributeName(n), n3 > 0);
            data2.put(Data.makeCountAttributeName(n), "" + n3);
        }
        return n3;
    }

    private static int mergeDataIntoTarget(Data data, int n, Data data2) {
        int n2;
        int n3 = data.getProductCount(n);
        if (n3 == 0) {
            return 0;
        }
        int n4 = data2.getProductCount(n);
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            String string = data.get(Data.makeAttributeName(n, "vendor", n2));
            String string2 = data.get(Data.makeAttributeName(n, "product", n2));
            if (null == string || null == string2 || string.length() <= 0 || string2.length() <= 0) continue;
            if (0 == n5 && 0 == n4) {
                data2.set(Data.makeEnforceAttributeName(n), n3 > 0);
                data2.put(Data.makeCountAttributeName(n), "" + n3);
            }
            data2.put(Data.makeAttributeName(n, "vendor", n4 + n2), string);
            data2.put(Data.makeAttributeName(n, "product", n4 + n2), string2);
            ++n5;
        }
        if (n5 > 0) {
            n2 = n5 + n4;
            data2.set(Data.makeEnforceAttributeName(n), n2 > 0);
            data2.put(Data.makeCountAttributeName(n), "" + n2);
        }
        return n5;
    }

    private void mergeAMData(Data data) {
        boolean bl = this.amData.check("am_fsprotect");
        boolean bl2 = this.amData.check("am_defupdate");
        String string = this.amData.get("am_defupdate_days");
        int n = V4ConfigurationData.mergeDataIntoTarget(data, this.v4_prd_type, this.amData);
        if (n > 0) {
            int n2;
            int n3;
            if (data.check("am_fsprotect") && !bl) {
                this.amData.set("am_fsprotect", data.check("am_fsprotect"));
            }
            if (data.check("am_defupdate") && !bl2) {
                this.amData.set("am_defupdate", data.check("am_defupdate"));
            }
            if ((n3 = Data.ConvertToInt(data.get("am_defupdate_days"))) > 0 && (n3 < (n2 = Data.ConvertToInt(string)) || n2 <= 0)) {
                this.amData.put("am_defupdate_days", data.get("am_defupdate_days"));
            }
        }
    }

    private void mergeV4FirewallData(Data data) {
        String string = this.v4pfData.get("pfw_action");
        int n = V4ConfigurationData.mergeDataIntoTarget(data, this.v4_prd_type, this.v4pfData);
        if (n > 0 && null != data.get("pfw_action") && null == string) {
            this.v4pfData.put("pfw_action", data.get("pfw_action"));
        }
    }
}

