/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import com.cisco.secinspv2tov4migration.Data;
import com.cisco.secinspv2tov4migration.FixedTableModel;
import com.cisco.secinspv2tov4migration.OESISSupportV2toV4;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class V2ToV4MappedProductTable
extends JTable {
    private OESISSupportV2toV4 support;
    private int updatedef_count = 0;
    private int activeprotect_count = 0;
    private int firewall_enable_count = 0;
    private int firewall_disable_count = 0;
    Vector mappedItems = new Vector();
    private int type;
    private JButton deleteButton;

    private V2ToV4MappedProductTable(int n, OESISSupportV2toV4 oESISSupportV2toV4, int n2) {
        this.type = n;
        this.support = oESISSupportV2toV4;
        this.updatedef_count = 0;
        this.activeprotect_count = 0;
        this.firewall_enable_count = 0;
        this.firewall_disable_count = 0;
        this.setRowSelectionAllowed(true);
        this.getSelectionModel().setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        FixedTableModel fixedTableModel = new FixedTableModel(0, 6, new String[]{"<html><center>Legacy HS</center>Product ID</html>", "<html><center>Legacy HS</center>Product Name</html>", "<html><center>Legacy HS</center>Version</html>", "<html><center>New HS</center>Vendor</html>", "<html><center>New HS</center>Product Name</html>", "<html><center>Mapped</center>New HS Version</html>"});
        this.setModel(fixedTableModel);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setBackground(new Color(0, 0, 182, 155));
        defaultTableCellRenderer.setForeground(Color.WHITE);
        defaultTableCellRenderer.setHorizontalAlignment(0);
        Font font = defaultTableCellRenderer.getFont();
        font = font.deriveFont(font.getStyle() | 1);
        defaultTableCellRenderer.setFont(font);
        this.getTableHeader().getColumnModel().getColumn(0).setHeaderRenderer(defaultTableCellRenderer);
        this.getTableHeader().getColumnModel().getColumn(1).setHeaderRenderer(defaultTableCellRenderer);
        this.getTableHeader().getColumnModel().getColumn(2).setHeaderRenderer(defaultTableCellRenderer);
        this.getTableHeader().getColumnModel().getColumn(3).setHeaderRenderer(defaultTableCellRenderer);
        this.getTableHeader().getColumnModel().getColumn(4).setHeaderRenderer(defaultTableCellRenderer);
        this.getTableHeader().getColumnModel().getColumn(5).setHeaderRenderer(defaultTableCellRenderer);
        this.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.getColumnModel().getColumn(4).setPreferredWidth(200);
        this.getColumnModel().getColumn(5).setPreferredWidth(100);
        DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer(){

            public String getToolTipText() {
                String string = this.getText();
                if (string != null && string.length() > 0) {
                    return string;
                }
                return null;
            }
        };
        this.setDefaultRenderer(Object.class, defaultTableCellRenderer2);
    }

    V2ToV4MappedProductTable(int n, OESISSupportV2toV4 oESISSupportV2toV4) {
        this(n, oESISSupportV2toV4, 6);
    }

    JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.createButtons();
        }
        return this.deleteButton;
    }

    public void addMappedItems(Vector vector) {
        this.populateView(vector);
    }

    public int getNumberOfAMProductSupportActiveProtection() {
        return this.activeprotect_count;
    }

    public int getNumberOfAMProductSupportUpdateDefinition() {
        return this.updatedef_count;
    }

    public int getNumberOfFWProductSupportEnable() {
        return this.firewall_enable_count;
    }

    public int getNumberOfFWProductSupportDisable() {
        return this.firewall_disable_count;
    }

    public int getRowCount() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        return defaultTableModel.getRowCount();
    }

    void populateView(Vector vector) {
        int n = this.mappedItems.size();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        for (int i = 0; i < vector.size(); ++i) {
            OESISSupportV2toV4.MappingProduct mappingProduct = (OESISSupportV2toV4.MappingProduct)vector.get(i);
            this.mappedItems.add(mappingProduct);
            Object[] objectArray = new String[6];
            objectArray[0] = mappingProduct.getV2OSPWATProductID();
            objectArray[1] = mappingProduct.getV2Name();
            objectArray[2] = "";
            String[] stringArray = this.support.splitSubProductID(mappingProduct.getV2ID());
            if (null != stringArray) {
                objectArray[1] = stringArray[0];
                objectArray[2] = stringArray[1];
            }
            objectArray[3] = mappingProduct.getV4Vendor();
            objectArray[4] = mappingProduct.getV4Name();
            objectArray[5] = "";
            String string = "";
            String string2 = mappingProduct.getV4Name();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            objectArray[5] = string;
            string2 = string2.substring(0, string2.indexOf(string));
            objectArray[4] = string2.trim();
            OESISSupportV2toV4.Product[] productArray = this.support.getSubProducts(this.type, mappingProduct.getV4OSPWATProductID(), mappingProduct.getV4Vendor());
            if (null != productArray && productArray.length > 0) {
                for (int j = 0; j < productArray.length; ++j) {
                    String[] stringArray2 = this.support.splitSubProductID(productArray[j].getID());
                    if (null == stringArray2 || !((String)objectArray[4]).equals(stringArray2[0]) || !((String)objectArray[5]).equals(stringArray2[1])) continue;
                    if (productArray[j].canFeature(OESISSupportV2toV4._ActiveProtect)) {
                        ++this.activeprotect_count;
                    }
                    if (productArray[j].canFeature(OESISSupportV2toV4._UpdateDefs)) {
                        ++this.updatedef_count;
                    }
                    if (productArray[j].canFeature(OESISSupportV2toV4._FirewallOn)) {
                        ++this.firewall_enable_count;
                    }
                    if (!productArray[j].canFeature(OESISSupportV2toV4._FirewallOff)) break;
                    ++this.firewall_disable_count;
                    break;
                }
            }
            defaultTableModel.addRow(objectArray);
        }
    }

    void populateModel(Data data) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        int n = defaultTableModel.getRowCount();
        data.set(Data.makeEnforceAttributeName(this.type), n > 0);
        data.put(Data.makeCountAttributeName(this.type), "" + n);
        for (int i = 0; i < n; ++i) {
            OESISSupportV2toV4.MappingProduct mappingProduct = (OESISSupportV2toV4.MappingProduct)this.mappedItems.get(i);
            String string = mappingProduct.getV4OSPWATProductID();
            String string2 = (String)defaultTableModel.getValueAt(i, 4);
            String string3 = (String)defaultTableModel.getValueAt(i, 5);
            String string4 = this.support.composeSubProductID(string2, string3);
            data.put(Data.makeAttributeName(this.type, "vendor", i), string);
            data.put(Data.makeAttributeName(this.type, "product", i), string4);
        }
    }

    private void createButtons() {
        final AbstractAction abstractAction = new AbstractAction("Delete"){
            {
                this.enabled = false;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                V2ToV4MappedProductTable.this.deleteProducts();
            }
        };
        this.deleteButton = new JButton(abstractAction);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                abstractAction.setEnabled(!V2ToV4MappedProductTable.this.getSelectionModel().isSelectionEmpty());
            }
        });
    }

    private void deleteProducts() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            defaultTableModel.removeRow(i);
            this.mappedItems.remove(i);
        }
    }
}

