/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import com.cisco.secinspv2tov4migration.OESISSupportV2toV4;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class V2ProductTableModel
extends DefaultTableModel {
    private String[] columnNames;
    private Vector v2Products = new Vector();
    private OESISSupportV2toV4 support;

    private V2ProductTableModel() {
    }

    public V2ProductTableModel(OESISSupportV2toV4 oESISSupportV2toV4, int n, int n2, String[] stringArray) {
        super(n, n2);
        this.support = oESISSupportV2toV4;
        this.columnNames = stringArray;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getRowCount() {
        if (null != this.v2Products) {
            return this.v2Products.size();
        }
        return 0;
    }

    public void removeRow(int n) {
        this.v2Products.removeElementAt(n);
        this.fireTableRowsDeleted(n, n);
    }

    public Object getValueAt(int n, int n2) {
        String[] stringArray;
        String string = null;
        OESISSupportV2toV4.Product product = (OESISSupportV2toV4.Product)this.v2Products.get(n);
        if (null == product) {
            return string;
        }
        String string2 = "";
        String string3 = "";
        if (null != product && null != (stringArray = this.support.splitSubProductID(product.getID()))) {
            string2 = stringArray[0];
            string3 = stringArray[1];
        }
        switch (n2) {
            case 0: {
                string = product.getOSPWATProductID();
                break;
            }
            case 1: {
                string = string2;
                break;
            }
            case 2: {
                string = string3;
            }
        }
        return string;
    }

    public boolean itemExists(String string, int n) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            try {
                if (string.compareTo(this.getValueAt(i, n).toString()) != 0) continue;
                return true;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    public void addProduct(OESISSupportV2toV4.Product product) {
        this.v2Products.add(product);
        this.fireTableRowsInserted(this.v2Products.size() - 1, this.v2Products.size() - 1);
    }

    public OESISSupportV2toV4.Product getProduct(int n) {
        OESISSupportV2toV4.Product product = null;
        if (n < this.getRowCount()) {
            product = (OESISSupportV2toV4.Product)this.v2Products.get(n);
        }
        return product;
    }

    public Vector getProductsOfType(int n) {
        Vector<OESISSupportV2toV4.Product> vector = new Vector<OESISSupportV2toV4.Product>();
        for (int i = 0; i < this.v2Products.size(); ++i) {
            OESISSupportV2toV4.Product product = (OESISSupportV2toV4.Product)this.v2Products.get(i);
            if (null == product || n != product.getProductType() || product.getName().length() <= 0 || product.getOSPWATProductID().length() <= 0) continue;
            vector.add(product);
        }
        return vector;
    }
}

