/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import com.cisco.secinspv2tov4migration.Data;
import com.cisco.secinspv2tov4migration.OESISSupportV2toV4;
import com.cisco.secinspv2tov4migration.V2ProductSelectionNotifier;
import com.cisco.secinspv2tov4migration.V2ProductTableModel;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public abstract class V2ProductTable
extends JTable {
    private int initialTotalCount;
    private OESISSupportV2toV4 support;
    private V2ProductSelectionNotifier selectionNotifier;
    private int type;
    private int manuallyDeletedCount;
    V2ProductTableModel v2ProductTabModel;
    private JButton deleteButton;
    private JButton selectiveMapButton;
    private JButton allAtOnceMapButton;

    private V2ProductTable(int n, OESISSupportV2toV4 oESISSupportV2toV4, int n2) {
        this.type = n;
        this.support = oESISSupportV2toV4;
        this.initialTotalCount = 0;
        this.manuallyDeletedCount = 0;
        this.setRowSelectionAllowed(true);
        this.getSelectionModel().setSelectionMode(2);
        this.getTableHeader().setReorderingAllowed(false);
        this.v2ProductTabModel = new V2ProductTableModel(oESISSupportV2toV4, 0, 3, new String[]{"Product ID", "Product Name", "Version"});
        this.setModel(this.v2ProductTabModel);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public String getToolTipText() {
                String string = this.getText();
                if (string != null && string.length() > 0) {
                    return string;
                }
                return null;
            }
        };
        this.setDefaultRenderer(Object.class, defaultTableCellRenderer);
    }

    V2ProductTable(int n, OESISSupportV2toV4 oESISSupportV2toV4, V2ProductSelectionNotifier v2ProductSelectionNotifier) {
        this(n, oESISSupportV2toV4, 3);
        this.selectionNotifier = v2ProductSelectionNotifier;
    }

    protected int getProductType() {
        return this.type;
    }

    JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.createButtons();
        }
        return this.deleteButton;
    }

    JButton getSelectiveMapButton() {
        if (this.selectiveMapButton == null) {
            this.createButtons();
        }
        return this.selectiveMapButton;
    }

    JButton getAllAtOnceMapButton() {
        if (this.allAtOnceMapButton == null) {
            this.createButtons();
        }
        this.adjustAllAtOnceMapButton();
        return this.allAtOnceMapButton;
    }

    protected void adjustAllAtOnceMapButton() {
        if (null != this.allAtOnceMapButton) {
            if (this.v2ProductTabModel.getRowCount() > 0) {
                this.allAtOnceMapButton.setEnabled(true);
            } else {
                this.allAtOnceMapButton.setEnabled(false);
            }
        }
    }

    public int getInitialTotalCount() {
        return this.initialTotalCount;
    }

    public abstract void populateView(Data var1);

    protected void populateViewBySpecificProductType(int n, Data data) {
        int n2 = data.getProductCount(n);
        this.initialTotalCount += n2;
        if (n2 == 0) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            String string;
            String string2 = string = data.get(Data.makeAttributeName(n, "product", i));
            String string3 = data.get(Data.makeAttributeName(n, "vendor", i));
            OESISSupportV2toV4.Product product = this.support.createV2Product(string2, string, string3, string3, n);
            this.v2ProductTabModel.addProduct(product);
        }
        this.adjustAllAtOnceMapButton();
    }

    public abstract void populateModel(Data var1);

    protected void populateModelFromTableView(Data data) {
        int n = this.v2ProductTabModel.getRowCount();
        if (n > 0) {
            data.set(Data.makeEnforceAttributeName(this.type), n > 0);
            data.put(Data.makeCountAttributeName(this.type), "" + n);
            for (int i = 0; i < n; ++i) {
                String string = (String)this.v2ProductTabModel.getValueAt(i, 0);
                String string2 = (String)this.v2ProductTabModel.getValueAt(i, 1);
                String string3 = (String)this.v2ProductTabModel.getValueAt(i, 2);
                String string4 = this.support.composeSubProductID(string2, string3);
                data.put(Data.makeAttributeName(this.type, "vendor", i), string);
                data.put(Data.makeAttributeName(this.type, "product", i), string4);
            }
        }
    }

    int populateModelByProductType(Data data, int n) {
        Vector vector = this.v2ProductTabModel.getProductsOfType(n);
        int n2 = vector.size();
        if (n2 > 0) {
            data.set(Data.makeEnforceAttributeName(n), n2 > 0);
            data.put(Data.makeCountAttributeName(n), "" + n2);
            for (int i = 0; i < n2; ++i) {
                OESISSupportV2toV4.Product product = (OESISSupportV2toV4.Product)vector.get(i);
                data.put(Data.makeAttributeName(n, "vendor", i), product.getOSPWATProductID());
                data.put(Data.makeAttributeName(n, "product", i), product.getName());
            }
        }
        return n2;
    }

    public void removedMappedItems(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            OESISSupportV2toV4.MappingProduct mappingProduct = (OESISSupportV2toV4.MappingProduct)vector.get(i);
            String string = mappingProduct.getV2OSPWATProductID();
            String[] stringArray = this.support.splitSubProductID(mappingProduct.getV2ID());
            if (null == stringArray) continue;
            this.removedMatchingRow(string, stringArray[0], stringArray[1]);
        }
        this.adjustAllAtOnceMapButton();
    }

    private void removedMatchingRow(String string, String string2, String string3) {
        for (int i = this.v2ProductTabModel.getRowCount() - 1; i >= 0; --i) {
            String string4 = (String)this.v2ProductTabModel.getValueAt(i, 0);
            String string5 = (String)this.v2ProductTabModel.getValueAt(i, 1);
            String string6 = (String)this.v2ProductTabModel.getValueAt(i, 2);
            if (!string4.equals(string) || !string5.equals(string2) || !string6.equals(string3)) continue;
            this.v2ProductTabModel.removeRow(i);
            break;
        }
    }

    public OESISSupportV2toV4.Product[] getCurrentV2Products() {
        int n = this.v2ProductTabModel.getRowCount();
        if (n <= 0) {
            return null;
        }
        OESISSupportV2toV4.Product[] productArray = new OESISSupportV2toV4.Product[n];
        for (int i = 0; i < n; ++i) {
            OESISSupportV2toV4.Product product = this.v2ProductTabModel.getProduct(i);
            if (null == product) continue;
            productArray[i] = product;
        }
        return productArray;
    }

    private void createButtons() {
        final AbstractAction abstractAction = new AbstractAction("Delete"){
            {
                this.enabled = false;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                V2ProductTable.this.deleteProducts();
            }
        };
        this.deleteButton = new JButton(abstractAction);
        final AbstractAction abstractAction2 = new AbstractAction("Map Selected"){
            {
                this.enabled = false;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                V2ProductTable.this.notifySelectedProducts();
            }
        };
        this.selectiveMapButton = new JButton(abstractAction2);
        final AbstractAction abstractAction3 = new AbstractAction("Map All At Once"){
            {
                this.enabled = true;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                V2ProductTable.this.notifyShowAllAtOnce();
            }
        };
        this.allAtOnceMapButton = new JButton(abstractAction3);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                abstractAction.setEnabled(!V2ProductTable.this.getSelectionModel().isSelectionEmpty());
                abstractAction2.setEnabled(!V2ProductTable.this.getSelectionModel().isSelectionEmpty());
                abstractAction3.setEnabled(!V2ProductTable.this.getSelectionModel().isSelectionEmpty());
            }
        });
    }

    private void notifyShowAllAtOnce() {
        OESISSupportV2toV4.Product[] productArray = this.getCurrentV2Products();
        this.selectionNotifier.selectedV2Products(productArray);
    }

    private void notifySelectedProducts() {
        Vector<OESISSupportV2toV4.Product> vector = new Vector<OESISSupportV2toV4.Product>();
        for (int i = 0; i < this.v2ProductTabModel.getRowCount(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            OESISSupportV2toV4.Product product = this.v2ProductTabModel.getProduct(i);
            vector.add(product);
        }
        OESISSupportV2toV4.Product[] productArray = new OESISSupportV2toV4.Product[vector.size()];
        vector.toArray(productArray);
        this.selectionNotifier.selectedV2Products(productArray);
    }

    public int manuallyDeletedProductCount() {
        return this.manuallyDeletedCount;
    }

    private void deleteProducts() {
        for (int i = this.v2ProductTabModel.getRowCount() - 1; i >= 0; --i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            ++this.manuallyDeletedCount;
            this.v2ProductTabModel.removeRow(i);
        }
    }
}

