/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import com.cisco.secinspv2tov4migration.Data;
import com.cisco.secinspv2tov4migration.OESISSupportV2toV4;
import com.cisco.secinspv2tov4migration.ProductSelections;
import com.cisco.secinspv2tov4migration._TableModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public abstract class ProductTable
extends JTable {
    private OESISSupportV2toV4 support;
    private String osSignature;
    private int type;
    private JButton addButton;
    private JButton deleteButton;

    ProductTable(int n, OESISSupportV2toV4 oESISSupportV2toV4, String string, int n2) {
        this.type = n;
        this.support = oESISSupportV2toV4;
        this.osSignature = string;
        this.setRowSelectionAllowed(true);
        this.getSelectionModel().setSelectionMode(2);
        this.getTableHeader().setReorderingAllowed(false);
        this.setModel(new _TableModel(n2));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public String getToolTipText() {
                String string = this.getText();
                if (null != string && string.length() > 0) {
                    return string;
                }
                return null;
            }
        };
        this.setDefaultRenderer(Object.class, defaultTableCellRenderer);
    }

    ProductTable(int n, OESISSupportV2toV4 oESISSupportV2toV4, String string) {
        this(n, oESISSupportV2toV4, string, 3);
    }

    JButton getAddButton() {
        if (null == this.addButton) {
            this.createButtons();
        }
        return this.addButton;
    }

    JButton getDeleteButton() {
        if (null == this.deleteButton) {
            this.createButtons();
        }
        return this.deleteButton;
    }

    void populateView(Data data) {
        int n = data.getProductCount(this.type);
        if (0 == n) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this.getVendorProduct(data, i);
            if (objectArray == null) continue;
            defaultTableModel.addRow(objectArray);
        }
    }

    void populateModel(Data data) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        int n = defaultTableModel.getRowCount();
        data.set(Data.makeEnforceAttributeName(this.type), n > 0);
        data.put(Data.makeCountAttributeName(this.type), "" + n);
        for (int i = 0; i < n; ++i) {
            OESISSupportV2toV4.Vendor vendor = (OESISSupportV2toV4.Vendor)defaultTableModel.getValueAt(i, 0);
            OESISSupportV2toV4.Product product = (OESISSupportV2toV4.Product)defaultTableModel.getValueAt(i, 1);
            String string = this.getOPSWATProductID(vendor, product);
            data.put(Data.makeAttributeName(this.type, "vendor", i), string);
            data.put(Data.makeAttributeName(this.type, "product", i), product.getID());
        }
    }

    boolean isCapable(Object object) {
        return this.getCapableProducts(object).length != 0;
    }

    OESISSupportV2toV4.Product[] getCapableProducts(Object object) {
        ArrayList<OESISSupportV2toV4.Product> arrayList = new ArrayList<OESISSupportV2toV4.Product>();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            OESISSupportV2toV4.Product product = (OESISSupportV2toV4.Product)defaultTableModel.getValueAt(i, 1);
            if (!product.canFeature(object)) continue;
            arrayList.add(product);
        }
        OESISSupportV2toV4.Product[] productArray = new OESISSupportV2toV4.Product[arrayList.size()];
        arrayList.toArray(productArray);
        return productArray;
    }

    private void createButtons() {
        AbstractAction abstractAction = new AbstractAction("Add..."){

            public void actionPerformed(ActionEvent actionEvent) {
                ProductTable.this.addProducts();
            }
        };
        final AbstractAction abstractAction2 = new AbstractAction("Delete"){
            {
                this.enabled = false;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ProductTable.this.deleteProducts();
            }
        };
        this.addButton = new JButton(abstractAction);
        this.deleteButton = new JButton(abstractAction2);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                abstractAction2.setEnabled(!ProductTable.this.getSelectionModel().isSelectionEmpty());
            }
        });
    }

    private void addProducts() {
        Object[][] objectArray = new ProductSelections(this.type, this.support, this.osSignature).getSelections();
        if (null == objectArray) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2;
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            objectArray2 = new Object[]{objectArray[i][0], objectArray[i][1], this.getSupportNote((OESISSupportV2toV4.Product)objectArray2[1])};
            defaultTableModel.addRow(objectArray2);
        }
    }

    private void deleteProducts() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            defaultTableModel.removeRow(i);
        }
    }

    protected abstract String getSupportNote(OESISSupportV2toV4.Product var1);

    private Object[] getVendorProduct(Data data, int n) {
        Object[] objectArray = new Object[3];
        OESISSupportV2toV4.Vendor[] vendorArray = this.getVendor4OpswatProductID(data.get(Data.makeAttributeName(this.type, "vendor", n)));
        OESISSupportV2toV4.Product product = null;
        OESISSupportV2toV4.Vendor vendor = null;
        if (vendorArray.length > 0) {
            product = this.getProductByID(vendorArray[0], data.get(Data.makeAttributeName(this.type, "product", n)));
            if (null == product && vendorArray.length > 1) {
                product = this.getProductByID(vendorArray[1], data.get(Data.makeAttributeName(this.type, "product", n)));
                vendor = vendorArray[1];
            } else {
                vendor = vendorArray[0];
            }
        }
        if (null == product) {
            String string = data.get(Data.makeAttributeName(this.type, "vendor", n));
            String string2 = "";
            if (null != vendor) {
                string2 = vendor.getName();
            }
            System.out.println("This product is not found in OPSWAT SupportChart:productID:" + string + " and name:" + string2);
            return null;
        }
        objectArray[0] = vendor;
        objectArray[1] = product;
        objectArray[2] = this.getSupportNote(product);
        return objectArray;
    }

    private OESISSupportV2toV4.Vendor[] getVendor4OpswatProductID(String string) {
        if (null == string || 0 == string.length()) {
            return null;
        }
        OESISSupportV2toV4.Vendor[] vendorArray = this.getVendors4ThisOS(this.type);
        ArrayList<OESISSupportV2toV4.Vendor> arrayList = new ArrayList<OESISSupportV2toV4.Vendor>();
        for (int i = 0; i < vendorArray.length; ++i) {
            String[] stringArray = vendorArray[i].getProductIDs();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equals(string)) continue;
                arrayList.add(vendorArray[i]);
            }
        }
        OESISSupportV2toV4.Vendor[] vendorArray2 = new OESISSupportV2toV4.Vendor[arrayList.size()];
        for (int i = 0; i < vendorArray2.length; ++i) {
            vendorArray2[i] = (OESISSupportV2toV4.Vendor)arrayList.get(i);
        }
        return vendorArray2;
    }

    private String getOPSWATProductID(OESISSupportV2toV4.Vendor vendor, OESISSupportV2toV4.Product product) {
        String string = product.getName();
        String string2 = vendor.getName();
        String[] stringArray = vendor.getProductIDs();
        for (int i = 0; i < stringArray.length; ++i) {
            OESISSupportV2toV4.Product[] productArray = this.support.getSubProducts(this.type, stringArray[i], string2);
            for (int j = 0; j < productArray.length; ++j) {
                String string3 = productArray[j].getName();
                String string4 = productArray[j].getVendor();
                if (!string.equals(string3) || !string2.equals(string4)) continue;
                return stringArray[i];
            }
        }
        return "";
    }

    private OESISSupportV2toV4.Product getProductByID(OESISSupportV2toV4.Vendor vendor, String string) {
        if (null == vendor || null == string) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Microsoft Windows Firewall|xP SP2", "Microsoft Windows Firewall|XP SP2+");
        OESISSupportV2toV4.Product[] productArray = this.getProducts4ThisOS(vendor);
        for (int i = 0; i < productArray.length; ++i) {
            String string2 = productArray[i].getID();
            if (string.equals(string2)) {
                return productArray[i];
            }
            if (!string2.equals(hashMap.get(string))) continue;
            return productArray[i];
        }
        System.out.println("CSDM: product \"" + string + "\" not found in OPSWAT database for vendor " + vendor.getName());
        return null;
    }

    protected OESISSupportV2toV4.Vendor[] getVendors4ThisOS(int n) {
        OESISSupportV2toV4.Vendor[] vendorArray = this.support.getVendors(n);
        Vector<OESISSupportV2toV4.Vendor> vector = new Vector<OESISSupportV2toV4.Vendor>();
        for (int i = 0; i < vendorArray.length; ++i) {
            if (!this.hasProducts4ThisOS(vendorArray[i])) continue;
            vector.addElement(vendorArray[i]);
        }
        OESISSupportV2toV4.Vendor[] vendorArray2 = new OESISSupportV2toV4.Vendor[vector.size()];
        vector.toArray(vendorArray2);
        return vendorArray2;
    }

    private boolean hasProducts4ThisOS(OESISSupportV2toV4.Vendor vendor) {
        return this.getProducts4ThisOS(vendor).length != 0;
    }

    protected OESISSupportV2toV4.Product[] getProducts4ThisOS(OESISSupportV2toV4.Vendor vendor) {
        if (null == vendor) {
            return null;
        }
        String[] stringArray = vendor.getProductIDs();
        Vector<OESISSupportV2toV4.Product> vector = new Vector<OESISSupportV2toV4.Product>();
        for (int i = 0; i < stringArray.length; ++i) {
            OESISSupportV2toV4.Product[] productArray = this.support.getSubProducts(this.type, stringArray[i], vendor.getName());
            for (int j = 0; j < productArray.length; ++j) {
                if (!this.is4ThisOS(productArray[j]) || !productArray[j].getVendor().equals(vendor.getName())) continue;
                vector.addElement(productArray[j]);
            }
        }
        OESISSupportV2toV4.Product[] productArray = new OESISSupportV2toV4.Product[vector.size()];
        vector.toArray(productArray);
        return productArray;
    }

    private boolean is4ThisOS(OESISSupportV2toV4.Product product) {
        String string = product.getName();
        if (null == this.osSignature || this.osSignature.length() == 0) {
            return string.indexOf("(Mac)") == -1 && string.indexOf("(Linux)") == -1;
        }
        return string.indexOf(this.osSignature) != -1;
    }
}

