/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import com.cisco.secinspv2tov4migration.OESISSupportV2toV4;
import com.cisco.secinspv2tov4migration.ProductTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;

public class ProductSelections {
    private int type;
    private ProductTable table;

    ProductSelections(int n, OESISSupportV2toV4 oESISSupportV2toV4, String string) {
        this.type = n;
        this.table = new ProductTable(n, oESISSupportV2toV4, string, 3){

            protected String getSupportNote(OESISSupportV2toV4.Product product) {
                return product.getOSPWATProductID();
            }
        };
    }

    Object[][] getSelections() {
        String string = "Add " + OESISSupportV2toV4.GetDisplayTYPEName(this.type) + " Products";
        int n = JOptionPane.showConfirmDialog(this.table, this.createContentPane(), string, 2, -1);
        if (n == 0) {
            return this._getSelections();
        }
        return null;
    }

    private Object[][] _getSelections() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            if (!this.table.getSelectionModel().isSelectedIndex(i)) continue;
            Object[] objectArray = new Object[]{defaultTableModel.getValueAt(i, 0), defaultTableModel.getValueAt(i, 1)};
            arrayList.add(objectArray);
        }
        Object[][] objectArray = new Object[arrayList.size()][];
        arrayList.toArray((T[])objectArray);
        return objectArray;
    }

    private Container createContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(500, 400));
        jPanel.add((Component)new JLabel("You can select single or mutiple entries to add:"), "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.populateProductChoices();
        return jPanel;
    }

    private void populateProductChoices() {
        OESISSupportV2toV4.Vendor[] vendorArray = this.table.getVendors4ThisOS(this.type);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        for (int i = 0; i < vendorArray.length; ++i) {
            OESISSupportV2toV4.Product[] productArray = this.table.getProducts4ThisOS(vendorArray[i]);
            for (int j = 0; j < productArray.length; ++j) {
                if (this.isSelected(vendorArray[i], productArray[j]) || !productArray[j].getVendor().equals(vendorArray[i].getName())) continue;
                String string = productArray[j].getOSPWATProductID();
                defaultTableModel.addRow(new Object[]{vendorArray[i], productArray[j], string});
            }
        }
    }

    private boolean isSelected(OESISSupportV2toV4.Vendor vendor, OESISSupportV2toV4.Product product) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            if (vendor != defaultTableModel.getValueAt(i, 0) || product != defaultTableModel.getValueAt(i, 1)) continue;
            return true;
        }
        return false;
    }
}

