/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import com.cisco.secinspv2tov4migration.Env;
import com.cisco.secinspv2tov4migration.V4SelectionItem;
import com.cisco.secinspv2tov4migration.V4SelectionList;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdomRel1.Attribute;
import org.jdomRel1.Document;
import org.jdomRel1.Element;
import org.jdomRel1.input.SAXBuilder;

public class OESISSupportV2toV4 {
    public static int V2_AV_TYPE = 0;
    public static int V2_FW_TYPE = 1;
    public static int V2_AS_TYPE = 2;
    public static int V4_AM_TYPE = 3;
    public static int V4_FW_TYPE = 4;
    public static int PRODUCT_TYPE_COUNT = 5;
    public static String[] TYPENAMES = new String[]{"Anti-virus", "V2 Firewall", "Anti-Spy-ware", "AntiMalware", "V4 Firewall"};
    public static final String SIG_MS = "";
    public static final String SIG_MAC = "(Mac)";
    public static final String SIG_LINUX = "(Linux)";
    public static final String PREDEFINED_VENDOR_V2_TO_V4_MAP_FILE = "Vendorsv2tov4PredefinedNames.txt";
    private ArrayList[] Products;
    private HashMap subProductsMap;
    private HashMap v2tov4PredefinedVendorMap = new HashMap();
    public static String _ActiveProtect = "ActiveProtect";
    public static String _UpdateDefs = "UpdateDefs";
    public static String _FirewallOn = "FirewallOn";
    public static String _FirewallOff = "FirewallOff";

    public static String GetDisplayTYPEName(int n) {
        if (n >= 0 && n < PRODUCT_TYPE_COUNT) {
            return TYPENAMES[n];
        }
        return TYPENAMES[n];
    }

    public OESISSupportV2toV4() {
        this.Products = new ArrayList[PRODUCT_TYPE_COUNT];
        for (int i = 0; i < PRODUCT_TYPE_COUNT; ++i) {
            this.Products[i] = new ArrayList();
        }
        this.subProductsMap = new HashMap();
    }

    public void loadPredefinedv2tov4VendorNames() {
        try {
            InputStream inputStream = OESISSupportV2toV4.class.getResourceAsStream(PREDEFINED_VENDOR_V2_TO_V4_MAP_FILE);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (null != string) {
                String[] stringArray;
                if (string.length() > 0 && !string.startsWith("#") && (stringArray = string.split("=")).length == 2) {
                    this.v2tov4PredefinedVendorMap.put(stringArray[0], stringArray[1]);
                }
                string = bufferedReader.readLine();
            }
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static OESISSupportV2toV4 loadInspectorSupport(String string) {
        OESISSupportV2toV4 oESISSupportV2toV4 = new OESISSupportV2toV4();
        try {
            String string2 = Env.getInputURL().toString();
            if (string2.endsWith("data.xml")) {
                string2 = string2.substring(0, string2.length() - "data.xml".length());
            }
            String string3 = string2 + "install/binaries/extensions/";
            String string4 = string3 + "secinsp_" + string;
            URL uRL = new URL(string4 + "_am.xml");
            System.out.println("Loading V4 AM supportChart " + uRL.toExternalForm());
            oESISSupportV2toV4.loadXML_V4supportChart(V4_AM_TYPE, uRL);
            System.out.println("Loaded V4 AM supportChart " + uRL.toExternalForm());
            URL uRL2 = new URL(string4 + "_fw.xml");
            System.out.println("Loading... V4 FW supportChart " + uRL2.toExternalForm());
            oESISSupportV2toV4.loadXML_V4supportChart(V4_FW_TYPE, uRL2);
            System.out.println("Loaded V4 FW supportChart " + uRL2.toExternalForm());
            oESISSupportV2toV4.loadPredefinedv2tov4VendorNames();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return oESISSupportV2toV4;
    }

    public boolean loadXML_V4supportChart(int n, URL uRL) {
        if (uRL != null) {
            Element element = null;
            SAXBuilder sAXBuilder = new SAXBuilder();
            try {
                Document document = sAXBuilder.build(uRL);
                element = document.getRootElement();
                List list = element.getChildren();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Element element2 = (Element)iterator.next();
                    if (!element2.getName().equals("Vendor")) continue;
                    String string = this.getAttribute(element2, "Vendor_Name");
                    Vendor vendor = this.addVendor(n, string, string);
                    List list2 = element2.getChildren();
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        Element element3 = (Element)iterator2.next();
                        if (!element3.getName().equals("Support")) continue;
                        String string2 = this.getAttribute(element3, "Product_Name");
                        String string3 = this.getAttribute(element3, "Product_ID");
                        vendor.addProductID(string3);
                        String string4 = this.getAttribute(element3, "Tested_Points");
                        Product product = this.addSubProduct(n, string3, string2, string4, string);
                        if (product == null) continue;
                        product.setFeature(_ActiveProtect, this.checkAttribute(element3, "GetRealTimeProtectionState") && this.checkAttribute(element3, "EnableRTP"));
                        product.setFeature(_UpdateDefs, this.checkAttribute(element3, "GetDefinitionState") && this.checkAttribute(element3, "UpdateDefinitions"));
                        product.setFeature(_FirewallOn, this.checkAttribute(element3, "GetFirewallState") && this.checkAttribute(element3, "SetFirewallState"));
                        product.setFeature(_FirewallOff, this.checkAttribute(element3, "GetFirewallState") && this.checkAttribute(element3, "SetFirewallState"));
                    }
                }
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        System.out.println("Failed to Load XML, URL is null");
        return false;
    }

    private String getAttribute(Element element, String string) {
        Attribute attribute = element.getAttribute(string);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    private boolean checkAttribute(Element element, String string) {
        Attribute attribute = element.getAttribute(string);
        if (attribute != null) {
            return "v".equals(attribute.getValue());
        }
        return false;
    }

    public Vendor addVendor(int n, String string, String string2) {
        if (string != null && string2 != null && n < PRODUCT_TYPE_COUNT) {
            Vendor vendor = new Vendor(string, string2);
            if (!this.Products[n].contains(vendor)) {
                this.Products[n].add(vendor);
            }
            return vendor;
        }
        return null;
    }

    private String getInternalProductType(int n) {
        String string = "prd_type_" + n + "_";
        return string;
    }

    private String getSubProductMapUniqueKey(int n, String string, String string2) {
        if (n >= 0 && n < PRODUCT_TYPE_COUNT && null != string && null != string2) {
            String string3 = "prd_type_" + n + "_" + string + "_" + string2;
            return string3;
        }
        return null;
    }

    public Product addSubProduct(int n, String string, String string2, String string3, String string4) {
        String string5 = this.getSubProductMapUniqueKey(n, string, string4);
        if (null != string5 && null != string && null != string2 && null != string3) {
            ArrayList arrayList;
            String string6 = "1234567890".indexOf(string2.charAt(string2.length() - 1)) != -1 ? string2 : string2 + " " + string3;
            Product product = new Product(string2 + '|' + string3, string6, string4, string, n);
            if (!this.subProductsMap.containsKey(string5)) {
                this.subProductsMap.put(string5, new ArrayList());
            }
            if (!(arrayList = (ArrayList)this.subProductsMap.get(string5)).contains(product)) {
                arrayList.add(product);
            }
            return product;
        }
        return null;
    }

    public Vendor[] getVendors(int n) {
        Vendor[] vendorArray = new Vendor[this.Products[n].size()];
        this.Products[n].toArray(vendorArray);
        return vendorArray;
    }

    public Product[] getSubProducts(int n, String string, String string2) {
        ArrayList arrayList;
        String string3 = this.getSubProductMapUniqueKey(n, string, string2);
        if (null != string3 && null != (arrayList = (ArrayList)this.subProductsMap.get(string3))) {
            Product[] productArray = new Product[arrayList.size()];
            arrayList.toArray(productArray);
            return productArray;
        }
        return null;
    }

    public boolean isProductMatchWithThisOS(String string, String string2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (-1 != string2.indexOf(SIG_MAC)) {
            bl2 = true;
        }
        if (-1 != string2.indexOf(SIG_LINUX)) {
            bl3 = true;
        }
        if (0 == string.length()) {
            if (!bl2 && !bl3) {
                bl = true;
            }
        } else if (string.equals(SIG_MAC) && bl2) {
            if (!bl3) {
                bl = true;
            }
        } else if (string.equals(SIG_LINUX) && bl3 && !bl2) {
            bl = true;
        }
        return bl;
    }

    private V4SelectionList getAllMatchingV4Products(String string, int n, Product product) {
        Object object;
        int n2;
        V4SelectionList v4SelectionList = new V4SelectionList();
        Vector<V4SelectionItem> vector = new Vector<V4SelectionItem>();
        Vector<V4SelectionItem> vector2 = new Vector<V4SelectionItem>();
        if (null == product || product.getName().length() <= 0 || !this.isProductMatchWithThisOS(string, product.getName())) {
            return v4SelectionList;
        }
        Iterator iterator = this.subProductsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3;
            n2 = 0;
            object = iterator.next();
            String string4 = (String)object.getKey();
            ArrayList arrayList = (ArrayList)object.getValue();
            if (null == arrayList || arrayList.size() <= 0 || -1 == string4.indexOf(string3 = this.getInternalProductType(n))) continue;
            int n3 = 0;
            String string5 = this.getVendorNameFromOSSWATV2ProductID(product.getProductType(), product.getOSPWATProductID());
            if (-1 != string4.indexOf(string5)) {
                n3 = 1;
            }
            if (null != (string2 = this.getPredefinedv4VendorName(string5)) && -1 != string4.indexOf(string2)) {
                n3 = 1;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                String[] stringArray;
                n2 = n3;
                Product product2 = (Product)arrayList.get(i);
                if (!this.isProductMatchWithThisOS(string, product2.getName()) || null == (stringArray = this.splitSubProductID(product.getName())) || null == stringArray[0]) continue;
                String string6 = stringArray[0];
                if (-1 != product2.getName().indexOf(string6)) {
                    ++n2;
                } else if (-1 != string4.indexOf(string6) || -1 != product2.getName().indexOf(string5)) {
                    n2 = 1;
                }
                if (0 == n2) continue;
                Product product3 = new Product(product2.getID(), product2.getName(), product2.getVendor(), product2.getOSPWATProductID(), n);
                V4SelectionItem v4SelectionItem = new V4SelectionItem(product3, false);
                if (2 == n2) {
                    vector2.add(v4SelectionItem);
                    continue;
                }
                vector.add(v4SelectionItem);
            }
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            object = (V4SelectionItem)vector2.get(n2);
            v4SelectionList.add((V4SelectionItem)object);
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = (V4SelectionItem)vector.get(n2);
            v4SelectionList.add((V4SelectionItem)object);
        }
        return v4SelectionList;
    }

    public String getPredefinedv4VendorName(String string) {
        String string2 = null;
        if (null != string) {
            string2 = (String)this.v2tov4PredefinedVendorMap.get(string);
        }
        return string2;
    }

    public Vector getMatchingV4ProductsAllAtOnce(String string, int n, Product[] productArray) {
        Vector<V2ProductWithV4ProductMatch> vector = new Vector<V2ProductWithV4ProductMatch>();
        if (null == productArray || productArray.length <= 0) {
            return vector;
        }
        for (int i = 0; i < productArray.length; ++i) {
            Product product = productArray[i];
            V2ProductWithV4ProductMatch v2ProductWithV4ProductMatch = new V2ProductWithV4ProductMatch(product.getID(), product.getName(), product.getVendor(), product.getOSPWATProductID());
            v2ProductWithV4ProductMatch.addV4SelectionList(this.getAllMatchingV4Products(string, n, product));
            vector.add(v2ProductWithV4ProductMatch);
        }
        return vector;
    }

    public String getVendorNameFromOSSWATV2ProductID(int n, String string) {
        if (null != string && string.length() > 2 && (V2_AV_TYPE == n && string.endsWith("AV") || V2_FW_TYPE == n && string.endsWith("FW") || V2_AS_TYPE == n && string.endsWith("AS"))) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    public String[] splitSubProductID(String string) {
        if (null == string || 0 == string.length()) {
            return null;
        }
        String[] stringArray = new String[]{SIG_MS, SIG_MS};
        int n = string.indexOf("|");
        if (n > 0) {
            stringArray[0] = string.substring(0, n);
            ++n;
        }
        if (n > 0 && n < string.length()) {
            stringArray[1] = string.substring(n);
        }
        return stringArray;
    }

    public String composeSubProductID(String string, String string2) {
        if (null == string || null == string2) {
            return SIG_MS;
        }
        String string3 = string + '|' + string2;
        return string3;
    }

    public Product createV2Product(String string, String string2, String string3, String string4, int n) {
        return new Product(string, string2, string3, string4, n);
    }

    public Product createV4Product(String string, String string2, String string3, String string4, int n) {
        return new Product(string, string2, string3, string4, n);
    }

    public MappingProduct createMappingProduct(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        return new MappingProduct(string, string2, string3, string4, string5, string6, string7, string8);
    }

    public class MappingProduct {
        private String v2_ospwatProductId;
        private String v2_ID;
        private String v2_Name;
        private String v2_Vendor;
        private String v2_version;
        private String v4_ospwatProductId;
        private String v4_ID;
        private String v4_Name;
        private String v4_Vendor;

        public MappingProduct(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
            this.v2_ID = string;
            this.v2_Name = string2;
            this.v2_Vendor = string3;
            this.v2_ospwatProductId = string4;
            this.v4_ID = string5;
            this.v4_Name = string6;
            this.v4_Vendor = string7;
            this.v4_ospwatProductId = string8;
        }

        public String getV2OSPWATProductID() {
            return this.v2_ospwatProductId;
        }

        public String getV2ID() {
            return this.v2_ID;
        }

        public String getV2Name() {
            return this.v2_Name;
        }

        public String getV2Vendor() {
            return this.v2_Vendor;
        }

        public String getV4OSPWATProductID() {
            return this.v4_ospwatProductId;
        }

        public String getV4ID() {
            return this.v4_ID;
        }

        public String getV4Name() {
            return this.v4_Name;
        }

        public String getV4Vendor() {
            return this.v4_Vendor;
        }

        public boolean equals(Object object) {
            return object != null && object instanceof MappingProduct && this.getV2ID() != null && this.getV2ID().equals(((MappingProduct)object).getV2ID());
        }

        public String toString() {
            return this.getV2Name() + this.getV4Name();
        }
    }

    public class V2ProductWithV4ProductMatch {
        private String ospwatProductId;
        private String ID;
        private String Name;
        private String Vendor;
        private V4SelectionList v4_product_selection;

        public V2ProductWithV4ProductMatch(String string, String string2, String string3, String string4) {
            this.ID = string;
            this.Name = string2;
            this.Vendor = string3;
            this.ospwatProductId = string4;
            this.v4_product_selection = new V4SelectionList();
        }

        public void addV4SelectionList(V4SelectionList v4SelectionList) {
            this.v4_product_selection = v4SelectionList;
        }

        public int getV4ProductMatchCount() {
            return this.v4_product_selection.size();
        }

        public V4SelectionList getV4SelectionList() {
            return this.v4_product_selection;
        }

        public String getOSPWATProductID() {
            return this.ospwatProductId;
        }

        public String getID() {
            return this.ID;
        }

        public String getName() {
            return this.Name;
        }

        public String getVendor() {
            return this.Vendor;
        }

        public boolean equals(Object object) {
            return object != null && object instanceof V2ProductWithV4ProductMatch && this.getID() != null && this.getID().equals(((V2ProductWithV4ProductMatch)object).getID());
        }

        public String toString() {
            return this.getName();
        }
    }

    public class Product {
        private String ospwatProductId;
        private String ID;
        private String Name;
        private String Vendor;
        private HashSet features;
        private int prd_type = -1;

        public Product(String string, String string2, String string3, String string4, int n) {
            this.ID = string;
            this.Name = string2;
            this.Vendor = string3;
            this.ospwatProductId = string4;
            this.features = new HashSet();
            this.prd_type = n;
        }

        public String getOSPWATProductID() {
            return this.ospwatProductId;
        }

        public String getID() {
            return this.ID;
        }

        public String getName() {
            return this.Name;
        }

        public String getVendor() {
            return this.Vendor;
        }

        public int getProductType() {
            return this.prd_type;
        }

        public boolean equals(Object object) {
            return null != object && object instanceof Product && null != this.getID() && this.getID().equals(((Product)object).getID());
        }

        public String toString() {
            return this.getName();
        }

        public boolean canFeature(Object object) {
            return this.features.contains(object);
        }

        public void setFeature(Object object, boolean bl) {
            if (bl) {
                this.features.add(object);
            } else {
                this.features.remove(object);
            }
        }
    }

    public class Vendor {
        private String ID;
        private String Name;
        private Vector productIDs = new Vector();

        public Vendor(String string, String string2) {
            this.ID = string;
            this.Name = string2;
        }

        public String getID() {
            return this.ID;
        }

        public String getName() {
            return this.Name;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof Vendor) {
                Vendor vendor = (Vendor)object;
                if (this.ID != null && this.ID.equals(vendor.ID) && this.productIDs.equals(vendor.productIDs)) {
                    return true;
                }
            }
            return false;
        }

        public String[] getProductIDs() {
            String[] stringArray = new String[this.productIDs.size()];
            this.productIDs.toArray(stringArray);
            return stringArray;
        }

        void addProductID(String string) {
            if (!this.productIDs.contains(string)) {
                this.productIDs.add(string);
            }
        }

        public String toString() {
            return this.getName();
        }
    }
}

