/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import com.cisco.secinspv2tov4migration.OESISSupportV2toV4;
import com.cisco.secinspv2tov4migration.V4SelectionList;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class MappingSelectionTableModel
extends DefaultTableModel {
    private String[] columnNames;
    private Vector v2v4Matches;
    private OESISSupportV2toV4 support;

    private MappingSelectionTableModel() {
    }

    public MappingSelectionTableModel(OESISSupportV2toV4 oESISSupportV2toV4, Vector vector, int n, int n2, String[] stringArray) {
        super(n, n2);
        this.support = oESISSupportV2toV4;
        this.v2v4Matches = vector;
        this.columnNames = stringArray;
    }

    public boolean isCellEditable(int n, int n2) {
        return 4 == n2;
    }

    public Class getColumnClass(int n) {
        Class<?> clazz = null;
        if (3 == n) {
            Integer n2 = new Integer(0);
            clazz = n2.getClass();
        } else if (4 == n) {
            V4SelectionList v4SelectionList = new V4SelectionList();
            clazz = v4SelectionList.getClass();
        } else {
            String string = "";
            clazz = string.getClass();
        }
        return clazz;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getRowCount() {
        if (null != this.v2v4Matches) {
            return this.v2v4Matches.size();
        }
        return 0;
    }

    public void removeRow(int n) {
        this.v2v4Matches.removeElementAt(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void setValueAt(Object object, int n, int n2) {
        OESISSupportV2toV4.V2ProductWithV4ProductMatch v2ProductWithV4ProductMatch = (OESISSupportV2toV4.V2ProductWithV4ProductMatch)this.v2v4Matches.get(n);
    }

    public Object getValueAt(int n, int n2) {
        String[] stringArray;
        Object object = null;
        OESISSupportV2toV4.V2ProductWithV4ProductMatch v2ProductWithV4ProductMatch = (OESISSupportV2toV4.V2ProductWithV4ProductMatch)this.v2v4Matches.get(n);
        if (null == v2ProductWithV4ProductMatch) {
            return object;
        }
        String string = "";
        String string2 = "";
        if (null != v2ProductWithV4ProductMatch && null != (stringArray = this.support.splitSubProductID(v2ProductWithV4ProductMatch.getID()))) {
            string = stringArray[0];
            string2 = stringArray[1];
        }
        switch (n2) {
            case 0: {
                object = v2ProductWithV4ProductMatch.getOSPWATProductID();
                break;
            }
            case 1: {
                object = string;
                break;
            }
            case 2: {
                object = string2;
                break;
            }
            case 3: {
                object = new Integer(v2ProductWithV4ProductMatch.getV4ProductMatchCount());
                break;
            }
            case 4: {
                object = v2ProductWithV4ProductMatch.getV4SelectionList();
            }
        }
        return object;
    }

    public boolean itemExists(String string, int n) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            try {
                if (string.compareTo(this.getValueAt(i, n).toString()) != 0) continue;
                return true;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    public void addV4ProductToSelectionList(int n, OESISSupportV2toV4.Product product) {
        OESISSupportV2toV4.V2ProductWithV4ProductMatch v2ProductWithV4ProductMatch = (OESISSupportV2toV4.V2ProductWithV4ProductMatch)this.v2v4Matches.get(n);
        V4SelectionList v4SelectionList = v2ProductWithV4ProductMatch.getV4SelectionList();
        OESISSupportV2toV4.Product product2 = this.support.createV4Product(product.getID(), product.getName(), product.getVendor(), product.getOSPWATProductID(), product.getProductType());
        v4SelectionList.addV4Product(product2, true);
    }

    public Vector getMappedItems() {
        Vector<OESISSupportV2toV4.MappingProduct> vector = new Vector<OESISSupportV2toV4.MappingProduct>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            OESISSupportV2toV4.V2ProductWithV4ProductMatch v2ProductWithV4ProductMatch = (OESISSupportV2toV4.V2ProductWithV4ProductMatch)this.v2v4Matches.get(i);
            V4SelectionList v4SelectionList = v2ProductWithV4ProductMatch.getV4SelectionList();
            Vector vector2 = v4SelectionList.getSelectedV4Products();
            if (null == vector2 || vector2.size() <= 0) continue;
            for (int j = 0; j < vector2.size(); ++j) {
                OESISSupportV2toV4.Product product = (OESISSupportV2toV4.Product)vector2.get(j);
                OESISSupportV2toV4.MappingProduct mappingProduct = this.support.createMappingProduct(v2ProductWithV4ProductMatch.getID(), v2ProductWithV4ProductMatch.getName(), v2ProductWithV4ProductMatch.getVendor(), v2ProductWithV4ProductMatch.getOSPWATProductID(), product.getID(), product.getName(), product.getVendor(), product.getOSPWATProductID());
                vector.add(mappingProduct);
            }
        }
        return vector;
    }
}

