/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import com.cisco.secinspv2tov4migration.CheckedComboBox;
import com.cisco.secinspv2tov4migration.MappingSelectionTableModel;
import com.cisco.secinspv2tov4migration.OESISSupportV2toV4;
import com.cisco.secinspv2tov4migration.ProductSelections;
import com.cisco.secinspv2tov4migration.V4SelectionList;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class MappingSelectionTable
extends JTable {
    private OESISSupportV2toV4 support;
    private Vector v2v4Matches;
    private String osSignature;
    private int v2_prod_type;
    private int v4_prod_type;
    private JButton addButton;
    MappingSelectionTableModel tableModel;

    MappingSelectionTable(int n, int n2, Vector vector, OESISSupportV2toV4 oESISSupportV2toV4, String string, int n3) {
        Serializable serializable;
        this.v2_prod_type = n;
        this.v4_prod_type = n2;
        this.v2v4Matches = vector;
        this.support = oESISSupportV2toV4;
        this.osSignature = string;
        this.setRowSelectionAllowed(true);
        this.getSelectionModel().setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.tableModel = new MappingSelectionTableModel(oESISSupportV2toV4, vector, 0, 5, new String[]{"<html><center>Legacy HS</center>Product ID</html>", "<html><center>Legacy HS</center>Product Name</html>", "<html><center>Legacy HS</center>Version</html>", "<html><center>Match</center><center>Count</center></html>", "<html><center>Matching New HS</center>Product Details</html>"});
        this.setModel(this.tableModel);
        this.getTableHeader().getColumnModel().getColumn(0).setPreferredWidth(75);
        this.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(200);
        this.getTableHeader().getColumnModel().getColumn(2).setMinWidth(40);
        this.getTableHeader().getColumnModel().getColumn(2).setMaxWidth(75);
        this.getTableHeader().getColumnModel().getColumn(3).setMinWidth(40);
        this.getTableHeader().getColumnModel().getColumn(3).setMaxWidth(50);
        this.getTableHeader().getColumnModel().getColumn(4).setPreferredWidth(300);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setBackground(new Color(0, 0, 182, 155));
        defaultTableCellRenderer.setForeground(Color.WHITE);
        defaultTableCellRenderer.setHorizontalAlignment(0);
        this.getTableHeader().getColumnModel().getColumn(0).setHeaderRenderer(defaultTableCellRenderer);
        this.getTableHeader().getColumnModel().getColumn(1).setHeaderRenderer(defaultTableCellRenderer);
        this.getTableHeader().getColumnModel().getColumn(2).setHeaderRenderer(defaultTableCellRenderer);
        this.getTableHeader().getColumnModel().getColumn(3).setHeaderRenderer(defaultTableCellRenderer);
        this.getTableHeader().getColumnModel().getColumn(4).setHeaderRenderer(defaultTableCellRenderer);
        if (-1 != System.getProperty("os.name").toLowerCase().indexOf("mac")) {
            serializable = this.getSelectionBackground();
            this.setSelectionBackground(new Color(((Color)serializable).getRed(), ((Color)serializable).getGreen(), ((Color)serializable).getBlue(), ((Color)serializable).getAlpha()));
        }
        serializable = this.getColumnModel().getColumn(4);
        int n4 = this.getRowHeight() + 5;
        this.setRowHeight(n4);
        ((TableColumn)serializable).setCellEditor(new ProductSelectionComboxEditor());
        ((TableColumn)serializable).setCellRenderer(new ProductSelectionComboxRenderer());
    }

    JButton getAddButton() {
        if (this.addButton == null) {
            this.createAddButton();
        }
        return this.addButton;
    }

    private void createAddButton() {
        AbstractAction abstractAction = new AbstractAction("Add..."){
            {
                this.enabled = false;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MappingSelectionTable.this.addV4ProductsToSelectionList();
            }
        };
        this.addButton = new JButton(abstractAction);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MappingSelectionTable.this.addButton.setEnabled(!MappingSelectionTable.this.getSelectionModel().isSelectionEmpty());
            }
        });
    }

    private void addV4ProductsToSelectionList() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return;
        }
        Object[][] objectArray = new ProductSelections(this.v4_prod_type, this.support, this.osSignature).getSelections();
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            OESISSupportV2toV4.Vendor vendor = (OESISSupportV2toV4.Vendor)objectArray[i][0];
            OESISSupportV2toV4.Product product = (OESISSupportV2toV4.Product)objectArray[i][1];
            this.tableModel.addV4ProductToSelectionList(n, product);
        }
    }

    public Vector getMappedItems() {
        return this.tableModel.getMappedItems();
    }

    public static class ProductSelectionComboxEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final String RETRY_MESSAGE = "Please retry it";
        private boolean isPushed;
        HashMap checkComboMap = new HashMap();
        CheckedComboBox v4currentComboBox = null;
        int lastRow = -1;

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = String.valueOf(n);
            CheckedComboBox checkedComboBox = null;
            this.lastRow = n;
            V4SelectionList v4SelectionList = (V4SelectionList)object;
            if (!this.checkComboMap.containsKey(string)) {
                checkedComboBox = new CheckedComboBox(v4SelectionList);
                this.checkComboMap.put(string, checkedComboBox);
            } else {
                checkedComboBox = (CheckedComboBox)this.checkComboMap.get(string);
            }
            if (v4SelectionList.size() != checkedComboBox.getItemCount()) {
                checkedComboBox.resetSelectionList(v4SelectionList);
            }
            this.v4currentComboBox = checkedComboBox;
            this.isPushed = true;
            if (null == v4SelectionList || 0 == v4SelectionList.size()) {
                checkedComboBox.setEnabled(false);
            } else {
                checkedComboBox.setEnabled(true);
            }
            checkedComboBox.setBackground(jTable.getSelectionBackground());
            checkedComboBox.setForeground(jTable.getSelectionForeground());
            return checkedComboBox;
        }

        public Object getCellEditorValue() {
            if (this.isPushed) {
                JOptionPane.showMessageDialog(null, RETRY_MESSAGE);
            }
            this.isPushed = false;
            return this.v4currentComboBox.getV4SelectionList();
        }

        public boolean stopCellEditing() {
            this.isPushed = false;
            return super.stopCellEditing();
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    public static class ProductSelectionComboxRenderer
    extends CheckedComboBox
    implements TableCellRenderer {
        private static final String NO_MATCH_FOUND = "No possible match exists, click 'Add' to choose new product.";
        private static final String MATCH_FOUND = "Choose new product from dropdown or 'Add' button.";
        private static final String PRODUCT_SELECTED = "Mapped to";
        private static final String ONE_PRODUCT_SELECTED = "Mapped to 1 new product";
        private static final String MORETHAN_ONE_PRODUCT_SELECTED = "new products";
        JLabel label = new JLabel(this){
            private final /* synthetic */ ProductSelectionComboxRenderer this$0;
            {
                this.this$0 = productSelectionComboxRenderer;
            }

            public String toString() {
                return this.getText();
            }
        };

        public ProductSelectionComboxRenderer() {
            this.setOpaque(true);
            this.label.setOpaque(true);
            this.addItem(this.label);
        }

        public void updateValue(Object object) {
            int n;
            V4SelectionList v4SelectionList = (V4SelectionList)object;
            String string = "";
            string = null == v4SelectionList || 0 == v4SelectionList.size() ? NO_MATCH_FOUND : ((n = v4SelectionList.getSelectionCount()) > 0 ? (1 == n ? ONE_PRODUCT_SELECTED : "Mapped to " + n + " " + MORETHAN_ONE_PRODUCT_SELECTED) : MATCH_FOUND);
            this.label.setText(string);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.updateValue(object);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
                this.label.setBackground(jTable.getSelectionBackground());
                this.label.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
                this.label.setBackground(jTable.getBackground());
                this.label.setForeground(jTable.getForeground());
            }
            return this;
        }
    }
}

