/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import com.cisco.secinspv2tov4migration.CSVParser;
import com.cisco.secinspv2tov4migration.ComboField;
import com.cisco.secinspv2tov4migration.Data;
import com.cisco.secinspv2tov4migration.FixedTableModel;
import com.cisco.secinspv2tov4migration.MappingSelectionPanel;
import com.cisco.secinspv2tov4migration.OESISSupportV2toV4;
import com.cisco.secinspv2tov4migration.TextField;
import com.cisco.secinspv2tov4migration.Util;
import com.cisco.secinspv2tov4migration.V2FWProductTable;
import com.cisco.secinspv2tov4migration.V2ProductSelectionNotifier;
import com.cisco.secinspv2tov4migration.V2ToV4MappedProductTable;
import com.cisco.secinspv2tov4migration.V4ConfigurationData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

class FirewallPanel
extends JPanel
implements V2ProductSelectionNotifier {
    V2FWProductTable v2pfTable;
    V2ToV4MappedProductTable v2tov4pfMappedTable;
    private static final String PF_MIG_TEXT = "<html>The backed up Firewall Advanced Endpoint Assessment policies are listed below.<br>These Firewall products need to be mapped as new Firewall products under 'Mapped Rules'.</html>";
    JLabel migtext = new JLabel("<html>The backed up Firewall Advanced Endpoint Assessment policies are listed below.<br>These Firewall products need to be mapped as new Firewall products under 'Mapped Rules'.</html>");
    Border mappingStatusBorder;
    JLabel pfMappingStatusLabel;
    ComboField v4pfActionCombo;
    JLabel pfCaveat = new JLabel("(Not all of the selected products support firewall rules)");
    private static final String PF_WARN = "<HTML><b><font COLOR=RED>The action remains effective on client device even after VPN session ends, please use them with discretion.</font></b></HTML>";
    JLabel pfWarning = new JLabel("<HTML><b><font COLOR=RED>The action remains effective on client device even after VPN session ends, please use them with discretion.</font></b></HTML>");
    ComboField pfActionCombo;
    JButton pfRulesAdd;
    JButton pfRulesEdit;
    JButton pfRulesDel;
    FixedTableModel pfRulesModel;
    JTable pfRulesTable;
    ArrayList pfRulesList;
    private static final String PF_RULE_WARN = "<HTML><b><font COLOR=BLACK> NOTE: Legacy firewall rules are no longer supported and will automatically be <br>deleting during migration.<br>Please refer to the migration documentation for additional details</font></b></HTML>";
    JLabel pfRulesWarning = new JLabel("<HTML><b><font COLOR=BLACK> NOTE: Legacy firewall rules are no longer supported and will automatically be <br>deleting during migration.<br>Please refer to the migration documentation for additional details</font></b></HTML>");
    OESISSupportV2toV4 support;
    V4ConfigurationData existingV4pfData;
    private String osSuffix;
    private String osSignature;
    static final String ALLOW = "ALLOW";
    static final String BLOCK = "BLOCK";
    static final String appType = "Application";
    static final String portType = "Port";
    static String[] ruleComboOptions = new String[]{"ALLOW Application", "BLOCK Application", "ALLOW Port", "BLOCK Port"};
    static String[] portProtocolComboOptions = new String[]{"Any", "UDP", "TCP"};
    static /* synthetic */ Class class$java$awt$Frame;

    FirewallPanel(String string, String string2, String string3, OESISSupportV2toV4 oESISSupportV2toV4) {
        this.support = oESISSupportV2toV4;
        this.osSuffix = string;
        this.osSignature = string2;
        this.installComponents(string3);
    }

    private void installComponents(String string) {
        this.existingV4pfData = new V4ConfigurationData(string, this.osSuffix, OESISSupportV2toV4.V4_FW_TYPE);
        this.v2pfTable = new V2FWProductTable(OESISSupportV2toV4.V2_FW_TYPE, this.support, this);
        this.v2pfTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                FirewallPanel.this.adjustPFContext();
            }
        });
        this.pfActionCombo = new ComboField(new String[0], "", "");
        this.pfActionCombo.setLabels("Firewall Action: ", "");
        this.pfRulesAdd = new JButton("Add...");
        this.pfRulesAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Dialog_FirewallRule dialog_FirewallRule = new Dialog_FirewallRule(null);
                if (dialog_FirewallRule.showDialog(FirewallPanel.this.pfRulesAdd, "Add Rule")) {
                    String string = dialog_FirewallRule.toString();
                    Object[] objectArray = FirewallPanel.makeRow(string);
                    FirewallPanel.this.pfRulesList.add(string);
                    FirewallPanel.this.pfRulesModel.addRow(objectArray);
                }
            }
        });
        this.pfRulesEdit = new JButton("Edit...");
        this.pfRulesEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FirewallPanel.this.pfRulesTable.getSelectedRow();
                if (n < 0) {
                    return;
                }
                Dialog_FirewallRule dialog_FirewallRule = new Dialog_FirewallRule((String)FirewallPanel.this.pfRulesList.get(n));
                if (dialog_FirewallRule.showDialog(FirewallPanel.this.pfRulesEdit, "Edit Rule")) {
                    String string = dialog_FirewallRule.toString();
                    Object[] objectArray = FirewallPanel.makeRow(string);
                    FirewallPanel.this.pfRulesList.remove(n);
                    FirewallPanel.this.pfRulesList.add(n, string);
                    FirewallPanel.this.pfRulesModel.removeRow(n);
                    FirewallPanel.this.pfRulesModel.insertRow(n, objectArray);
                }
            }
        });
        this.pfRulesDel = new JButton("Delete");
        this.pfRulesDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FirewallPanel.this.pfRulesTable.getSelectedRow();
                if (n < 0) {
                    return;
                }
                if (FirewallPanel.this.pfRulesTable.getRowCount() == 1) {
                    FirewallPanel.this.pfRulesList.remove(n);
                    FirewallPanel.this.pfRulesModel.removeRow(n);
                } else if (FirewallPanel.this.pfRulesTable.getRowCount() - 1 == n) {
                    FirewallPanel.this.pfRulesList.remove(n);
                    FirewallPanel.this.pfRulesModel.removeRow(n);
                    FirewallPanel.this.pfRulesTable.setRowSelectionInterval(FirewallPanel.this.pfRulesTable.getRowCount() - 1, FirewallPanel.this.pfRulesTable.getRowCount() - 1);
                } else {
                    FirewallPanel.this.pfRulesList.remove(n);
                    FirewallPanel.this.pfRulesModel.removeRow(n);
                    FirewallPanel.this.pfRulesTable.setRowSelectionInterval(n, n);
                }
            }
        });
        this.pfRulesList = new ArrayList();
        this.pfRulesModel = new FixedTableModel(0, 1, new String[]{"Rules"});
        this.pfRulesTable = new JTable(this.pfRulesModel);
        this.pfRulesTable.setRowSelectionAllowed(true);
        this.pfRulesTable.getSelectionModel().setSelectionMode(0);
        this.pfRulesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FirewallPanel.this.pfRulesDel.setEnabled(!FirewallPanel.this.pfRulesTable.getSelectionModel().isSelectionEmpty());
            }
        });
        this.v2tov4pfMappedTable = new V2ToV4MappedProductTable(OESISSupportV2toV4.V4_FW_TYPE, this.support);
        this.v2tov4pfMappedTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                FirewallPanel.this.adjustV2toV4mappedContext();
            }
        });
        this.mappingStatusBorder = BorderFactory.createLineBorder(Color.RED, 3);
        this.pfMappingStatusLabel = new JLabel("");
        this.pfMappingStatusLabel.setMaximumSize(new Dimension(250, 30));
        this.pfMappingStatusLabel.setBackground(Color.WHITE);
        this.pfMappingStatusLabel.setBorder(this.mappingStatusBorder);
        this.updatedMappingStatus();
        this.v4pfActionCombo = new ComboField(new String[0], "", "");
        this.v4pfActionCombo.setLabels("Firewall Action: ", "");
        this.pfCaveat.setVisible(false);
        if (null != string) {
            this.populateWidgetsUsingInputString(string);
        }
        this.adjustV2toV4mappedContext();
        this.setLayout(new BorderLayout());
        this.add(Util.arrange(this.addConfigPanel(), 10, false));
    }

    public void populateWidgetsUsingInputString(String string) {
        String string2;
        Data data = new Data(string, this.osSuffix);
        this.v2pfTable.populateView(data);
        this.adjustPFContext();
        this.pfActionCombo.removeAllItems();
        this.pfActionCombo.addItem("None");
        this.pfActionCombo.addItem("Force Enable");
        this.pfActionCombo.addItem("Force Disable");
        if (data.get("pf_action") != null) {
            this.pfActionCombo.setSelectedItem(data.get("pf_action"));
        }
        int n = 0;
        while ((string2 = data.get("pf_rule" + n)) != null) {
            this.pfRulesList.add(string2);
            Object[] objectArray = FirewallPanel.makeRow(string2);
            this.pfRulesModel.addRow(objectArray);
            ++n;
        }
    }

    private Component[][] addConfigPanel() {
        return new Component[][]{{Util.createLine(new Component[]{Util.arrange(this.createPFgroup(), 6)}, 5)}, {Util.createLine(new Component[]{Util.arrange(this.createV2toV4Mappedgroup(), 6)}, 5, "Mapped Rules")}};
    }

    private Component[][] createPFgroup() {
        Box box = Util.createLine(new Component[]{Util.createJScrollPane(this.v2pfTable, 110, 700), Util.column(new JButton[]{this.v2pfTable.getDeleteButton(), this.v2pfTable.getSelectiveMapButton(), this.v2pfTable.getAllAtOnceMapButton()}, false, 0)}, 6);
        Box box2 = Util.createLine(new Component[]{Util.H(10), Util.createJScrollPane(this.pfRulesTable, 80, 300), Util.column(new JButton[]{this.pfRulesDel}, false, 0)}, 6);
        return new Component[][]{{Util.H(5), this.migtext}, {box}, {Util.H(10), this.pfActionCombo}, {box2, this.pfRulesWarning}};
    }

    private Component[][] createV2toV4Mappedgroup() {
        Box box = Util.createLine(new Component[]{Util.createJScrollPane(this.v2tov4pfMappedTable, 140, 800), Util.column(new JButton[]{this.v2tov4pfMappedTable.getDeleteButton()}, false, 0)}, 6);
        return new Component[][]{{box}, {Util.H(570), this.pfMappingStatusLabel}, {Util.H(10), this.v4pfActionCombo, Util.H(10), this.pfCaveat}, {this.pfWarning}};
    }

    private void adjustPFContext() {
        this.pfActionCombo.setEnabled(this.v2pfTable.getRowCount() > 0);
        if (this.v2pfTable.getRowCount() <= 0 && this.pfRulesTable.getRowCount() > 0) {
            for (int i = this.pfRulesTable.getRowCount() - 1; i >= 0; --i) {
                this.pfRulesList.remove(i);
                this.pfRulesModel.removeRow(i);
            }
        }
        this.pfRulesAdd.setEnabled(false);
        this.pfRulesDel.setEnabled(false);
        if (this.pfRulesTable.getRowCount() > 0) {
            this.pfRulesEdit.setEnabled(true);
            this.pfRulesDel.setEnabled(true);
            this.pfRulesTable.setEnabled(true);
        }
        this.pfActionCombo.setEnabled(false);
        this.updatedMappingStatus();
    }

    private void adjustV2toV4mappedContext() {
        int n = this.v2tov4pfMappedTable.getNumberOfFWProductSupportEnable();
        int n2 = this.v2tov4pfMappedTable.getNumberOfFWProductSupportDisable();
        boolean bl = n > 0;
        boolean bl2 = n2 > 0;
        this.v4pfActionCombo.setEnabled(this.v2tov4pfMappedTable.getRowCount() > 0);
        this.v4pfActionCombo.removeAllItems();
        this.v4pfActionCombo.addItem("None");
        if (bl) {
            this.v4pfActionCombo.addItem("Force Enable");
        }
        if (bl2) {
            this.v4pfActionCombo.addItem("Force Disable");
        }
        this.pfCaveat.setVisible(false);
        if (bl && n != this.v2tov4pfMappedTable.getRowCount() || bl2 && n2 != this.v2tov4pfMappedTable.getRowCount()) {
            this.pfCaveat.setVisible(true);
        }
        this.pfWarning.setVisible(this.v2tov4pfMappedTable.getRowCount() > 0);
        this.updatedMappingStatus();
    }

    private static boolean isValidDays(JTextField jTextField) {
        if (!jTextField.isEnabled()) {
            return true;
        }
        String string = jTextField.getText().trim();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n != 0;
    }

    public boolean isUserInputValid() {
        return true;
    }

    public String toString() {
        String string = this.pendingV2RemediationData();
        String string2 = this.migratedV4RemediationData();
        if (string2.length() > 0 && !string2.endsWith(";") && string.length() > 0) {
            string2 = string2 + ";";
        }
        string2 = string2 + string;
        return string2;
    }

    private String migratedV4RemediationData() {
        if (this.v2tov4pfMappedTable.getRowCount() <= 0) {
            return this.existingV4pfData.toString();
        }
        Data data = new Data(this.osSuffix);
        this.v2tov4pfMappedTable.populateModel(data);
        if (this.v4pfActionCombo.isEnabled()) {
            data.put("pfw_action", this.v4pfActionCombo.getSelectedString());
        }
        this.existingV4pfData.merge(data);
        return this.existingV4pfData.toString();
    }

    private String pendingV2RemediationData() {
        if (this.v2pfTable.getRowCount() <= 0) {
            return "";
        }
        Data data = new Data(this.osSuffix);
        this.v2pfTable.populateModel(data);
        if (null != this.pfActionCombo.getSelectedString() && this.pfActionCombo.getSelectedString().length() > 0) {
            data.put("pf_action", this.pfActionCombo.getSelectedString());
        }
        if (this.pfRulesTable.getRowCount() > 0) {
            for (int i = 0; i < this.pfRulesList.size(); ++i) {
                data.put("pf_rule" + i, (String)this.pfRulesList.get(i));
            }
        }
        return data.toString();
    }

    public void selectedV2Products(OESISSupportV2toV4.Product[] productArray) {
        if (null != productArray && productArray.length > 0) {
            this.showMappingSelection(productArray);
        }
    }

    private void showMappingSelection(OESISSupportV2toV4.Product[] productArray) {
        Vector vector = this.support.getMatchingV4ProductsAllAtOnce(this.osSignature, OESISSupportV2toV4.V4_FW_TYPE, productArray);
        MappingSelectionPanel mappingSelectionPanel = new MappingSelectionPanel(OESISSupportV2toV4.V2_FW_TYPE, OESISSupportV2toV4.V4_FW_TYPE, this.osSignature, vector, this.support);
        if (mappingSelectionPanel.showDialog(this)) {
            Vector vector2 = mappingSelectionPanel.getMappedItems();
            this.v2tov4pfMappedTable.addMappedItems(vector2);
            this.v2pfTable.removedMappedItems(vector2);
        }
    }

    private void updatedMappingStatus() {
        int n = 0;
        int n2 = 0;
        if (null != this.v2pfTable) {
            n = this.v2pfTable.getInitialTotalCount();
            n2 = n - this.v2pfTable.getRowCount();
            if (n > 0 && this.v2pfTable.manuallyDeletedProductCount() > 0) {
                n2 -= this.v2pfTable.manuallyDeletedProductCount();
            }
        }
        this.pfMappingStatusLabel.setText(" Total Mapped AEA Policies:  " + n2 + " out of " + n + "  ");
        this.pfMappingStatusLabel.setOpaque(true);
    }

    private static String[] makeRow(String string) {
        String[] stringArray = CSVParser.parseLine(string);
        String[] stringArray2 = new String[1];
        if (appType.equals(stringArray[1])) {
            stringArray2[0] = stringArray[0] + " " + stringArray[1] + " " + stringArray[2];
        } else if (portType.equals(stringArray[1])) {
            stringArray2[0] = stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3];
        }
        return stringArray2;
    }

    private static class Dialog_FirewallRule
    extends JPanel {
        boolean ok;
        JDialog dialog;
        JButton okButton;
        JButton cancelButton;
        ComboField ruleCombo = new ComboField(ruleComboOptions, "Rule:", 0);
        TextField applicationNameText;
        TextField applicationFullnameText;
        ComboField portProtocolCombo;
        TextField portPortText;

        public Dialog_FirewallRule(String string) {
            this.ruleCombo.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog_FirewallRule this$0;
                {
                    this.this$0 = dialog_FirewallRule;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.applyContext();
                }
            });
            this.applicationNameText = new TextField();
            this.applicationNameText.setLabel("Name:");
            this.applicationFullnameText = new TextField();
            this.applicationFullnameText.setLabel("Full Path:");
            this.portProtocolCombo = new ComboField(portProtocolComboOptions, "Protocol:", 0);
            this.portPortText = new TextField();
            this.portPortText.setLabel("Port:");
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog_FirewallRule this$0;
                {
                    this.this$0 = dialog_FirewallRule;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$0.checkFields()) {
                        this.this$0.ok = true;
                        this.this$0.dialog.setVisible(false);
                    }
                }
            });
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog_FirewallRule this$0;
                {
                    this.this$0 = dialog_FirewallRule;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.dialog.setVisible(false);
                }
            });
            if (null != string) {
                this.populateWidgetsUsingInputString(string);
            }
            this.applyContext();
            this.setLayout(new BorderLayout());
            this.add(Util.arrange(this.addConfigPanel()));
            this.add((Component)Util.makeOkCancel(this.okButton, this.cancelButton), "South");
        }

        private Component[][] addConfigPanel() {
            return new Component[][]{{this.ruleCombo}, {Util.createLine(new Component[]{Util.arrange(this.createAppGroup(), 10)}, 20, FirewallPanel.appType)}, {Util.createLine(new Component[]{Util.arrange(this.createPortGroup(), 10)}, 20, FirewallPanel.portType)}};
        }

        private Component[][] createPortGroup() {
            return new Component[][]{{this.portProtocolCombo, this.portPortText.setWidth(40)}};
        }

        private Component[][] createAppGroup() {
            return new Component[][]{{this.applicationNameText.setWidth(100)}, {this.applicationFullnameText.setWidth(150)}};
        }

        public void populateWidgetsUsingInputString(String string) {
            String[] stringArray = CSVParser.parseLine(string);
            if (FirewallPanel.appType.equals(stringArray[1])) {
                if (FirewallPanel.ALLOW.equals(stringArray[0])) {
                    this.ruleCombo.setSelectedItem(ruleComboOptions[0]);
                } else if (FirewallPanel.BLOCK.equals(stringArray[0])) {
                    this.ruleCombo.setSelectedItem(ruleComboOptions[1]);
                }
                this.applicationNameText.setText(stringArray[2]);
                this.applicationFullnameText.setText(stringArray[3]);
            } else if (FirewallPanel.portType.equals(stringArray[1])) {
                if (FirewallPanel.ALLOW.equals(stringArray[0])) {
                    this.ruleCombo.setSelectedItem(ruleComboOptions[2]);
                } else if (FirewallPanel.BLOCK.equals(stringArray[0])) {
                    this.ruleCombo.setSelectedItem(ruleComboOptions[3]);
                }
                this.portProtocolCombo.setSelectedItem(stringArray[2]);
                this.portPortText.setText(stringArray[3]);
            }
        }

        public boolean showDialog(Component component, String string) {
            this.ok = false;
            Frame frame = null;
            frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = FirewallPanel.class$("java.awt.Frame")) : class$java$awt$Frame, component);
            this.dialog = new JDialog(frame, true);
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add(this);
            this.dialog.pack();
            this.dialog.setTitle(string);
            Util.centerMe(this.dialog);
            this.dialog.setVisible(true);
            return this.ok;
        }

        public void applyContext() {
            boolean bl = this.ruleCombo.getSelectedString().indexOf(FirewallPanel.appType) != -1;
            boolean bl2 = this.ruleCombo.getSelectedString().indexOf(FirewallPanel.portType) != -1;
            this.applicationNameText.setEnabled(bl);
            this.applicationFullnameText.setEnabled(bl);
            this.portProtocolCombo.setEnabled(bl2);
            this.portPortText.setEnabled(bl2);
        }

        public String toString() {
            if (this.ruleCombo.getSelectedString().indexOf(FirewallPanel.appType) != -1) {
                String[] stringArray = new String[4];
                if (this.ruleCombo.getSelectedString().indexOf(FirewallPanel.ALLOW) != -1) {
                    stringArray[0] = FirewallPanel.ALLOW;
                } else if (this.ruleCombo.getSelectedString().indexOf(FirewallPanel.BLOCK) != -1) {
                    stringArray[0] = FirewallPanel.BLOCK;
                }
                stringArray[1] = FirewallPanel.appType;
                stringArray[2] = this.applicationNameText.getText();
                stringArray[3] = this.applicationFullnameText.getText();
                return CSVParser.writeLine(stringArray);
            }
            if (this.ruleCombo.getSelectedString().indexOf(FirewallPanel.portType) != -1) {
                String[] stringArray = new String[5];
                if (this.ruleCombo.getSelectedString().indexOf(FirewallPanel.ALLOW) != -1) {
                    stringArray[0] = FirewallPanel.ALLOW;
                } else if (this.ruleCombo.getSelectedString().indexOf(FirewallPanel.BLOCK) != -1) {
                    stringArray[0] = FirewallPanel.BLOCK;
                }
                stringArray[1] = FirewallPanel.portType;
                stringArray[2] = this.portProtocolCombo.getSelectedString();
                stringArray[3] = this.portPortText.getText();
                stringArray[4] = "";
                return CSVParser.writeLine(stringArray);
            }
            return null;
        }

        private static boolean checkInputString(String string, String string2) {
            if (string2.length() <= 0) {
                JOptionPane.showMessageDialog(null, string + " cannot be empty.", "Error", 0);
                return false;
            }
            if (string2.indexOf(39) != -1 || string2.indexOf(34) != -1 || string2.indexOf(44) != -1 || string2.indexOf(59) != -1 || string2.indexOf(61) != -1) {
                JOptionPane.showMessageDialog(null, string + "  contains an illegal characters.  It cannot contain ' \" , ; =", "Error", 0);
                return false;
            }
            return true;
        }

        public boolean checkIPAddress(String string, String string2) {
            if (!Pattern.matches("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(?:/(?:3[0-2]|[1-2][0-9]|[0-9]))?", string2)) {
                JOptionPane.showMessageDialog(null, string + "  contains an invalid IP address range", "Error", 0);
                return false;
            }
            return true;
        }

        public boolean checkFields() {
            if (this.ruleCombo.getSelectedString().indexOf(FirewallPanel.appType) != -1) {
                if (!Dialog_FirewallRule.checkInputString("Name", this.applicationNameText.getText())) {
                    return false;
                }
                if (!Dialog_FirewallRule.checkInputString("Fullname", this.applicationFullnameText.getText())) {
                    return false;
                }
            } else if (this.ruleCombo.getSelectedString().indexOf(FirewallPanel.portType) != -1) {
                if (!Dialog_FirewallRule.checkInputString(FirewallPanel.portType, this.portPortText.getText())) {
                    return false;
                }
                if (!Util.isIntString(this.portPortText.getText())) {
                    JOptionPane.showMessageDialog(null, "Port value is not a valid integer.", "Error", 0);
                    return false;
                }
                if (Integer.decode(this.portPortText.getText()) < 0 || Integer.decode(this.portPortText.getText()) > 65534) {
                    JOptionPane.showMessageDialog(null, "Port value is not a valid port number.", "Error", 0);
                    return false;
                }
            }
            return true;
        }
    }
}

