/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Data {
    public static final String WIN_OS_SUFFIX = "";
    public static final String MAC_OS_SUFFIX = ".mac";
    public static final String LINUX_OS_SUFFIX = ".linux";
    private static final String[] PREFIX = new String[]{"av_", "pf_", "as_", "am_", "pfw_"};
    public static final String COUNT = "count";
    public static final String ENFORCE = "enforce";
    public static final String VENDOR = "vendor";
    public static final String PRODUCT = "product";
    private Map attributes;
    private String osSuffix;

    private Data() {
    }

    public Data(String string) {
        this.osSuffix = string;
        this.attributes = new LinkedHashMap();
    }

    public Data(String string, String string2) {
        this.osSuffix = string2;
        this.attributes = new LinkedHashMap();
        this.parse(string);
    }

    public String get(String string) {
        string = string + this.osSuffix;
        return (String)this.attributes.get(string);
    }

    public void put(String string, String string2) {
        string = string + this.osSuffix;
        this.attributes.put(string, string2);
    }

    public void set(String string, boolean bl) {
        string = string + this.osSuffix;
        this.attributes.put(string, bl ? "1" : "0");
    }

    public boolean check(String string) {
        String string2 = (String)this.attributes.get(string = string + this.osSuffix);
        return string2 != null && string2.equals("1");
    }

    public String export() {
        String string = WIN_OS_SUFFIX;
        Iterator iterator = this.attributes.entrySet().iterator();
        for (int i = 0; i < this.attributes.size(); ++i) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (!WIN_OS_SUFFIX.equals(string)) {
                string = string + ";";
            }
            string = string + string2 + "=" + string3;
        }
        return string;
    }

    public void parse(String string) {
        if (string != null && string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n == -1 || n == string2.length()) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(++n);
                this.attributes.put(string3, string4);
            }
        }
    }

    public String toString() {
        return this.export();
    }

    public int getProductCount(int n) {
        String string = this.get(PREFIX[n] + COUNT);
        if (string == null) {
            return this.check(PREFIX[n] + ENFORCE) ? 1 : 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static String makeAttributeName(int n, String string, int n2) {
        if (n2 == 0) {
            return PREFIX[n] + string;
        }
        return PREFIX[n] + string + '.' + n2;
    }

    public static String makeEnforceAttributeName(int n) {
        return PREFIX[n] + ENFORCE;
    }

    public static String makeCountAttributeName(int n) {
        return PREFIX[n] + COUNT;
    }

    public static int ConvertToInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

