/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import com.cisco.secinspv2tov4migration.V4SelectionItem;
import com.cisco.secinspv2tov4migration.V4SelectionList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CheckedComboBox
extends JComboBox {
    private V4SelectionList v4SelectionList = null;
    private boolean bIgnoreAction = false;

    public CheckedComboBox() {
        this.setupRendererAndListener();
    }

    public CheckedComboBox(V4SelectionList v4SelectionList) {
        this.populateSelectionList(v4SelectionList);
        this.setupRendererAndListener();
    }

    public void resetSelectionList(V4SelectionList v4SelectionList) {
        this.bIgnoreAction = true;
        this.removeAllItems();
        this.populateSelectionList(v4SelectionList);
        this.bIgnoreAction = false;
    }

    public void populateSelectionList(V4SelectionList v4SelectionList) {
        this.v4SelectionList = v4SelectionList;
        Vector vector = v4SelectionList.getSelections();
        for (int i = 0; i < vector.size(); ++i) {
            V4SelectionItem v4SelectionItem = (V4SelectionItem)vector.get(i);
            this.addJComboCheckBox(v4SelectionItem.toString(), v4SelectionItem.isSelected());
        }
    }

    public V4SelectionList getV4SelectionList() {
        return this.v4SelectionList;
    }

    public void addJComboCheckBox(String string, boolean bl) {
        JCheckBox jCheckBox = new JCheckBox(string, bl);
        this.addItem(jCheckBox);
    }

    public boolean IsSelectedAt(int n) {
        if (n >= 0 && n < this.getItemCount()) {
            JCheckBox jCheckBox = (JCheckBox)this.getItemAt(n);
            return jCheckBox.isSelected();
        }
        return false;
    }

    private void setupRendererAndListener() {
        this.setRenderer(new ComboBoxRenderer());
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!CheckedComboBox.this.bIgnoreAction) {
                    CheckedComboBox.this.itemSelected();
                }
            }
        });
    }

    private void itemSelected() {
        if (this.getSelectedItem() instanceof JCheckBox) {
            JCheckBox jCheckBox;
            jCheckBox.setSelected(!(jCheckBox = (JCheckBox)this.getSelectedItem()).isSelected());
            V4SelectionItem v4SelectionItem = this.v4SelectionList.getAt(this.getSelectedIndex());
            v4SelectionItem.setSelected(jCheckBox.isSelected());
        }
    }

    class ComboBoxRenderer
    implements ListCellRenderer {
        private JLabel label;

        public ComboBoxRenderer() {
            CheckedComboBox.this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Component) {
                Component component = (Component)object;
                if (bl) {
                    component.setBackground(jList.getSelectionBackground());
                    component.setForeground(jList.getSelectionForeground());
                } else {
                    component.setBackground(jList.getBackground());
                    component.setForeground(jList.getForeground());
                }
                return component;
            }
            if (this.label == null) {
                this.label = new JLabel(null == object ? "" : object.toString());
            } else {
                this.label.setText(null == object ? "" : object.toString());
            }
            return this.label;
        }
    }
}

