/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.secinspv2tov4migration;

import com.cisco.secinspv2tov4migration.Data;
import com.cisco.secinspv2tov4migration.MappingSelectionPanel;
import com.cisco.secinspv2tov4migration.OESISSupportV2toV4;
import com.cisco.secinspv2tov4migration.Util;
import com.cisco.secinspv2tov4migration.V2AVASProductTable;
import com.cisco.secinspv2tov4migration.V2ProductSelectionNotifier;
import com.cisco.secinspv2tov4migration.V2ToV4MappedProductTable;
import com.cisco.secinspv2tov4migration.V4ConfigurationData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;

class AntiVirusSpywarePanel
extends JPanel
implements V2ProductSelectionNotifier {
    private static final String AV_FORCE_FS_PROTECTION = "Force File System Protection";
    private static final String AV_FORCE_DEF_UPDATE = "Force Virus Definitions Update";
    private static final String AS_FORCE_DEF_UPDATE = "Force Spyware Definitions Update";
    private static final String CAVEAT = " (Not all of the selected products support this feature)";
    private static final String AM_FORCE_DEF_UPDATE = "Force AntiMalware Definitions Update";
    private static final String AM_MIG_TEXT = "<html>The backed up Antivirus and Antispyware Advanced Endpoint Assessment policies are listed below.<br>These Antivirus and Antispyware products need to be mapped under Antimalware.</html>";
    JLabel migtext = new JLabel("<html>The backed up Antivirus and Antispyware Advanced Endpoint Assessment policies are listed below.<br>These Antivirus and Antispyware products need to be mapped under Antimalware.</html>");
    V2AVASProductTable v2AvAsTable;
    V2ToV4MappedProductTable av2amMappedTable;
    JCheckBox avFScheckbox;
    JCheckBox avDefcheckbox;
    JTextField avDeftext;
    JLabel avDeflabel1;
    JLabel avDeflabel2;
    JCheckBox asDefcheckbox;
    JTextField asDeftext;
    JLabel asDeflabel1;
    JLabel asDeflabel2;
    Border mappingStatusBorder;
    JLabel amMappingStatusLabel;
    JCheckBox amFScheckbox;
    JCheckBox amUpdateDefcheckbox;
    JTextField amUpdateDeftext;
    JLabel amUpdateDeflabel1;
    JLabel amUpdateDeflabel2;
    OESISSupportV2toV4 support;
    V4ConfigurationData existingV4amData;
    private String osSuffix;
    private String osSignature;

    AntiVirusSpywarePanel(String string, String string2, String string3, OESISSupportV2toV4 oESISSupportV2toV4) {
        this.support = oESISSupportV2toV4;
        this.osSuffix = string;
        this.osSignature = string2;
        this.installComponents(string3);
    }

    private void installComponents(String string) {
        this.existingV4amData = new V4ConfigurationData(string, this.osSuffix, OESISSupportV2toV4.V4_AM_TYPE);
        this.v2AvAsTable = new V2AVASProductTable(OESISSupportV2toV4.V2_AV_TYPE, this.support, this);
        this.v2AvAsTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                AntiVirusSpywarePanel.this.adjustV2_AVAS_Context();
            }
        });
        this.av2amMappedTable = new V2ToV4MappedProductTable(OESISSupportV2toV4.V4_AM_TYPE, this.support);
        this.av2amMappedTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                AntiVirusSpywarePanel.this.adjustV2toV4mappedAVContext();
            }
        });
        this.avFScheckbox = new JCheckBox(AV_FORCE_FS_PROTECTION);
        this.avDefcheckbox = new JCheckBox(AV_FORCE_DEF_UPDATE);
        this.avDefcheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntiVirusSpywarePanel.this.adjustV2_AVAS_Context();
            }
        });
        this.avDeftext = new JTextField(4);
        this.avDeftext.setPreferredSize(new Dimension(50, this.avDeftext.getPreferredSize().height));
        this.avDeftext.setMaximumSize(new Dimension(this.avDeftext.getPreferredSize().width, this.avDeftext.getPreferredSize().height));
        this.avDeftext.setName(this.avDefcheckbox.getText());
        this.avDeflabel1 = new JLabel("if not updated in last");
        this.avDeflabel2 = new JLabel("days");
        this.asDefcheckbox = new JCheckBox(AS_FORCE_DEF_UPDATE);
        this.asDefcheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntiVirusSpywarePanel.this.adjustV2_AVAS_Context();
            }
        });
        this.asDeftext = new JTextField(4);
        this.asDeftext.setPreferredSize(new Dimension(50, this.asDeftext.getPreferredSize().height));
        this.asDeftext.setMaximumSize(new Dimension(this.asDeftext.getPreferredSize().width, this.asDeftext.getPreferredSize().height));
        this.asDeftext.setName(this.asDefcheckbox.getText());
        this.asDeflabel1 = new JLabel("if not updated in last");
        this.asDeflabel2 = new JLabel("days");
        this.mappingStatusBorder = BorderFactory.createLineBorder(Color.RED, 3);
        this.amMappingStatusLabel = new JLabel("");
        this.amMappingStatusLabel.setMaximumSize(new Dimension(250, 30));
        this.amMappingStatusLabel.setBackground(Color.WHITE);
        this.amMappingStatusLabel.setBorder(this.mappingStatusBorder);
        this.updatedMappingStatus();
        this.amFScheckbox = new JCheckBox(AV_FORCE_FS_PROTECTION);
        this.amUpdateDefcheckbox = new JCheckBox(AM_FORCE_DEF_UPDATE);
        this.amUpdateDefcheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntiVirusSpywarePanel.this.adjustV2toV4mappedAVContext();
            }
        });
        this.amUpdateDeftext = new JTextField(4);
        this.amUpdateDeftext.setPreferredSize(new Dimension(50, this.amUpdateDeftext.getPreferredSize().height));
        this.amUpdateDeftext.setMaximumSize(new Dimension(this.amUpdateDeftext.getPreferredSize().width, this.amUpdateDeftext.getPreferredSize().height));
        this.amUpdateDeftext.setName(this.amUpdateDefcheckbox.getText());
        this.amUpdateDeflabel1 = new JLabel("if not updated in last");
        this.amUpdateDeflabel2 = new JLabel("days");
        if (null != string) {
            this.populateWidgetsUsingInputString(string);
        }
        this.adjustV2_AVAS_Context();
        this.adjustV2toV4mappedAVContext();
        this.setLayout(new BorderLayout());
        this.add(Util.arrange(this.addConfigPanel(), 10, false));
    }

    public void populateWidgetsUsingInputString(String string) {
        int n;
        Data data = new Data(string, this.osSuffix);
        this.v2AvAsTable.populateView(data);
        this.avFScheckbox.setSelected(data.check("av_fsprotect"));
        this.avDefcheckbox.setSelected(data.check("av_defupdate"));
        if (null != data.get("av_defupdate_days")) {
            this.avDeftext.setText(data.get("av_defupdate_days"));
        }
        this.asDefcheckbox.setSelected(data.check("as_defupdate"));
        if (null != data.get("as_defupdate_days")) {
            this.asDeftext.setText(data.get("as_defupdate_days"));
        }
        this.amFScheckbox.setSelected(this.existingV4amData.check("am_fsprotect"));
        this.amUpdateDefcheckbox.setSelected(this.existingV4amData.check("am_defupdate"));
        this.amUpdateDeftext.setText(this.existingV4amData.get("am_defupdate_days"));
        if (!this.amFScheckbox.isSelected()) {
            this.amFScheckbox.setSelected(data.check("av_fsprotect"));
        }
        if (!this.amUpdateDefcheckbox.isSelected()) {
            this.amUpdateDefcheckbox.setSelected(data.check("av_defupdate"));
        }
        int n2 = Data.ConvertToInt(this.avDeftext.getText());
        if (this.amUpdateDefcheckbox.isSelected() && n2 > 0 && (0 == (n = Data.ConvertToInt(this.amUpdateDeftext.getText())) || n2 < n)) {
            this.amUpdateDeftext.setText(this.avDeftext.getText());
        }
        n = Data.ConvertToInt(this.asDeftext.getText());
        if (this.asDefcheckbox.isSelected() && n > 0) {
            int n3;
            if (!this.amUpdateDefcheckbox.isSelected()) {
                this.amUpdateDefcheckbox.setSelected(true);
            }
            if (0 == (n3 = Data.ConvertToInt(this.amUpdateDeftext.getText())) || n < n3) {
                this.amUpdateDeftext.setText(this.asDeftext.getText());
            }
        }
    }

    private Component[][] addConfigPanel() {
        return new Component[][]{{Util.createLine(new Component[]{Util.arrange(this.createAVASgroup(), 6)}, 5)}, {Util.createLine(new Component[]{Util.arrange(this.createV2toV4Mappedgroup(), 6)}, 5, "Mapped Rules")}};
    }

    private Component[][] createAVASgroup() {
        Box box = Util.createLine(new Component[]{Util.createJScrollPane(this.v2AvAsTable, 140, 680), Util.column(new JButton[]{this.v2AvAsTable.getDeleteButton(), this.v2AvAsTable.getSelectiveMapButton(), this.v2AvAsTable.getAllAtOnceMapButton()}, false, 0)}, 6);
        return new Component[][]{{Util.H(5), this.migtext}, {box}, {Util.H(10), this.avFScheckbox}, {Util.H(10), this.avDefcheckbox, Util.H(60), this.asDefcheckbox}, {Util.H(30), this.avDeflabel1, this.avDeftext, this.avDeflabel2, Util.H(90), this.asDeflabel1, this.asDeftext, this.asDeflabel2}};
    }

    private Component[][] createV2toV4Mappedgroup() {
        Box box = Util.createLine(new Component[]{Util.createJScrollPane(this.av2amMappedTable, 140, 800), Util.column(new JButton[]{this.av2amMappedTable.getDeleteButton()}, false, 0)}, 6);
        return new Component[][]{{box}, {Util.H(570), this.amMappingStatusLabel}, {Util.H(10), this.amFScheckbox}, {Util.H(10), this.amUpdateDefcheckbox}, {Util.H(30), this.amUpdateDeflabel1, this.amUpdateDeftext, this.amUpdateDeflabel2}};
    }

    private void adjustV2_AVAS_Context() {
        this.avFScheckbox.setEnabled(false);
        this.avDefcheckbox.setEnabled(false);
        this.avDeftext.setEnabled(false);
        this.avDeflabel1.setEnabled(false);
        this.avDeflabel2.setEnabled(false);
        this.asDefcheckbox.setEnabled(false);
        this.asDeftext.setEnabled(false);
        this.asDeflabel1.setEnabled(false);
        this.asDeflabel2.setEnabled(false);
        this.updatedMappingStatus();
    }

    private void adjustV2toV4mappedAVContext() {
        int n = this.av2amMappedTable.getNumberOfAMProductSupportActiveProtection();
        int n2 = this.av2amMappedTable.getNumberOfAMProductSupportUpdateDefinition();
        String string = AV_FORCE_FS_PROTECTION;
        if (n != 0 && n != this.av2amMappedTable.getRowCount()) {
            string = string + CAVEAT;
        }
        this.amFScheckbox.setText(string);
        string = AM_FORCE_DEF_UPDATE;
        if (n2 != 0 && n2 != this.av2amMappedTable.getRowCount()) {
            string = string + CAVEAT;
        }
        this.amUpdateDefcheckbox.setText(string);
        if (this.amUpdateDefcheckbox.isSelected()) {
            this.amUpdateDeftext.setEnabled(true);
        } else {
            this.amUpdateDeftext.setEnabled(false);
        }
        this.updatedMappingStatus();
    }

    private static boolean isValidDays(JTextField jTextField) {
        if (!jTextField.isEnabled()) {
            return true;
        }
        String string = jTextField.getText().trim();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n != 0;
    }

    public boolean isUserInputValid() {
        String string = null;
        JComponent jComponent = null;
        if (this.amUpdateDefcheckbox.isSelected() && !AntiVirusSpywarePanel.isValidDays(this.amUpdateDeftext)) {
            jComponent = this.amUpdateDeftext;
        }
        if (null != jComponent) {
            jComponent.requestFocus();
            ((JTextComponent)jComponent).selectAll();
            string = jComponent.getName() + " does not have valid number of day(s).";
            JOptionPane.showMessageDialog(jComponent, string, "Error", 0);
            return false;
        }
        return true;
    }

    public String toString() {
        String string = this.pendingV2RemediationData();
        String string2 = this.migratedV4RemediationData();
        if (string2.length() > 0 && !string2.endsWith(";") && string.length() > 0) {
            string2 = string2 + ";";
        }
        string2 = string2 + string;
        return string2;
    }

    private String migratedV4RemediationData() {
        if (this.av2amMappedTable.getRowCount() <= 0) {
            return this.existingV4amData.toString();
        }
        Data data = new Data(this.osSuffix);
        this.av2amMappedTable.populateModel(data);
        if (this.amFScheckbox.isEnabled()) {
            data.set("am_fsprotect", this.amFScheckbox.isSelected());
        }
        if (this.amUpdateDefcheckbox.isEnabled()) {
            data.set("am_defupdate", this.amUpdateDefcheckbox.isSelected());
            if (this.amUpdateDefcheckbox.isSelected() && this.amUpdateDeftext.getText().length() > 0) {
                data.put("am_defupdate_days", this.amUpdateDeftext.getText());
            }
        }
        this.existingV4amData.merge(data);
        return this.existingV4amData.toString();
    }

    private String pendingV2RemediationData() {
        if (this.v2AvAsTable.getRowCount() <= 0) {
            return "";
        }
        Data data = new Data(this.osSuffix);
        this.v2AvAsTable.populateModel(data);
        if (this.v2AvAsTable.numberOfAVinModel() > 0) {
            data.set("av_fsprotect", this.avFScheckbox.isSelected());
            if (this.avDefcheckbox.isSelected()) {
                data.set("av_defupdate", this.avDefcheckbox.isSelected());
                if (this.avDeftext.getText().length() > 0) {
                    data.put("av_defupdate_days", this.avDeftext.getText());
                }
            }
        }
        if (this.v2AvAsTable.numberOfASinModel() > 0 && this.asDefcheckbox.isSelected()) {
            this.asDefcheckbox.setSelected(data.check("as_defupdate"));
            if (this.asDeftext.getText().length() > 0) {
                data.put("as_defupdate_days", this.asDeftext.getText());
            }
        }
        return data.toString();
    }

    public void selectedV2Products(OESISSupportV2toV4.Product[] productArray) {
        if (null != productArray && productArray.length > 0) {
            this.showMappingSelection(productArray);
        }
    }

    private void showMappingSelection(OESISSupportV2toV4.Product[] productArray) {
        Vector vector = this.support.getMatchingV4ProductsAllAtOnce(this.osSignature, OESISSupportV2toV4.V4_AM_TYPE, productArray);
        MappingSelectionPanel mappingSelectionPanel = new MappingSelectionPanel(OESISSupportV2toV4.V2_AV_TYPE, OESISSupportV2toV4.V4_AM_TYPE, this.osSignature, vector, this.support);
        if (mappingSelectionPanel.showDialog(this)) {
            Vector vector2 = mappingSelectionPanel.getMappedItems();
            this.av2amMappedTable.addMappedItems(vector2);
            this.v2AvAsTable.removedMappedItems(vector2);
        }
    }

    private void updatedMappingStatus() {
        int n = 0;
        int n2 = 0;
        if (null != this.v2AvAsTable) {
            n = this.v2AvAsTable.getInitialTotalCount();
            n2 = n - this.v2AvAsTable.getRowCount();
            if (n > 0 && this.v2AvAsTable.manuallyDeletedProductCount() > 0) {
                n2 -= this.v2AvAsTable.manuallyDeletedProductCount();
            }
        }
        this.amMappingStatusLabel.setText(" Total Mapped AEA Policies:  " + n2 + " out of " + n + "  ");
        this.amMappingStatusLabel.setOpaque(true);
    }
}

