/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.csdm;

import com.cisco.csdm.ComboField;
import com.cisco.csdm.OESISSupport;
import com.cisco.csdm.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

class SecinspPanel
extends JPanel {
    private static final String COUNT = "count";
    private static final String ENFORCE = "enforce";
    private static final String VENDOR = "vendor";
    private static final String PRODUCT = "product";
    private static final String[] PREFIX = new String[]{"av_", "pf_", "as_", "am_", "pfw_"};
    V2ConfigurationData v2AvAsFwConfigData;
    private static final String AM_FORCE_FS_PROTECTION = "Force File System Protection";
    private static final String AM_FORCE_DEF_UPDATE = "Force AntiMalware Definitions Update";
    private static final String CAVEAT = " (Not all of the selected products support this feature)";
    ProductTable amTable;
    ProductTable pfTable;
    JCheckBox amFScheckbox;
    JCheckBox amVDefcheckbox;
    JTextField amVDeftext;
    JLabel amVDeflabel1;
    JLabel amVDeflabel2;
    private static final String PF_WARN = "<HTML><b><font COLOR=RED>The action remains effective on client device even after VPN session ends, please use them with discretion.</font></b></HTML>";
    JLabel pfWarning = new JLabel("<HTML><b><font COLOR=RED>The action remains effective on client device even after VPN session ends, please use them with discretion.</font></b></HTML>");
    ComboField pfActionCombo;
    JLabel fwCaveatLabel = new JLabel(" (Not all of the selected products support this feature)");
    OESISSupport support;
    private String osSuffix;
    private String osSignature;
    static /* synthetic */ Class class$java$lang$Object;

    SecinspPanel(String string, String string2, String string3, OESISSupport oESISSupport) {
        this.support = oESISSupport;
        this.osSuffix = string;
        this.osSignature = string2;
        this.installComponents(string3);
        this.setPreferredSize(new Dimension(900, 620));
    }

    private void installComponents(String string) {
        this.v2AvAsFwConfigData = new V2ConfigurationData(string);
        this.amTable = new AMProductTable(this.support, this.osSignature);
        this.amTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                SecinspPanel.this.adjustAMContext();
            }
        });
        this.pfTable = new FWProductTable(this.support, this.osSignature);
        this.pfTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                SecinspPanel.this.adjustPFContext();
            }
        });
        this.amFScheckbox = new JCheckBox(AM_FORCE_FS_PROTECTION);
        this.amVDefcheckbox = new JCheckBox(AM_FORCE_DEF_UPDATE);
        this.amVDefcheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecinspPanel.this.adjustAMContext();
            }
        });
        this.amVDeftext = new JTextField(4);
        this.amVDeftext.setPreferredSize(new Dimension(50, this.amVDeftext.getPreferredSize().height));
        this.amVDeftext.setMaximumSize(new Dimension(this.amVDeftext.getPreferredSize().width, this.amVDeftext.getPreferredSize().height));
        this.amVDeftext.setName(this.amVDefcheckbox.getText());
        this.amVDeflabel1 = new JLabel("if not updated in last");
        this.amVDeflabel2 = new JLabel("days");
        this.pfActionCombo = new ComboField(new String[0], "", "");
        this.pfActionCombo.setLabels("Firewall Action: ", "");
        this.fwCaveatLabel.setVisible(false);
        if (null != string) {
            this.populateWidgetsUsingInputString(string);
        }
        this.adjustAMContext();
        this.setLayout(new BorderLayout());
        this.add(Util.arrange((Component[][])this.addConfigPanel(), (int)10, (boolean)false));
    }

    public void populateWidgetsUsingInputString(String string) {
        Data data = new Data(string);
        this.amTable.populateView(data);
        this.amFScheckbox.setSelected(data.check("am_fsprotect"));
        this.amVDefcheckbox.setSelected(data.check("am_defupdate"));
        this.amVDeftext.setText(data.get("am_defupdate_days"));
        this.pfTable.populateView(data);
        this.adjustPFContext();
        if (data.get("pfw_action") != null) {
            this.pfActionCombo.setSelectedItem((Object)data.get("pfw_action"));
        }
    }

    private Component[][] addConfigPanel() {
        return new Component[][]{{Util.createLine((Component[])new Component[]{Util.arrange((Component[][])this.createAMgroup(), (int)6)}, (int)5, (String)"AntiMalware")}, {Util.createLine((Component[])new Component[]{Util.arrange((Component[][])this.createPFgroup(), (int)6)}, (int)5, (String)"Personal Firewall")}};
    }

    private Component[][] createAMgroup() {
        Box box = Util.createLine((Component[])new Component[]{Util.createJScrollPane((Component)this.amTable, (int)160, (int)700), Util.column((JButton[])new JButton[]{this.amTable.getAddButton(), this.amTable.getDeleteButton()}, (boolean)false, (int)0)}, (int)6);
        return new Component[][]{{box}, {Util.H((int)10), this.amFScheckbox}, {Util.H((int)10), this.amVDefcheckbox}, {Util.H((int)30), this.amVDeflabel1, this.amVDeftext, this.amVDeflabel2}};
    }

    private Component[][] createPFgroup() {
        Box box = Util.createLine((Component[])new Component[]{Util.createJScrollPane((Component)this.pfTable, (int)160, (int)700), Util.column((JButton[])new JButton[]{this.pfTable.getAddButton(), this.pfTable.getDeleteButton()}, (boolean)false, (int)0)}, (int)6);
        return new Component[][]{{box}, {Util.H((int)10), this.pfActionCombo, Util.H((int)10), this.fwCaveatLabel}, {this.pfWarning}};
    }

    private void adjustAMContext() {
        int n = this.amTable.getCapableProducts(OESISSupport._ActiveProtect).length;
        int n2 = this.amTable.getCapableProducts(OESISSupport._UpdateDefs).length;
        this.amFScheckbox.setEnabled(n != 0);
        this.amVDefcheckbox.setEnabled(n2 != 0);
        boolean bl = this.amVDefcheckbox.isEnabled() && this.amVDefcheckbox.isSelected();
        this.amVDeftext.setEnabled(bl);
        this.amVDeflabel1.setEnabled(bl);
        this.amVDeflabel2.setEnabled(bl);
        String string = AM_FORCE_FS_PROTECTION;
        if (n != 0 && n != this.amTable.getRowCount()) {
            string = string + CAVEAT;
        }
        this.amFScheckbox.setText(string);
        string = AM_FORCE_DEF_UPDATE;
        if (n2 != 0 && n2 != this.amTable.getRowCount()) {
            string = string + CAVEAT;
        }
        this.amVDefcheckbox.setText(string);
    }

    private void adjustPFContext() {
        int n = this.pfTable.getCapableProducts(OESISSupport._FirewallOn).length;
        int n2 = this.pfTable.getCapableProducts(OESISSupport._FirewallOff).length;
        boolean bl = n > 0;
        boolean bl2 = n2 > 0;
        this.pfActionCombo.setEnabled(this.pfTable.getRowCount() > 0);
        this.pfActionCombo.removeAllItems();
        this.pfActionCombo.addItem((Object)"None");
        if (bl) {
            this.pfActionCombo.addItem((Object)"Force Enable");
        }
        if (bl2) {
            this.pfActionCombo.addItem((Object)"Force Disable");
        }
        this.fwCaveatLabel.setVisible(false);
        if (bl && n != this.pfTable.getRowCount() || bl2 && n2 != this.pfTable.getRowCount()) {
            this.fwCaveatLabel.setVisible(true);
        }
    }

    private static int ConvertToInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static boolean isValidDays(JTextField jTextField) {
        if (!jTextField.isEnabled()) {
            return true;
        }
        String string = jTextField.getText().trim();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n != 0;
    }

    boolean isUserInputValid() {
        String string = null;
        JTextField jTextField = null;
        if (!SecinspPanel.isValidDays(this.amVDeftext)) {
            jTextField = this.amVDeftext;
        }
        if (jTextField != null) {
            jTextField.requestFocus();
            jTextField.selectAll();
            string = jTextField.getName() + " does not have valid number of day(s).";
            JOptionPane.showMessageDialog(jTextField, string, "Error", 0);
            return false;
        }
        return true;
    }

    public String toString() {
        Data data = new Data();
        this.amTable.populateModel(data);
        if (this.amFScheckbox.isEnabled()) {
            data.set("am_fsprotect", this.amFScheckbox.isSelected());
        }
        if (this.amVDefcheckbox.isEnabled()) {
            data.set("am_defupdate", this.amVDefcheckbox.isSelected());
        }
        if (this.amVDeftext.isEnabled() && null != this.amVDeftext.getText() && this.amVDeftext.getText().length() > 0) {
            data.put("am_defupdate_days", this.amVDeftext.getText());
        }
        this.pfTable.populateModel(data);
        if (this.pfActionCombo.isEnabled()) {
            data.put("pfw_action", this.pfActionCombo.getSelectedString());
        }
        String string = data.export();
        String string2 = this.v2AvAsFwConfigData.toString();
        if (string.length() > 0 && !string.endsWith(";") && string2.length() > 0) {
            string = string + ";";
        }
        string = string + string2;
        return string;
    }

    private static int getProductCount(int n, Data data) {
        String string = data.get(PREFIX[n] + COUNT);
        if (null == string) {
            return data.check(PREFIX[n] + ENFORCE) ? 1 : 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static String makeAttributeName(int n, String string, int n2) {
        if (n2 == 0) {
            return PREFIX[n] + string;
        }
        return PREFIX[n] + string + '.' + n2;
    }

    private class V2ConfigurationData {
        private Data avData;
        private Data asData;
        private Data v2pfData;

        public V2ConfigurationData(String string) {
            this.avData = new Data();
            this.asData = new Data();
            this.v2pfData = new Data();
            this.load(string);
        }

        private void load(String string) {
            Data data = new Data(string);
            this.loadAVData(data);
            this.loadASData(data);
            this.loadV2FirewallData(data);
        }

        private void loadAVData(Data data) {
            OESISSupport cfr_ignored_0 = SecinspPanel.this.support;
            int n = this.loadDataIntoTarget(data, OESISSupport.V2_AV_TYPE, this.avData);
            if (n > 0) {
                this.avData.set("av_fsprotect", data.check("av_fsprotect"));
                this.avData.set("av_defupdate", data.check("av_defupdate"));
                if (null != data.get("av_defupdate_days")) {
                    this.avData.put("av_defupdate_days", data.get("av_defupdate_days"));
                }
            }
        }

        private void loadASData(Data data) {
            OESISSupport cfr_ignored_0 = SecinspPanel.this.support;
            int n = this.loadDataIntoTarget(data, OESISSupport.V2_AS_TYPE, this.asData);
            if (n > 0) {
                this.asData.set("as_defupdate", data.check("as_defupdate"));
                if (null != data.get("as_defupdate_days")) {
                    this.asData.put("as_defupdate_days", data.get("as_defupdate_days"));
                }
            }
        }

        private void loadV2FirewallData(Data data) {
            OESISSupport cfr_ignored_0 = SecinspPanel.this.support;
            int n = this.loadDataIntoTarget(data, OESISSupport.V2_FW_TYPE, this.v2pfData);
            if (n > 0) {
                String string;
                if (null != data.get("pf_action")) {
                    this.v2pfData.put("pf_action", data.get("pf_action"));
                }
                int n2 = 0;
                while ((string = data.get("pf_rule" + n2)) != null) {
                    this.v2pfData.put("pf_rule" + n2, string);
                    ++n2;
                }
            }
        }

        private int loadDataIntoTarget(Data data, int n, Data data2) {
            int n2 = SecinspPanel.getProductCount(n, data);
            if (n2 == 0) {
                return 0;
            }
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                String string = data.get(SecinspPanel.makeAttributeName(n, SecinspPanel.VENDOR, i));
                String string2 = data.get(SecinspPanel.makeAttributeName(n, SecinspPanel.PRODUCT, i));
                if (null == string || null == string2 || string.length() <= 0 || string2.length() <= 0) continue;
                if (0 == n3) {
                    data2.set(PREFIX[n] + SecinspPanel.ENFORCE, n2 > 0);
                    data2.put(PREFIX[n] + SecinspPanel.COUNT, "" + n2);
                }
                data2.put(SecinspPanel.makeAttributeName(n, SecinspPanel.VENDOR, i), string);
                data2.put(SecinspPanel.makeAttributeName(n, SecinspPanel.PRODUCT, i), string2);
                ++n3;
            }
            if (n3 > 0) {
                data2.set(PREFIX[n] + SecinspPanel.ENFORCE, n3 > 0);
                data2.put(PREFIX[n] + SecinspPanel.COUNT, "" + n3);
            }
            return n3;
        }

        public String toString() {
            String string = this.avData.toString();
            if (string.length() > 0 && !string.endsWith(";") && this.asData.toString().length() > 0) {
                string = string + ';';
            }
            if ((string = string + this.asData.toString()).length() > 0 && !string.endsWith(";") && this.v2pfData.toString().length() > 0) {
                string = string + ';';
            }
            string = string + this.v2pfData.toString();
            return string;
        }
    }

    private static abstract class ProductTable
    extends JTable {
        private OESISSupport support;
        private String osSignature;
        private int type;
        private JButton addButton;
        private JButton deleteButton;

        ProductTable(int n, OESISSupport oESISSupport, String string, int n2) {
            this.type = n;
            this.support = oESISSupport;
            this.osSignature = string;
            this.setRowSelectionAllowed(true);
            this.getSelectionModel().setSelectionMode(2);
            this.getTableHeader().setReorderingAllowed(false);
            this.setModel(new _TableModel(n2));
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(this){
                private final /* synthetic */ ProductTable this$0;
                {
                    this.this$0 = productTable;
                }

                public String getToolTipText() {
                    String string = this.getText();
                    if (string != null && string.length() > 0) {
                        return string;
                    }
                    return null;
                }
            };
            this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = SecinspPanel.class$("java.lang.Object")) : class$java$lang$Object, defaultTableCellRenderer);
        }

        ProductTable(int n, OESISSupport oESISSupport, String string) {
            this(n, oESISSupport, string, 3);
        }

        JButton getAddButton() {
            if (this.addButton == null) {
                this.createButtons();
            }
            return this.addButton;
        }

        JButton getDeleteButton() {
            if (this.deleteButton == null) {
                this.createButtons();
            }
            return this.deleteButton;
        }

        void populateView(Data data) {
            int n = SecinspPanel.getProductCount(this.type, data);
            if (n == 0) {
                return;
            }
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = this.getVendorProduct(data, i);
                if (objectArray == null) continue;
                OESISSupport.Vendor vendor = (OESISSupport.Vendor)objectArray[0];
                OESISSupport.Product product = (OESISSupport.Product)objectArray[1];
                if (!this.existInTable(vendor, product)) {
                    defaultTableModel.addRow(objectArray);
                    continue;
                }
                System.out.println("Product " + product.getName() + " from vendor," + vendor.getName() + ", already exists in table");
            }
        }

        void populateModel(Data data) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            int n = defaultTableModel.getRowCount();
            data.set(PREFIX[this.type] + SecinspPanel.ENFORCE, n > 0);
            data.put(PREFIX[this.type] + SecinspPanel.COUNT, "" + n);
            for (int i = 0; i < n; ++i) {
                OESISSupport.Vendor vendor = (OESISSupport.Vendor)defaultTableModel.getValueAt(i, 0);
                OESISSupport.Product product = (OESISSupport.Product)defaultTableModel.getValueAt(i, 1);
                String string = this.getOPSWATProductID(vendor, product);
                data.put(SecinspPanel.makeAttributeName(this.type, SecinspPanel.VENDOR, i), string);
                data.put(SecinspPanel.makeAttributeName(this.type, SecinspPanel.PRODUCT, i), product.getID());
            }
        }

        private boolean existInTable(OESISSupport.Vendor vendor, OESISSupport.Product product) {
            if (null == vendor || null == product) {
                return false;
            }
            boolean bl = false;
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                OESISSupport.Vendor vendor2 = (OESISSupport.Vendor)defaultTableModel.getValueAt(i, 0);
                OESISSupport.Product product2 = (OESISSupport.Product)defaultTableModel.getValueAt(i, 1);
                if (!vendor.equals((Object)vendor2) || !product.equals((Object)product2)) continue;
                bl = true;
                break;
            }
            return bl;
        }

        boolean isCapable(Object object) {
            return this.getCapableProducts(object).length != 0;
        }

        OESISSupport.Product[] getCapableProducts(Object object) {
            ArrayList<OESISSupport.Product> arrayList = new ArrayList<OESISSupport.Product>();
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                OESISSupport.Product product = (OESISSupport.Product)defaultTableModel.getValueAt(i, 1);
                if (!product.canFeature(object)) continue;
                arrayList.add(product);
            }
            OESISSupport.Product[] productArray = new OESISSupport.Product[arrayList.size()];
            arrayList.toArray(productArray);
            return productArray;
        }

        private void createButtons() {
            AbstractAction abstractAction = new AbstractAction(this, "Add..."){
                private final /* synthetic */ ProductTable this$0;
                {
                    this.this$0 = productTable;
                    super(string);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ProductTable.access$600(this.this$0);
                }
            };
            AbstractAction abstractAction2 = new AbstractAction(this, "Delete"){
                private final /* synthetic */ ProductTable this$0;
                {
                    this.this$0 = productTable;
                    super(string);
                    this.enabled = false;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ProductTable.access$700(this.this$0);
                }
            };
            this.addButton = new JButton(abstractAction);
            this.deleteButton = new JButton(abstractAction2);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(this, abstractAction2){
                private final /* synthetic */ Action val$deleteAction;
                private final /* synthetic */ ProductTable this$0;
                {
                    this.this$0 = productTable;
                    this.val$deleteAction = action;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    this.val$deleteAction.setEnabled(!this.this$0.getSelectionModel().isSelectionEmpty());
                }
            });
        }

        private void addProducts() {
            Object[][] objectArray = new ProductSelections().getSelections();
            if (objectArray == null) {
                return;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object[] objectArray2;
                DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
                objectArray2 = new Object[]{objectArray[i][0], objectArray[i][1], this.getSupportNote((OESISSupport.Product)objectArray2[1])};
                defaultTableModel.addRow(objectArray2);
            }
        }

        private void deleteProducts() {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                defaultTableModel.removeRow(i);
            }
        }

        protected abstract String getSupportNote(OESISSupport.Product var1);

        private Object[] getVendorProduct(Data data, int n) {
            Object[] objectArray = new Object[3];
            OESISSupport.Vendor[] vendorArray = this.getVendor4OpswatProductID(data.get(SecinspPanel.makeAttributeName(this.type, SecinspPanel.VENDOR, n)));
            OESISSupport.Product product = null;
            OESISSupport.Vendor vendor = null;
            if (vendorArray.length > 0) {
                product = this.getProductByID(vendorArray[0], data.get(SecinspPanel.makeAttributeName(this.type, SecinspPanel.PRODUCT, n)));
                if (product == null && vendorArray.length > 1) {
                    product = this.getProductByID(vendorArray[1], data.get(SecinspPanel.makeAttributeName(this.type, SecinspPanel.PRODUCT, n)));
                    vendor = vendorArray[1];
                } else {
                    vendor = vendorArray[0];
                }
            }
            if (null == product) {
                return null;
            }
            objectArray[0] = vendor;
            objectArray[1] = product;
            objectArray[2] = this.getSupportNote(product);
            return objectArray;
        }

        private OESISSupport.Vendor[] getVendor4OpswatProductID(String string) {
            if (null == string || string.length() == 0) {
                return null;
            }
            OESISSupport.Vendor[] vendorArray = this.getVendors4ThisOS(this.type);
            ArrayList<OESISSupport.Vendor> arrayList = new ArrayList<OESISSupport.Vendor>();
            for (int i = 0; i < vendorArray.length; ++i) {
                String[] stringArray = vendorArray[i].getProductIDs();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!stringArray[j].equals(string)) continue;
                    arrayList.add(vendorArray[i]);
                }
            }
            OESISSupport.Vendor[] vendorArray2 = new OESISSupport.Vendor[arrayList.size()];
            for (int i = 0; i < vendorArray2.length; ++i) {
                vendorArray2[i] = (OESISSupport.Vendor)arrayList.get(i);
            }
            return vendorArray2;
        }

        private String getOPSWATProductID(OESISSupport.Vendor vendor, OESISSupport.Product product) {
            String string = product.getName();
            String string2 = vendor.getName();
            String[] stringArray = vendor.getProductIDs();
            for (int i = 0; i < stringArray.length; ++i) {
                OESISSupport.Product[] productArray = this.support.getSubProducts(this.type, stringArray[i], string2);
                for (int j = 0; j < productArray.length; ++j) {
                    String string3 = productArray[j].getName();
                    String string4 = productArray[j].getVendor();
                    if (!string.equals(string3) || !string2.equals(string4)) continue;
                    return stringArray[i];
                }
            }
            return "";
        }

        private OESISSupport.Product getProductByID(OESISSupport.Vendor vendor, String string) {
            if (vendor == null || string == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Microsoft Windows Firewall|xP SP2", "Microsoft Windows Firewall|XP SP2+");
            OESISSupport.Product[] productArray = this.getProducts4ThisOS(vendor);
            for (int i = 0; i < productArray.length; ++i) {
                String string2 = productArray[i].getID();
                if (string.equals(string2)) {
                    return productArray[i];
                }
                if (!string2.equals(hashMap.get(string))) continue;
                return productArray[i];
            }
            System.out.println("CSDM: product \"" + string + "\" not found in OPSWAT database for vendor " + vendor.getName());
            return null;
        }

        private OESISSupport.Vendor[] getVendors4ThisOS(int n) {
            OESISSupport.Vendor[] vendorArray = this.support.getVendors(n);
            Vector<OESISSupport.Vendor> vector = new Vector<OESISSupport.Vendor>();
            for (int i = 0; i < vendorArray.length; ++i) {
                if (!this.hasProducts4ThisOS(vendorArray[i])) continue;
                vector.addElement(vendorArray[i]);
            }
            OESISSupport.Vendor[] vendorArray2 = new OESISSupport.Vendor[vector.size()];
            vector.toArray(vendorArray2);
            return vendorArray2;
        }

        private boolean hasProducts4ThisOS(OESISSupport.Vendor vendor) {
            return this.getProducts4ThisOS(vendor).length != 0;
        }

        private OESISSupport.Product[] getProducts4ThisOS(OESISSupport.Vendor vendor) {
            if (vendor == null) {
                return null;
            }
            String[] stringArray = vendor.getProductIDs();
            Vector<OESISSupport.Product> vector = new Vector<OESISSupport.Product>();
            for (int i = 0; i < stringArray.length; ++i) {
                OESISSupport.Product[] productArray = this.support.getSubProducts(this.type, stringArray[i], vendor.getName());
                for (int j = 0; j < productArray.length; ++j) {
                    if (!this.is4ThisOS(productArray[j]) || !productArray[j].getVendor().equals(vendor.getName())) continue;
                    vector.addElement(productArray[j]);
                }
            }
            OESISSupport.Product[] productArray = new OESISSupport.Product[vector.size()];
            vector.toArray(productArray);
            return productArray;
        }

        private boolean is4ThisOS(OESISSupport.Product product) {
            String string = product.getName();
            if (this.osSignature == null || this.osSignature.length() == 0) {
                return string.indexOf("(Mac)") == -1 && string.indexOf("(Linux)") == -1;
            }
            return string.indexOf(this.osSignature) != -1;
        }

        static /* synthetic */ void access$600(ProductTable productTable) {
            productTable.addProducts();
        }

        static /* synthetic */ void access$700(ProductTable productTable) {
            productTable.deleteProducts();
        }

        private class ProductSelections {
            private ProductTable table;

            private ProductSelections() {
                this.table = new ProductTable(this, ProductTable.this.type, ProductTable.this.support, ProductTable.this.osSignature, 2){
                    private final /* synthetic */ ProductSelections this$1;
                    {
                        this.this$1 = productSelections;
                        super(n, oESISSupport, string, n2);
                    }

                    protected String getSupportNote(OESISSupport.Product product) {
                        return "";
                    }
                };
            }

            Object[][] getSelections() {
                int n = JOptionPane.showConfirmDialog(ProductTable.this, this.createContentPane(), "Add Products", 2, -1);
                if (n == 0) {
                    return this._getSelections();
                }
                return null;
            }

            private Object[][] _getSelections() {
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
                for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                    if (!this.table.getSelectionModel().isSelectedIndex(i)) continue;
                    Object[] objectArray = new Object[]{defaultTableModel.getValueAt(i, 0), defaultTableModel.getValueAt(i, 1)};
                    arrayList.add(objectArray);
                }
                Object[][] objectArray = new Object[arrayList.size()][];
                arrayList.toArray((T[])objectArray);
                return objectArray;
            }

            private Container createContentPane() {
                JPanel jPanel = new JPanel(new BorderLayout());
                JScrollPane jScrollPane = new JScrollPane(this.table);
                jScrollPane.setPreferredSize(new Dimension(500, 400));
                jPanel.add((Component)new JLabel("You can select single or mutiple entries to add:"), "North");
                jPanel.add((Component)jScrollPane, "Center");
                this.populateProductChoices(this.table);
                return jPanel;
            }

            private void populateProductChoices(ProductTable productTable) {
                OESISSupport.Vendor[] vendorArray = ProductTable.this.getVendors4ThisOS(ProductTable.this.type);
                DefaultTableModel defaultTableModel = (DefaultTableModel)productTable.getModel();
                for (int i = 0; i < vendorArray.length; ++i) {
                    OESISSupport.Product[] productArray = ProductTable.this.getProducts4ThisOS(vendorArray[i]);
                    for (int j = 0; j < productArray.length; ++j) {
                        if (this.isSelected(vendorArray[i], productArray[j]) || !productArray[j].getVendor().equals(vendorArray[i].getName())) continue;
                        defaultTableModel.addRow(new Object[]{vendorArray[i], productArray[j]});
                    }
                }
            }

            private boolean isSelected(OESISSupport.Vendor vendor, OESISSupport.Product product) {
                DefaultTableModel defaultTableModel = (DefaultTableModel)ProductTable.this.getModel();
                for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                    if (vendor != defaultTableModel.getValueAt(i, 0) || product != defaultTableModel.getValueAt(i, 1)) continue;
                    return true;
                }
                return false;
            }
        }

        private class _TableModel
        extends FixedTableModel {
            _TableModel(int n) {
                super(0, n, new String[]{"Vendor", "Product", "Note"});
            }

            public void addRow(Object[] objectArray) {
                if (objectArray == null || objectArray[0] == null || objectArray[1] == null) {
                    return;
                }
                for (int i = 0; i < ProductTable.this.getModel().getRowCount(); ++i) {
                    if (this.compare(objectArray, i) >= 0) continue;
                    this.insertRow(i, objectArray);
                    return;
                }
                super.addRow(objectArray);
            }

            private int compare(Object[] objectArray, int n) {
                int n2 = objectArray[0].toString().compareToIgnoreCase(ProductTable.this.getModel().getValueAt(n, 0).toString());
                if (n2 == 0) {
                    n2 = objectArray[1].toString().compareToIgnoreCase(ProductTable.this.getModel().getValueAt(n, 1).toString());
                }
                return n2;
            }
        }
    }

    private static class FWProductTable
    extends ProductTable {
        private static final String NOTE = "Supports enable and disable feautures";

        FWProductTable(OESISSupport oESISSupport, String string) {
            super(OESISSupport.V4_FW_TYPE, oESISSupport, string);
        }

        protected String getSupportNote(OESISSupport.Product product) {
            boolean bl = product.canFeature((Object)OESISSupport._FirewallOn);
            boolean bl2 = product.canFeature((Object)OESISSupport._FirewallOff);
            boolean bl3 = bl && bl2;
            return bl3 ? NOTE : "";
        }
    }

    private static class AMProductTable
    extends ProductTable {
        private static final String NOTE = "Supports virus definition update";
        private static final String NOTE2 = " and file system protection";
        private static final String NOTE3 = "Supports file system protection";

        AMProductTable(OESISSupport oESISSupport, String string) {
            super(OESISSupport.V4_AM_TYPE, oESISSupport, string);
        }

        protected String getSupportNote(OESISSupport.Product product) {
            String string = "";
            if (product.canFeature((Object)OESISSupport._UpdateDefs)) {
                string = NOTE;
            }
            if (product.canFeature((Object)OESISSupport._ActiveProtect)) {
                string = string.length() != 0 ? string + NOTE2 : NOTE3;
            }
            return string;
        }
    }

    private static class FixedTableModel
    extends DefaultTableModel {
        private String[] columnNames;

        private FixedTableModel() {
        }

        public FixedTableModel(int n, int n2, String[] stringArray) {
            super(n, n2);
            this.columnNames = stringArray;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public boolean itemExists(String string, int n) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                try {
                    if (string.compareTo(this.getValueAt(i, n).toString()) != 0) continue;
                    return true;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private class Data {
        private Map attributes = new LinkedHashMap();

        public Data() {
        }

        public Data(String string) {
            this.parse(string);
        }

        public String get(String string) {
            string = string + SecinspPanel.this.osSuffix;
            return (String)this.attributes.get(string);
        }

        public void put(String string, String string2) {
            string = string + SecinspPanel.this.osSuffix;
            this.attributes.put(string, string2);
        }

        public void set(String string, boolean bl) {
            string = string + SecinspPanel.this.osSuffix;
            this.attributes.put(string, bl ? "1" : "0");
        }

        public boolean check(String string) {
            String string2 = (String)this.attributes.get(string = string + SecinspPanel.this.osSuffix);
            return string2 != null && string2.equals("1");
        }

        public String export() {
            String string = "";
            Iterator iterator = this.attributes.entrySet().iterator();
            for (int i = 0; i < this.attributes.size(); ++i) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                if (!"".equals(string)) {
                    string = string + ";";
                }
                string = string + string2 + "=" + string3;
            }
            return string;
        }

        public void parse(String string) {
            if (string != null && string.length() != 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    int n = string2.indexOf(61);
                    if (n == -1 || n == string2.length()) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(++n);
                    this.attributes.put(string3, string4);
                }
            }
        }

        public String toString() {
            return this.export();
        }
    }
}

