/**************************************************************************
*       Copyright (c) 2008, Cisco Systems, All Rights Reserved
***************************************************************************
*
*  File:    ConnectPromptInfoBase.h
*  Date:    01/2008
*
***************************************************************************
*
*   Connect Prompt Info base class implementation for the Client API.
*
***************************************************************************/

#ifndef _CONNECTPROMPTINFOBASE_
#define _CONNECTPROMPTINFOBASE_

#include "api.h"
#include <list>

class PromptEntry;

typedef enum
{
    HIDDEN,    /**< Indicates the control is not to be displayed */
    ENABLED,   /**< Indicates the control should be displayed and enabled */
    DISABLED   /**< Indicates the control should be displayed but disabled */
} UIControlStateType;

//
// This class is the base class intended to manage the credential data being
// requested from client applications.  It will manage the setup and data
// needed to support the various credential requests.
//


class VPN_VPNAPI ConnectPromptInfoBase
{
    protected:

        ConnectPromptType getConnectPromptType() const;

        unsigned int countPromptEntry() const;

        const tstring &getMessage() const;

        const std::list<tstring> &getListPromptNames(
                                   std::list<tstring> &listPromptNames) const;

        PromptEntry *getPromptEntry(const tstring &promptName) const;

        const std::list<PromptEntry *> &getListPromptEntry() const;

        bool hasAuthenticationError() const;

        const tstring &getSubmitButtonName() const;

        bool hasEnrollmentCA() const;

        void setUseEnrollmentCA(bool bUseEnrollmentCA);

        bool isEmpty() const;

    public:

        // set the button to be used for submitting user responses
        //
        void setSubmitButtonName(const tstring &buttonName);

        void setConnectPromptType(ConnectPromptType connectPromptType);

        bool isCanceled() const;

        void setCanceled(bool bIsCanceled);

        // BUGBUG: Cwrapper/API and COM API need to be updated with getResponseError and setResponseError
        UserResponseError getResponseError() const;
    
        void setResponseError(UserResponseError err);
    
        void setMessage(tstring message);

        void setAuthenticationError(int iAuthError);
        int getAuthenticationError() const;

        void setAuthenticationErrorMessage(const tstring &authErrorMessage);
        tstring  getAuthenticationErrorMessage() const;

        // PromptEntry objects added using this method will be managed
        // by this object.  This can include deletion.
        //
        void addPromptEntry(PromptEntry *promptEntry);
        void insertPromptEntry(PromptEntry *promptEntry);
        void removeMatchingPromptEntry(PromptType promptType);
        void clearPasswordData();

        void setHasEnrollmentCA(bool bHasEnrollmentCA);

        bool useEnrollmentCA() const;

        
        // determine if request originated as web or standalone
        //
        void setAgentRequest(bool agentRequest);

        bool isAgentRequest() const;

        bool isAutoSubmit() const;
        void setAutoSubmit(bool bIsAutoSubmit);

        // Set actively selected group.
        // This method will update the value and enabled properties of the
        // contained credential PromptEntry objects.
        //
        bool setTunnelGroup(const tstring &group);


        // reset the contents of this object back to initialized state.
        // This method removes all data currently in this object instance.
        //
        void reset();

        // is this instance empty or is there some useable data
        //
        bool valid() const;

        void setButtonState(UIControlStateType state) {me_buttonState = state;};
        UIControlStateType getButtonState() {return me_buttonState;};

        // generate a formatted output of PromptEntry contents.
        //
        tstring toString() const;

        ConnectPromptInfoBase(tstring defaultSubmitButtonName);
        explicit ConnectPromptInfoBase(const ConnectPromptInfoBase &copyCtor);
        ConnectPromptInfoBase& operator=(const ConnectPromptInfoBase &inst);
        virtual ~ConnectPromptInfoBase();

    private:
        tstring mso_defaultMessage;
        tstring mso_certificateMessage;
        tstring mso_authErrorMessage;
        tstring ms_defaultSubmitButtonName;
        tstring ms_SubmitButtonName;

        std::list<PromptEntry *> mlo_PromptEntry;

        ConnectPromptType me_ConnectPromptType;

        bool mb_isCanceled;
        UserResponseError m_responseError;
        int  mi_AuthenticationError;
        bool mb_HasEnrollmentCA;
        bool mb_UseEnrollmentCA;
        bool mb_AgentRequest;
        bool mb_isAutoSubmit;

        UIControlStateType me_buttonState;

};


#endif // _CONNECTPROMPTINFOBASE_
