/******************************************************************************\
 *  This sample is supplied as is with no implied warranty.  
 *  It is designed to assist you in using the Cisco AnyConnect VPN API. 
 *  It is assumed that you will build a production application and 
 *  refer to this sample as a reference only.
 \*****************************************************************************/

#ifndef _GUICLIENTIMPL_
#define _GUICLIENTIMPL_

#include "ClientIfc.h"

enum RequestType { REQ_CONNECT, REQ_GROUPLIST, REQ_END };

class MainDialog;

/**
 * This is an example application demonstrating the implementation of the
 * AnyConnect API
 */

class GUIClientImpl : public ClientIfc
{
    public:

        GUIClientImpl( MainDialog *parent );
        virtual ~GUIClientImpl();

        bool connect(tstring host);
        
        tstring ms_user,
                ms_pswd,
                ms_group;

        void setUserData(ConnectPromptInfo &ConnectPrompt);

    protected:

        ConnectPromptInfo *m_pConnectPrompt;
        MainDialog *parentWindow;

        void StatsCB(IN VPNStats &stats);

        void StateCB(IN const VPNState state,
                     IN const VPNSubState subState,
                     IN const tstring stateString);

        void BannerCB(IN const tstring &banner);

        void NoticeCB(IN const tstring notice,
                      IN const MessageType type);

        void ExitNoticeCB(IN const tstring &notice, const int returnCode);

        void ServiceReadyCB();

        void UserPromptCB(IN ConnectPromptInfo &ConnectPrompt);

        void CertBlockedCB(IN const tstring &rtstrUntrustedServer);
        void CertWarningCB(IN const tstring &rtstrUntrustedServer,
                           IN const std::list<tstring> &rltstrCertErrors,
                           IN bool bAllowImport);

        /**
         * The implementation of this method and subsequent call on
         * MainDialog::HandleEventAvailable demonstrates the posting of
         * an event.
         */
        void EventAvailable();

            
     private:

        RequestType me_RequestType;

};


#endif // _GUICLIENTIMPL_
