/********************************************************************************\
*  This sample is supplied as is with no implied warranty.  
*  It is designed to assist you in using the Cisco AnyConnect VPN API. 
*  It is assumed that you will build a production application and 
*  refer to this sample as a reference only.
\********************************************************************************/
#pragma once
#include <list>
#include "resource.h"

// CDlgStatusBar dialog
class CDlgStatusBar : public CStatusBar
{
public:
	CDlgStatusBar();
	virtual ~CDlgStatusBar();

protected:
	// Generated message map functions
	//{{AFX_MSG(CDlgStatusBar)
	afx_msg LRESULT OnIdleUpdateCmdUI(WPARAM wParam, LPARAM);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//CBannerDlg dialog
class CBannerDlg : public CDialog
{
public:
    CBannerDlg(CString strBannerMessage);
	enum { IDD = IDD_BANNER_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()

private:
    CString m_strBannerMessage;
};

//CVPNRoutes dialog
class CVPNRoutesDlg : public CDialog
{
public:
    CVPNRoutesDlg(CWnd* pParent = NULL);

    void UpdateStats(const CComPtr<IVpnStats>& spVpnStats);

	enum { IDD = IDD_VPNROUTES_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);
    virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()
private:
    bool m_bIsFirstTime;
public:
    CListCtrl m_SecureRoutesListCtrl;
    CListCtrl m_NonSecureRoutesListCtrl;
};

//CVPNStats dialog
class CVPNStatsDlg : public CDialog
{
public:
    CVPNStatsDlg(CWnd* pParent = NULL);

    void AttachVpnApi(const CComPtr<IVpnApi>& spVpnApi) {m_spVpnApi = spVpnApi;}
    void UpdateStats(const CComPtr<IVpnStats>& spVpnStats);

	enum { IDD = IDD_VPNSTATS_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX); 
    virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()
public:
    afx_msg void OnBnClickedResetStats();
    afx_msg void OnBnClickedStopStartStats();
private:
    CComPtr<IVpnApi> m_spVpnApi;
    bool m_bIsFirstTime;
    bool m_bIsStarted;
};


//CVPNProtocol dialog
class CVPNProtocolDlg : public CDialog
{
public:
    CVPNProtocolDlg(CWnd* pParent = NULL);

    void UpdateStats(const CComPtr<IVpnStats>& spVpnStats);

    enum { IDD = IDD_VPNPROTOCOL_DIALOG };

protected:
    virtual void DoDataExchange(CDataExchange* pDX);
    virtual BOOL OnInitDialog();

    DECLARE_MESSAGE_MAP()
private:
    CListCtrl m_ProtocolListCtrl;
    bool m_bIsFirstTime;
public:
};

// CVpnFirewall dialog

class CVpnFirewall : public CDialog
{
    DECLARE_DYNAMIC(CVpnFirewall)

public:
    CVpnFirewall(CWnd* pParent = NULL);   // standard constructor
    virtual ~CVpnFirewall();

    void UpdateStats(const CComPtr<IVpnStats>& spVpnStats);
    afx_msg void OnBnClickedOk();

// Dialog Data
    enum { IDD = IDD_FIREWALL_RULES };

protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    virtual BOOL OnInitDialog();

    DECLARE_MESSAGE_MAP()

private:
    CListCtrl m_FirewallRulesCtrl;
    bool m_bIsFirstTime;
};

//CCertBlockedDlg dialog
class CCertBlockedDlg : public CDialog
{
public:
    CCertBlockedDlg(const CString &strUntrustedServer);
	enum { IDD = IDD_CERT_BLOCKED_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()

private:
    CString m_strBlockedMessage;
public:
    afx_msg void OnBnClickedChangeSetting();
    afx_msg void OnBnClickedKeepMeSafe();
};

//CCertWarningDlg dialog
class CCertWarningDlg : public CDialog
{
public:
    CCertWarningDlg(const CString &strUntrustedServer,
                    const std::list<CString> &lCertErrors,
                    bool bImportAllowed);
	enum { IDD = IDD_CERT_WARNING_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()

private:
    CString m_strWarningMessage;
    bool m_bImportAllowed;
public:
    afx_msg void OnBnClickedContinue();
    afx_msg void OnBnClickedAlwaysConnect();
    afx_msg void OnBnClickedCancel();
};
